/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.toolchain;

import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.internal.build.event.types.AbstractOperationResult;
import org.gradle.internal.build.event.types.DefaultFailure;
import org.gradle.internal.build.event.types.DefaultFileDownloadDescriptor;
import org.gradle.internal.build.event.types.DefaultFileDownloadFailureResult;
import org.gradle.internal.build.event.types.DefaultFileDownloadSuccessResult;
import org.gradle.internal.build.event.types.DefaultOperationDescriptor;
import org.gradle.internal.build.event.types.DefaultOperationFinishedProgressEvent;
import org.gradle.internal.build.event.types.DefaultOperationStartedProgressEvent;
import org.gradle.internal.build.event.types.DefaultStatusEvent;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.logging.progress.ResourceOperation;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.util.NumberUtil;
import org.gradle.launcher.daemon.toolchain.DownloadProgressListener;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;

public class ToolchainDownloadProgressListener
implements DownloadProgressListener {
    private final ProgressLogger progressLogger;
    private final Optional<InternalBuildProgressListener> buildProgressListener;
    private final BuildOperationIdFactory operationIdFactory;
    @Nullable
    private DefaultFileDownloadDescriptor defaultFileDownloadDescriptor;

    public ToolchainDownloadProgressListener(ProgressLoggerFactory progressLoggerFactory, Optional<InternalBuildProgressListener> buildProgressListener, BuildOperationIdFactory operationIdFactory) {
        this.progressLogger = progressLoggerFactory.newOperation(ToolchainDownloadProgressListener.class);
        this.buildProgressListener = buildProgressListener;
        this.operationIdFactory = operationIdFactory;
    }

    @Override
    public void downloadStarted(URI uri, long contentLengthBytes, long startTime) {
        this.progressLogger.start("Downloading toolchain from URI " + uri, null);
        if (this.buildProgressListener.isPresent()) {
            String displayName = this.getDisplayName(uri);
            assert (this.defaultFileDownloadDescriptor == null);
            this.defaultFileDownloadDescriptor = new DefaultFileDownloadDescriptor(new OperationIdentifier(this.operationIdFactory.nextId()), displayName, displayName + " as a JVM for starting the Gradle daemon", null, uri);
            DefaultOperationStartedProgressEvent startEvent = new DefaultOperationStartedProgressEvent(startTime, (DefaultOperationDescriptor)this.defaultFileDownloadDescriptor);
            this.buildProgressListener.get().onEvent((Object)startEvent);
        }
    }

    @Override
    public void downloadStatusChanged(URI uri, long downloadedBytes, long contentLengthBytes, long eventTime) {
        String downloadProgressMessage = String.format("Downloading toolchain from URI %s > %s/%s %sed", uri, NumberUtil.formatBytes((Long)downloadedBytes), NumberUtil.formatBytes((Long)contentLengthBytes), ResourceOperation.Type.download);
        this.progressLogger.progress(downloadProgressMessage);
        this.buildProgressListener.ifPresent(listener -> listener.onEvent((Object)new DefaultStatusEvent(eventTime, this.defaultFileDownloadDescriptor, downloadedBytes, contentLengthBytes, "bytes")));
    }

    @Override
    public void downloadFinished(URI uri, long downloadedBytes, long startTime, long finishTime) {
        this.progressLogger.completed("Downloaded toolchain " + uri, false);
        this.buildProgressListener.ifPresent(listener -> {
            DefaultFileDownloadSuccessResult result = new DefaultFileDownloadSuccessResult(startTime, finishTime, downloadedBytes);
            listener.onEvent((Object)new DefaultOperationFinishedProgressEvent(finishTime, (DefaultOperationDescriptor)this.defaultFileDownloadDescriptor, (AbstractOperationResult)result));
        });
    }

    @Override
    public void downloadFailed(URI uri, Exception exception, long downloadedBytes, long startTime, long finishTime) {
        this.progressLogger.completed("Failed to download toolchain " + uri, true);
        this.buildProgressListener.ifPresent(listener -> {
            DefaultFileDownloadFailureResult result = new DefaultFileDownloadFailureResult(startTime, finishTime, Collections.singletonList(DefaultFailure.fromThrowable((Throwable)exception)), downloadedBytes);
            listener.onEvent((Object)new DefaultOperationFinishedProgressEvent(finishTime, (DefaultOperationDescriptor)this.defaultFileDownloadDescriptor, (AbstractOperationResult)result));
        });
    }

    private String getDisplayName(URI uri) {
        return String.format("Download %s", uri);
    }
}

