/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.i18n.AbstractMessageHandler;
import org.pentaho.di.i18n.GlobalMessageUtil;
import org.pentaho.di.i18n.LanguageChoice;
import org.pentaho.di.i18n.LoaderInputStreamProvider;
import org.pentaho.di.i18n.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalMessages
extends AbstractMessageHandler {
    private static String packageNM = GlobalMessages.class.getPackage().getName();
    protected static final ThreadLocal<Locale> threadLocales = new ThreadLocal();
    protected static final LanguageChoice langChoice = LanguageChoice.getInstance();
    protected static final String SYSTEM_BUNDLE_PACKAGE = GlobalMessages.class.getPackage().getName();
    protected static final String BUNDLE_NAME = "messages.messages";
    protected static final Map<String, ResourceBundle> locales = Collections.synchronizedMap(new HashMap());
    public static final String[] localeCodes = new String[]{"en_US", "nl_NL", "zh_CN", "es_ES", "fr_FR", "de_DE", "pt_BR", "pt_PT", "es_AR", "no_NO", "it_IT", "ja_JP", "ko_KR"};
    public static final String[] localeDescr = new String[]{"English (US)", "Nederlands", "Simplified Chinese", "Espa\u00f1ol (Spain)", "Fran\u00e7ais", "Deutsch", "Portuguese (Brazil)", "Portuguese (Portugal)", "Espa\u00f1ol (Argentina)", "Norwegian (Norway)", "Italian (Italy)", "Japanese (Japan)", "Korean (Korea)"};
    protected static GlobalMessages GMinstance = null;

    public static synchronized MessageHandler getInstance() {
        if (GMinstance == null) {
            GMinstance = new GlobalMessages();
        }
        return GMinstance;
    }

    protected static Map<String, ResourceBundle> getLocales() {
        return locales;
    }

    public static synchronized Locale getLocale() {
        Locale rtn = threadLocales.get();
        if (rtn != null) {
            return rtn;
        }
        GlobalMessages.setLocale(langChoice.getDefaultLocale());
        return langChoice.getDefaultLocale();
    }

    public static synchronized void setLocale(Locale newLocale) {
        threadLocales.set(newLocale);
    }

    protected static String getLocaleString(Locale locale) {
        String locString = locale.toString();
        if (locString.length() == 5 && locString.charAt(2) == '_') {
            locString = locString.substring(0, 2).toLowerCase() + "_" + locString.substring(3).toUpperCase();
        }
        return locString;
    }

    protected static String buildHashKey(Locale locale, String packageName) {
        return packageName + "_" + GlobalMessages.getLocaleString(locale);
    }

    protected static String buildBundleName(String packageName) {
        return packageName + "." + BUNDLE_NAME;
    }

    public static ResourceBundle getBundle(Locale locale, String packageName) throws MissingResourceException {
        String filename = GlobalMessages.buildHashKey(locale, packageName);
        filename = "/" + filename.replace('.', '/') + ".properties";
        try {
            ResourceBundle bundle = locales.get(filename);
            if (bundle == null) {
                LoaderInputStreamProvider inputStreamProvider;
                Method getInstanceMethod;
                Class<?> stepLoaderClass;
                InputStream inputStream = LanguageChoice.getInstance().getClass().getResourceAsStream(filename);
                if (inputStream == null) {
                    try {
                        stepLoaderClass = Class.forName("org.pentaho.di.trans.StepLoader");
                        getInstanceMethod = stepLoaderClass.getMethod("getInstance", new Class[0]);
                        inputStreamProvider = (LoaderInputStreamProvider)getInstanceMethod.invoke(null, new Object[0]);
                        inputStream = inputStreamProvider.getInputStreamForFile(filename);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (inputStream == null) {
                    try {
                        stepLoaderClass = Class.forName("org.pentaho.di.job.JobEntryLoader");
                        getInstanceMethod = stepLoaderClass.getMethod("getInstance", new Class[0]);
                        inputStreamProvider = (LoaderInputStreamProvider)getInstanceMethod.invoke(null, new Object[0]);
                        inputStream = inputStreamProvider.getInputStreamForFile(filename);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    bundle = new PropertyResourceBundle(inputStream);
                    locales.put(filename, bundle);
                } else {
                    throw new MissingResourceException("Unable to find properties file [" + filename + "]", locale.toString(), packageName);
                }
            }
            return bundle;
        }
        catch (IOException e) {
            throw new MissingResourceException("Unable to find properties file [" + filename + "] : " + e.toString(), locale.toString(), packageName);
        }
    }

    @Deprecated
    public static String getSystemString(String key) {
        try {
            return GlobalMessageUtil.getString(GlobalMessages.getBundle(langChoice.getDefaultLocale(), GlobalMessages.buildBundleName(SYSTEM_BUNDLE_PACKAGE)), key);
        }
        catch (MissingResourceException e) {
            try {
                return GlobalMessageUtil.getString(GlobalMessages.getBundle(langChoice.getFailoverLocale(), GlobalMessages.buildBundleName(SYSTEM_BUNDLE_PACKAGE)), key);
            }
            catch (MissingResourceException fe) {
                LogWriter.getInstance().logError("Internationalisation/Translation error", Const.getStackTracker(e), new Object[0]);
                return '!' + key + '!';
            }
        }
    }

    @Deprecated
    public static String getSystemString(String key, String param1) {
        try {
            return GlobalMessageUtil.getString(GlobalMessages.getBundle(langChoice.getDefaultLocale(), GlobalMessages.buildBundleName(SYSTEM_BUNDLE_PACKAGE)), key, param1);
        }
        catch (MissingResourceException e) {
            try {
                return GlobalMessageUtil.getString(GlobalMessages.getBundle(langChoice.getFailoverLocale(), GlobalMessages.buildBundleName(SYSTEM_BUNDLE_PACKAGE)), key, param1);
            }
            catch (MissingResourceException fe) {
                LogWriter.getInstance().logError("Internationalisation/Translation error", Const.getStackTracker(e), new Object[0]);
                return '!' + key + '!';
            }
        }
    }

    @Deprecated
    public static String getSystemString(String key, String param1, String param2) {
        try {
            return GlobalMessageUtil.getString(GlobalMessages.getBundle(langChoice.getFailoverLocale(), GlobalMessages.buildBundleName(SYSTEM_BUNDLE_PACKAGE)), key, param1, param2);
        }
        catch (MissingResourceException e) {
            try {
                return GlobalMessageUtil.getString(GlobalMessages.getBundle(langChoice.getFailoverLocale(), GlobalMessages.buildBundleName(SYSTEM_BUNDLE_PACKAGE)), key, param1, param2);
            }
            catch (MissingResourceException fe) {
                LogWriter.getInstance().logError("Internationalisation/Translation error", Const.getStackTracker(e), new Object[0]);
                return '!' + key + '!';
            }
        }
    }

    @Deprecated
    public static String getSystemString(String key, String param1, String param2, String param3) {
        try {
            return GlobalMessageUtil.getString(GlobalMessages.getBundle(langChoice.getFailoverLocale(), GlobalMessages.buildBundleName(SYSTEM_BUNDLE_PACKAGE)), key, param1, param2, param3);
        }
        catch (MissingResourceException e) {
            try {
                return GlobalMessageUtil.getString(GlobalMessages.getBundle(langChoice.getFailoverLocale(), GlobalMessages.buildBundleName(SYSTEM_BUNDLE_PACKAGE)), key, param1, param2, param3);
            }
            catch (MissingResourceException fe) {
                LogWriter.getInstance().logError("Internationalisation/Translation error", Const.getStackTracker(e), new Object[0]);
                return '!' + key + '!';
            }
        }
    }

    @Deprecated
    public static String getSystemString(String key, String param1, String param2, String param3, String param4) {
        try {
            return GlobalMessageUtil.getString(GlobalMessages.getBundle(langChoice.getFailoverLocale(), GlobalMessages.buildBundleName(SYSTEM_BUNDLE_PACKAGE)), key, param1, param2, param3, param4);
        }
        catch (MissingResourceException e) {
            try {
                return GlobalMessageUtil.getString(GlobalMessages.getBundle(langChoice.getFailoverLocale(), GlobalMessages.buildBundleName(SYSTEM_BUNDLE_PACKAGE)), key, param1, param2, param3, param4);
            }
            catch (MissingResourceException fe) {
                LogWriter.getInstance().logError("Internationalisation/Translation error", Const.getStackTracker(e), new Object[0]);
                return '!' + key + '!';
            }
        }
    }

    @Deprecated
    public static String getSystemString(String key, String param1, String param2, String param3, String param4, String param5) {
        try {
            return GlobalMessageUtil.getString(GlobalMessages.getBundle(langChoice.getFailoverLocale(), GlobalMessages.buildBundleName(SYSTEM_BUNDLE_PACKAGE)), key, param1, param2, param3, param4, param5);
        }
        catch (MissingResourceException e) {
            try {
                return GlobalMessageUtil.getString(GlobalMessages.getBundle(langChoice.getFailoverLocale(), GlobalMessages.buildBundleName(SYSTEM_BUNDLE_PACKAGE)), key, param1, param2, param3, param4, param5);
            }
            catch (MissingResourceException fe) {
                LogWriter.getInstance().logError("Internationalisation/Translation error", Const.getStackTracker(e), new Object[0]);
                return '!' + key + '!';
            }
        }
    }

    @Deprecated
    public static String getSystemString(String key, String param1, String param2, String param3, String param4, String param5, String param6) {
        try {
            return GlobalMessageUtil.getString(GlobalMessages.getBundle(langChoice.getFailoverLocale(), GlobalMessages.buildBundleName(SYSTEM_BUNDLE_PACKAGE)), key, param1, param2, param3, param4, param5, param6);
        }
        catch (MissingResourceException e) {
            try {
                return GlobalMessageUtil.getString(GlobalMessages.getBundle(langChoice.getFailoverLocale(), GlobalMessages.buildBundleName(SYSTEM_BUNDLE_PACKAGE)), key, param1, param2, param3, param4, param5, param6);
            }
            catch (MissingResourceException fe) {
                LogWriter.getInstance().logError("Internationalisation/Translation error", Const.getStackTracker(e), new Object[0]);
                return '!' + key + '!';
            }
        }
    }

    protected String findString(String packageName, Locale locale, String key, Object[] parameters) throws MissingResourceException {
        try {
            ResourceBundle bundle = GlobalMessages.getBundle(locale, packageName + "." + BUNDLE_NAME);
            String unformattedString = bundle.getString(key);
            String string = MessageFormat.format(unformattedString, parameters);
            return string;
        }
        catch (IllegalArgumentException e) {
            String message = "Format problem with key=[" + key + "], locale=[" + locale + "], package=" + packageName + " : " + e.toString();
            LogWriter.getInstance().logError("i18n", message, new Object[0]);
            LogWriter.getInstance().logError("i18n", Const.getStackTracker(e), new Object[0]);
            throw new MissingResourceException(message, packageName, key);
        }
    }

    protected String calculateString(String packageName, String key, Object[] parameters) {
        String string = null;
        try {
            string = this.findString(packageName, langChoice.getDefaultLocale(), key, parameters);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        try {
            string = this.findString(SYSTEM_BUNDLE_PACKAGE, langChoice.getDefaultLocale(), key, parameters);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        try {
            string = this.findString(packageName, langChoice.getFailoverLocale(), key, parameters);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        try {
            string = this.findString(SYSTEM_BUNDLE_PACKAGE, langChoice.getFailoverLocale(), key, parameters);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        string = "!" + key + "!";
        String message = "Message not found in the preferred and failover locale: key=[" + key + "], package=" + packageName;
        LogWriter.getInstance().logDetailed("i18n", Const.getStackTracker(new KettleException(message)), new Object[0]);
        return string;
    }

    @Override
    public String getString(String key) {
        Object[] parameters = null;
        return this.calculateString(packageNM, key, parameters);
    }

    @Override
    public String getString(String packageName, String key) {
        Object[] parameters = new Object[]{};
        return this.calculateString(packageName, key, parameters);
    }

    @Override
    public String getString(String packageName, String key, String param1) {
        Object[] parameters = new Object[]{param1};
        return this.calculateString(packageName, key, parameters);
    }

    @Override
    public String getString(String packageName, String key, String param1, String param2) {
        Object[] parameters = new Object[]{param1, param2};
        return this.calculateString(packageName, key, parameters);
    }

    @Override
    public String getString(String packageName, String key, String param1, String param2, String param3) {
        Object[] parameters = new Object[]{param1, param2, param3};
        return this.calculateString(packageName, key, parameters);
    }

    @Override
    public String getString(String packageName, String key, String param1, String param2, String param3, String param4) {
        Object[] parameters = new Object[]{param1, param2, param3, param4};
        return this.calculateString(packageName, key, parameters);
    }

    @Override
    public String getString(String packageName, String key, String param1, String param2, String param3, String param4, String param5) {
        Object[] parameters = new Object[]{param1, param2, param3, param4, param5};
        return this.calculateString(packageName, key, parameters);
    }

    @Override
    public String getString(String packageName, String key, String param1, String param2, String param3, String param4, String param5, String param6) {
        Object[] parameters = new Object[]{param1, param2, param3, param4, param5, param6};
        return this.calculateString(packageName, key, parameters);
    }
}

