# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class AuthorizationsService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """AuthorizationsService - a operation defined in OpenAPI."""
        super().__init__(api_client)

    def delete_authorizations_id(self, auth_id, **kwargs):  # noqa: E501,D401,D403
        """Delete an authorization.

        Deletes an authorization.  Use the endpoint to delete an API token.  If you want to disable an API token instead of delete it, [update the authorization's status to `inactive`](#operation/PatchAuthorizationsID).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_authorizations_id(auth_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_id: An authorization ID. Specifies the authorization to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_authorizations_id_with_http_info(auth_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_authorizations_id_with_http_info(auth_id, **kwargs)  # noqa: E501
            return data

    def delete_authorizations_id_with_http_info(self, auth_id, **kwargs):  # noqa: E501,D401,D403
        """Delete an authorization.

        Deletes an authorization.  Use the endpoint to delete an API token.  If you want to disable an API token instead of delete it, [update the authorization's status to `inactive`](#operation/PatchAuthorizationsID).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_authorizations_id_with_http_info(auth_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_id: An authorization ID. Specifies the authorization to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_authorizations_id_prepare(auth_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/authorizations/{authID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_authorizations_id_async(self, auth_id, **kwargs):  # noqa: E501,D401,D403
        """Delete an authorization.

        Deletes an authorization.  Use the endpoint to delete an API token.  If you want to disable an API token instead of delete it, [update the authorization's status to `inactive`](#operation/PatchAuthorizationsID).
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str auth_id: An authorization ID. Specifies the authorization to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_authorizations_id_prepare(auth_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/authorizations/{authID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_authorizations_id_prepare(self, auth_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['auth_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_authorizations_id', all_params, local_var_params)
        # verify the required parameter 'auth_id' is set
        if ('auth_id' not in local_var_params or
                local_var_params['auth_id'] is None):
            raise ValueError("Missing the required parameter `auth_id` when calling `delete_authorizations_id`")  # noqa: E501

        path_params = {}
        if 'auth_id' in local_var_params:
            path_params['authID'] = local_var_params['auth_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_authorizations(self, **kwargs):  # noqa: E501,D401,D403
        """List authorizations.

        Lists authorizations.  To limit which authorizations are returned, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all authorizations.  #### InfluxDB Cloud  - InfluxDB Cloud doesn't expose [API token](https://docs.influxdata.com/influxdb/latest/reference/glossary/#token)   values in `GET /api/v2/authorizations` responses;   returns `token: redacted` for all authorizations.  #### Required permissions  To retrieve an authorization, the request must use an API token that has the following permissions:  - `read-authorizations` - `read-user` for the user that the authorization is scoped to  #### Related guides  - [View tokens](https://docs.influxdata.com/influxdb/latest/security/tokens/view-tokens/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_authorizations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str user_id: A user ID. Only returns authorizations scoped to the specified [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).
        :param str user: A user name. Only returns authorizations scoped to the specified [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).
        :param str org_id: An organization ID. Only returns authorizations that belong to the specified [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization).
        :param str org: An organization name. Only returns authorizations that belong to the specified [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization).
        :param str token: An API [token](https://docs.influxdata.com/influxdb/latest/reference/glossary/#token) value. Specifies an authorization by its `token` property value and returns the authorization.  #### InfluxDB OSS  - Doesn't support this parameter. InfluxDB OSS ignores the `token=` parameter,   applies other parameters, and then returns the result.  #### Limitations  - The parameter is non-repeatable. If you specify more than one,   only the first one is used. If a resource with the specified   property value doesn't exist, then the response body contains an empty list.
        :return: Authorizations
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_authorizations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_authorizations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_authorizations_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """List authorizations.

        Lists authorizations.  To limit which authorizations are returned, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all authorizations.  #### InfluxDB Cloud  - InfluxDB Cloud doesn't expose [API token](https://docs.influxdata.com/influxdb/latest/reference/glossary/#token)   values in `GET /api/v2/authorizations` responses;   returns `token: redacted` for all authorizations.  #### Required permissions  To retrieve an authorization, the request must use an API token that has the following permissions:  - `read-authorizations` - `read-user` for the user that the authorization is scoped to  #### Related guides  - [View tokens](https://docs.influxdata.com/influxdb/latest/security/tokens/view-tokens/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_authorizations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str user_id: A user ID. Only returns authorizations scoped to the specified [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).
        :param str user: A user name. Only returns authorizations scoped to the specified [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).
        :param str org_id: An organization ID. Only returns authorizations that belong to the specified [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization).
        :param str org: An organization name. Only returns authorizations that belong to the specified [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization).
        :param str token: An API [token](https://docs.influxdata.com/influxdb/latest/reference/glossary/#token) value. Specifies an authorization by its `token` property value and returns the authorization.  #### InfluxDB OSS  - Doesn't support this parameter. InfluxDB OSS ignores the `token=` parameter,   applies other parameters, and then returns the result.  #### Limitations  - The parameter is non-repeatable. If you specify more than one,   only the first one is used. If a resource with the specified   property value doesn't exist, then the response body contains an empty list.
        :return: Authorizations
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_authorizations_prepare(**kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/authorizations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Authorizations',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_authorizations_async(self, **kwargs):  # noqa: E501,D401,D403
        """List authorizations.

        Lists authorizations.  To limit which authorizations are returned, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all authorizations.  #### InfluxDB Cloud  - InfluxDB Cloud doesn't expose [API token](https://docs.influxdata.com/influxdb/latest/reference/glossary/#token)   values in `GET /api/v2/authorizations` responses;   returns `token: redacted` for all authorizations.  #### Required permissions  To retrieve an authorization, the request must use an API token that has the following permissions:  - `read-authorizations` - `read-user` for the user that the authorization is scoped to  #### Related guides  - [View tokens](https://docs.influxdata.com/influxdb/latest/security/tokens/view-tokens/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str user_id: A user ID. Only returns authorizations scoped to the specified [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).
        :param str user: A user name. Only returns authorizations scoped to the specified [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).
        :param str org_id: An organization ID. Only returns authorizations that belong to the specified [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization).
        :param str org: An organization name. Only returns authorizations that belong to the specified [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization).
        :param str token: An API [token](https://docs.influxdata.com/influxdb/latest/reference/glossary/#token) value. Specifies an authorization by its `token` property value and returns the authorization.  #### InfluxDB OSS  - Doesn't support this parameter. InfluxDB OSS ignores the `token=` parameter,   applies other parameters, and then returns the result.  #### Limitations  - The parameter is non-repeatable. If you specify more than one,   only the first one is used. If a resource with the specified   property value doesn't exist, then the response body contains an empty list.
        :return: Authorizations
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_authorizations_prepare(**kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/authorizations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Authorizations',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_authorizations_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['zap_trace_span', 'user_id', 'user', 'org_id', 'org', 'token']  # noqa: E501
        self._check_operation_params('get_authorizations', all_params, local_var_params)

        path_params = {}

        query_params = []
        if 'user_id' in local_var_params:
            query_params.append(('userID', local_var_params['user_id']))  # noqa: E501
        if 'user' in local_var_params:
            query_params.append(('user', local_var_params['user']))  # noqa: E501
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501
        if 'token' in local_var_params:
            query_params.append(('token', local_var_params['token']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_authorizations_id(self, auth_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve an authorization.

        Retrieves an authorization.  Use this endpoint to retrieve information about an API token, including the token's permissions and the user that the token is scoped to.  #### InfluxDB OSS  - InfluxDB OSS returns   [API token](https://docs.influxdata.com/influxdb/latest/reference/glossary/#token) values in authorizations. - If the request uses an _[operator token](https://docs.influxdata.com/influxdb/latest/security/tokens/#operator-token)_,   InfluxDB OSS returns authorizations for all organizations in the instance.  #### Related guides  - [View tokens](https://docs.influxdata.com/influxdb/latest/security/tokens/view-tokens/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_authorizations_id(auth_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_id: An authorization ID. Specifies the authorization to retrieve. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Authorization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_authorizations_id_with_http_info(auth_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_authorizations_id_with_http_info(auth_id, **kwargs)  # noqa: E501
            return data

    def get_authorizations_id_with_http_info(self, auth_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve an authorization.

        Retrieves an authorization.  Use this endpoint to retrieve information about an API token, including the token's permissions and the user that the token is scoped to.  #### InfluxDB OSS  - InfluxDB OSS returns   [API token](https://docs.influxdata.com/influxdb/latest/reference/glossary/#token) values in authorizations. - If the request uses an _[operator token](https://docs.influxdata.com/influxdb/latest/security/tokens/#operator-token)_,   InfluxDB OSS returns authorizations for all organizations in the instance.  #### Related guides  - [View tokens](https://docs.influxdata.com/influxdb/latest/security/tokens/view-tokens/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_authorizations_id_with_http_info(auth_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_id: An authorization ID. Specifies the authorization to retrieve. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Authorization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_authorizations_id_prepare(auth_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/authorizations/{authID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Authorization',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_authorizations_id_async(self, auth_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve an authorization.

        Retrieves an authorization.  Use this endpoint to retrieve information about an API token, including the token's permissions and the user that the token is scoped to.  #### InfluxDB OSS  - InfluxDB OSS returns   [API token](https://docs.influxdata.com/influxdb/latest/reference/glossary/#token) values in authorizations. - If the request uses an _[operator token](https://docs.influxdata.com/influxdb/latest/security/tokens/#operator-token)_,   InfluxDB OSS returns authorizations for all organizations in the instance.  #### Related guides  - [View tokens](https://docs.influxdata.com/influxdb/latest/security/tokens/view-tokens/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str auth_id: An authorization ID. Specifies the authorization to retrieve. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Authorization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_authorizations_id_prepare(auth_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/authorizations/{authID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Authorization',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_authorizations_id_prepare(self, auth_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['auth_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_authorizations_id', all_params, local_var_params)
        # verify the required parameter 'auth_id' is set
        if ('auth_id' not in local_var_params or
                local_var_params['auth_id'] is None):
            raise ValueError("Missing the required parameter `auth_id` when calling `get_authorizations_id`")  # noqa: E501

        path_params = {}
        if 'auth_id' in local_var_params:
            path_params['authID'] = local_var_params['auth_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def patch_authorizations_id(self, auth_id, authorization_update_request, **kwargs):  # noqa: E501,D401,D403
        """Update an API token to be active or inactive.

        Updates an authorization.  Use this endpoint to set an API token's status to be _active_ or _inactive_. InfluxDB rejects requests that use inactive API tokens.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_authorizations_id(auth_id, authorization_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_id: An authorization ID. Specifies the authorization to update. (required)
        :param AuthorizationUpdateRequest authorization_update_request: In the request body, provide the authorization properties to update. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Authorization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_authorizations_id_with_http_info(auth_id, authorization_update_request, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_authorizations_id_with_http_info(auth_id, authorization_update_request, **kwargs)  # noqa: E501
            return data

    def patch_authorizations_id_with_http_info(self, auth_id, authorization_update_request, **kwargs):  # noqa: E501,D401,D403
        """Update an API token to be active or inactive.

        Updates an authorization.  Use this endpoint to set an API token's status to be _active_ or _inactive_. InfluxDB rejects requests that use inactive API tokens.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_authorizations_id_with_http_info(auth_id, authorization_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auth_id: An authorization ID. Specifies the authorization to update. (required)
        :param AuthorizationUpdateRequest authorization_update_request: In the request body, provide the authorization properties to update. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Authorization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_authorizations_id_prepare(auth_id, authorization_update_request, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/authorizations/{authID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Authorization',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def patch_authorizations_id_async(self, auth_id, authorization_update_request, **kwargs):  # noqa: E501,D401,D403
        """Update an API token to be active or inactive.

        Updates an authorization.  Use this endpoint to set an API token's status to be _active_ or _inactive_. InfluxDB rejects requests that use inactive API tokens.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str auth_id: An authorization ID. Specifies the authorization to update. (required)
        :param AuthorizationUpdateRequest authorization_update_request: In the request body, provide the authorization properties to update. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Authorization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_authorizations_id_prepare(auth_id, authorization_update_request, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/authorizations/{authID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Authorization',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _patch_authorizations_id_prepare(self, auth_id, authorization_update_request, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['auth_id', 'authorization_update_request', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('patch_authorizations_id', all_params, local_var_params)
        # verify the required parameter 'auth_id' is set
        if ('auth_id' not in local_var_params or
                local_var_params['auth_id'] is None):
            raise ValueError("Missing the required parameter `auth_id` when calling `patch_authorizations_id`")  # noqa: E501
        # verify the required parameter 'authorization_update_request' is set
        if ('authorization_update_request' not in local_var_params or
                local_var_params['authorization_update_request'] is None):
            raise ValueError("Missing the required parameter `authorization_update_request` when calling `patch_authorizations_id`")  # noqa: E501

        path_params = {}
        if 'auth_id' in local_var_params:
            path_params['authID'] = local_var_params['auth_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'authorization_update_request' in local_var_params:
            body_params = local_var_params['authorization_update_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_authorizations(self, authorization_post_request, **kwargs):  # noqa: E501,D401,D403
        """Create an authorization.

        Creates an authorization and returns the authorization with the generated API [token](https://docs.influxdata.com/influxdb/latest/reference/glossary/#token).  Use this endpoint to create an authorization, which generates an API token with permissions to `read` or `write` to a specific resource or `type` of resource. The API token is the authorization's `token` property value.  To follow best practices for secure API token generation and retrieval, InfluxDB enforces access restrictions on API tokens.    - InfluxDB allows access to the API token value immediately after the authorization is created.   - You can’t change access (read/write) permissions for an API token after it’s created.   - Tokens stop working when the user who created the token is deleted.  We recommend the following for managing your tokens:    - Create a generic user to create and manage tokens for writing data.   - Store your tokens in a secure password vault for future access.  #### Required permissions  - `write-authorizations` - `write-user` for the user that the authorization is scoped to  #### Related guides  - [Create a token](https://docs.influxdata.com/influxdb/latest/security/tokens/create-token/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_authorizations(authorization_post_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthorizationPostRequest authorization_post_request: The authorization to create. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Authorization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_authorizations_with_http_info(authorization_post_request, **kwargs)  # noqa: E501
        else:
            (data) = self.post_authorizations_with_http_info(authorization_post_request, **kwargs)  # noqa: E501
            return data

    def post_authorizations_with_http_info(self, authorization_post_request, **kwargs):  # noqa: E501,D401,D403
        """Create an authorization.

        Creates an authorization and returns the authorization with the generated API [token](https://docs.influxdata.com/influxdb/latest/reference/glossary/#token).  Use this endpoint to create an authorization, which generates an API token with permissions to `read` or `write` to a specific resource or `type` of resource. The API token is the authorization's `token` property value.  To follow best practices for secure API token generation and retrieval, InfluxDB enforces access restrictions on API tokens.    - InfluxDB allows access to the API token value immediately after the authorization is created.   - You can’t change access (read/write) permissions for an API token after it’s created.   - Tokens stop working when the user who created the token is deleted.  We recommend the following for managing your tokens:    - Create a generic user to create and manage tokens for writing data.   - Store your tokens in a secure password vault for future access.  #### Required permissions  - `write-authorizations` - `write-user` for the user that the authorization is scoped to  #### Related guides  - [Create a token](https://docs.influxdata.com/influxdb/latest/security/tokens/create-token/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_authorizations_with_http_info(authorization_post_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuthorizationPostRequest authorization_post_request: The authorization to create. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Authorization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_authorizations_prepare(authorization_post_request, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/authorizations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Authorization',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_authorizations_async(self, authorization_post_request, **kwargs):  # noqa: E501,D401,D403
        """Create an authorization.

        Creates an authorization and returns the authorization with the generated API [token](https://docs.influxdata.com/influxdb/latest/reference/glossary/#token).  Use this endpoint to create an authorization, which generates an API token with permissions to `read` or `write` to a specific resource or `type` of resource. The API token is the authorization's `token` property value.  To follow best practices for secure API token generation and retrieval, InfluxDB enforces access restrictions on API tokens.    - InfluxDB allows access to the API token value immediately after the authorization is created.   - You can’t change access (read/write) permissions for an API token after it’s created.   - Tokens stop working when the user who created the token is deleted.  We recommend the following for managing your tokens:    - Create a generic user to create and manage tokens for writing data.   - Store your tokens in a secure password vault for future access.  #### Required permissions  - `write-authorizations` - `write-user` for the user that the authorization is scoped to  #### Related guides  - [Create a token](https://docs.influxdata.com/influxdb/latest/security/tokens/create-token/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param AuthorizationPostRequest authorization_post_request: The authorization to create. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Authorization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_authorizations_prepare(authorization_post_request, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/authorizations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Authorization',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_authorizations_prepare(self, authorization_post_request, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['authorization_post_request', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_authorizations', all_params, local_var_params)
        # verify the required parameter 'authorization_post_request' is set
        if ('authorization_post_request' not in local_var_params or
                local_var_params['authorization_post_request'] is None):
            raise ValueError("Missing the required parameter `authorization_post_request` when calling `post_authorizations`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'authorization_post_request' in local_var_params:
            body_params = local_var_params['authorization_post_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
