/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dmat3x2(0.09lf, -1.19lf, 1.3lf, 0.08lf, 1.25lf, 1.08lf) * dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec2(-2.4lf, 0.5034666666666663lf)
 * (dmat3x2(0.09lf, -1.19lf, 1.3lf, 0.08lf, 1.25lf, 1.08lf) * dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec2(3.3458000000000006lf, 0.08510000000000018lf)
 * (dmat3x2(-0.36lf, -0.53lf, -1.08lf, 0.88lf, -0.6lf, -1.79lf) * dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec2(1.9620000000000002lf, 1.6412666666666667lf)
 * (dmat3x2(-0.36lf, -0.53lf, -1.08lf, 0.88lf, -0.6lf, -1.79lf) * dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec2(-2.436lf, -3.6516lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dmat3x2(0.09lf, -1.19lf, 1.3lf, 0.08lf, 1.25lf, 1.08lf) * dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec2(-2.4lf, 0.5034666666666663lf)) <= 2.4522395242807023e-05lf ? 1 : -1] array0;
  double[distance((dmat3x2(0.09lf, -1.19lf, 1.3lf, 0.08lf, 1.25lf, 1.08lf) * dvec3(1.67lf, 0.66lf, 1.87lf)), dvec2(3.3458000000000006lf, 0.08510000000000018lf)) <= 3.346882078890741e-05lf ? 1 : -1] array1;
  double[distance((dmat3x2(-0.36lf, -0.53lf, -1.08lf, 0.88lf, -0.6lf, -1.79lf) * dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec2(1.9620000000000002lf, 1.6412666666666667lf)) <= 2.5579679964986098e-05lf ? 1 : -1] array2;
  double[distance((dmat3x2(-0.36lf, -0.53lf, -1.08lf, 0.88lf, -0.6lf, -1.79lf) * dvec3(1.67lf, 0.66lf, 1.87lf)), dvec2(-2.436lf, -3.6516lf)) <= 4.389564734686117e-05lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
