/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << u64vec3(46ul, 50ul, 0ul)) => u64vec3(6143683947919310848ul, 95701492081623040ul, 94ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << u64vec3(52ul, 23ul, 5ul)) => u64vec3(5814147118935310336ul, 713031680ul, 3008ul)
 * (u64vec3(167ul, 66ul, 187ul) << u64vec3(46ul, 50ul, 0ul)) => u64vec3(11751580277669888ul, 74309393851613184ul, 187ul)
 * (u64vec3(167ul, 66ul, 187ul) << u64vec3(52ul, 23ul, 5ul)) => u64vec3(752101137770872832ul, 553648128ul, 5984ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << u64vec3(46ul, 50ul, 0ul)), u64vec3(6143683947919310848ul, 95701492081623040ul, 94ul))) ? 1 : -1] array0;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << u64vec3(52ul, 23ul, 5ul)), u64vec3(5814147118935310336ul, 713031680ul, 3008ul))) ? 1 : -1] array1;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << u64vec3(46ul, 50ul, 0ul)), u64vec3(11751580277669888ul, 74309393851613184ul, 187ul))) ? 1 : -1] array2;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << u64vec3(52ul, 23ul, 5ul)), u64vec3(752101137770872832ul, 553648128ul, 5984ul))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
