/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.unchecked;

import java.util.Objects;
import java.util.function.Consumer;

@FunctionalInterface
public interface UncheckedConsumer<T> {
    public static <T> UncheckedConsumer<T> from(Consumer<T> consumer) {
        return consumer::accept;
    }

    public void accept(T var1) throws Exception;

    default public UncheckedConsumer<T> andThen(UncheckedConsumer<? super T> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    default public Consumer<T> toConsumer() {
        return x -> {
            try {
                this.accept(x);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}

