/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.marshal;

import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceId;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class MarshalerContext {
    private final boolean marshalStringNoAllocation;
    private final boolean marshalStringUnsafe;
    private int[] sizes = new int[16];
    private int sizeReadIndex;
    private int sizeWriteIndex;
    private Object[] data = new Object[16];
    private int dataReadIndex;
    private int dataWriteIndex;
    private final IdPool traceIdPool = new IdPool(TraceId.getLength() / 2);
    private final IdPool spanIdPool = new IdPool(SpanId.getLength() / 2);
    private final Pool<Map<?, ?>> mapPool = new Pool<Map>(IdentityHashMap::new, Map::clear);
    private final Pool<List<?>> listPool = new Pool<List>(ArrayList::new, List::clear);
    private static final AtomicInteger KEY_INDEX = new AtomicInteger();
    private Object[] instances = new Object[16];

    public MarshalerContext() {
        this(true, true);
    }

    public MarshalerContext(boolean marshalStringNoAllocation, boolean marshalStringUnsafe) {
        this.marshalStringNoAllocation = marshalStringNoAllocation;
        this.marshalStringUnsafe = marshalStringUnsafe;
    }

    public boolean marshalStringNoAllocation() {
        return this.marshalStringNoAllocation;
    }

    public boolean marshalStringUnsafe() {
        return this.marshalStringUnsafe;
    }

    public void addSize(int size) {
        this.growSizeIfNeeded();
        this.sizes[this.sizeWriteIndex++] = size;
    }

    public int addSize() {
        this.growSizeIfNeeded();
        return this.sizeWriteIndex++;
    }

    private void growSizeIfNeeded() {
        if (this.sizeWriteIndex == this.sizes.length) {
            int[] newSizes = new int[this.sizes.length * 2];
            System.arraycopy(this.sizes, 0, newSizes, 0, this.sizes.length);
            this.sizes = newSizes;
        }
    }

    public void setSize(int index, int size) {
        this.sizes[index] = size;
    }

    public int getSize() {
        return this.sizes[this.sizeReadIndex++];
    }

    public void addData(@Nullable Object o) {
        this.growDataIfNeeded();
        this.data[this.dataWriteIndex++] = o;
    }

    private void growDataIfNeeded() {
        if (this.dataWriteIndex == this.data.length) {
            Object[] newData = new Object[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
    }

    public <T> T getData(Class<T> type) {
        return type.cast(this.data[this.dataReadIndex++]);
    }

    public byte[] getTraceIdBuffer() {
        return this.traceIdPool.get();
    }

    public byte[] getSpanIdBuffer() {
        return this.spanIdPool.get();
    }

    public <K, V> Map<K, V> getIdentityMap() {
        return this.mapPool.get();
    }

    public <T> List<T> getList() {
        return this.listPool.get();
    }

    public void resetReadIndex() {
        this.sizeReadIndex = 0;
        this.dataReadIndex = 0;
    }

    public void reset() {
        this.sizeReadIndex = 0;
        this.sizeWriteIndex = 0;
        for (int i = 0; i < this.dataWriteIndex; ++i) {
            this.data[i] = null;
        }
        this.dataReadIndex = 0;
        this.dataWriteIndex = 0;
        this.traceIdPool.reset();
        this.spanIdPool.reset();
        this.mapPool.reset();
        this.listPool.reset();
    }

    public static Key key() {
        return new Key();
    }

    public <T> T getInstance(Key key, Supplier<T> supplier) {
        Object result;
        if (key.index >= this.instances.length) {
            Object[] newData = new Object[this.instances.length * 2];
            System.arraycopy(this.instances, 0, newData, 0, this.instances.length);
            this.instances = newData;
        }
        if ((result = this.instances[key.index]) == null) {
            this.instances[key.index] = result = supplier.get();
        }
        return (T)result;
    }

    static /* synthetic */ AtomicInteger access$000() {
        return KEY_INDEX;
    }

    private static class IdPool {
        private final List<byte[]> pool = new ArrayList<byte[]>();
        int index;
        final int idSize;

        IdPool(int idSize) {
            this.idSize = idSize;
        }

        byte[] get() {
            if (this.index < this.pool.size()) {
                return this.pool.get(this.index++);
            }
            byte[] result = new byte[this.idSize];
            this.pool.add(result);
            ++this.index;
            return result;
        }

        void reset() {
            this.index = 0;
        }
    }

    private static class Pool<T> {
        private final List<T> pool = new ArrayList<T>();
        private int index;
        private final Supplier<T> factory;
        private final Consumer<T> clean;

        Pool(Supplier<T> factory, Consumer<T> clean) {
            this.factory = factory;
            this.clean = clean;
        }

        T get() {
            if (this.index < this.pool.size()) {
                return this.pool.get(this.index++);
            }
            T result = this.factory.get();
            this.pool.add(result);
            ++this.index;
            return result;
        }

        void reset() {
            for (int i = 0; i < this.index; ++i) {
                this.clean.accept(this.pool.get(i));
            }
            this.index = 0;
        }
    }

    public static class Key {
        final int index = MarshalerContext.access$000().getAndIncrement();
    }
}

