/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devui;

import io.quarkus.arc.deployment.CompletedApplicationClassPredicateBuildItem;
import io.quarkus.arc.deployment.devui.Name;
import io.quarkus.arc.processor.DecoratorInfo;
import java.util.HashSet;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;

public class DevDecoratorInfo
implements Comparable<DevDecoratorInfo> {
    private final String id;
    private final Name decoratorClass;
    private final Name delegateType;
    private final Set<Name> delegateQualifiers;
    private final int priority;
    private final boolean isApplicationBean;

    public static DevDecoratorInfo from(DecoratorInfo decorator, CompletedApplicationClassPredicateBuildItem predicate) {
        boolean isApplicationBean = predicate.test(decorator.getBeanClass());
        HashSet<Name> delegateQualifiers = new HashSet<Name>();
        for (AnnotationInstance binding : decorator.getDelegateQualifiers()) {
            delegateQualifiers.add(Name.from(binding));
        }
        return new DevDecoratorInfo(decorator.getIdentifier(), Name.from(decorator.getBeanClass()), Name.from(decorator.getDelegateType()), delegateQualifiers, decorator.getPriority(), isApplicationBean);
    }

    private DevDecoratorInfo(String id, Name decoratorClass, Name delegateType, Set<Name> delegateQualifiers, int priority, boolean isApplicationBean) {
        this.id = id;
        this.decoratorClass = decoratorClass;
        this.delegateType = delegateType;
        this.delegateQualifiers = delegateQualifiers;
        this.priority = priority;
        this.isApplicationBean = isApplicationBean;
    }

    public String getId() {
        return this.id;
    }

    public Name getDecoratorClass() {
        return this.decoratorClass;
    }

    public Name getDelegateType() {
        return this.delegateType;
    }

    public Set<Name> getDelegateQualifiers() {
        return this.delegateQualifiers;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isApplicationBean() {
        return this.isApplicationBean;
    }

    @Override
    public int compareTo(DevDecoratorInfo o) {
        if (this.isApplicationBean == o.isApplicationBean) {
            return this.decoratorClass.compareTo(o.decoratorClass);
        }
        return this.isApplicationBean ? -1 : 1;
    }
}

