/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.regex.charclass.CharacterClass;
import net.sf.saxon.regex.charclass.EmptyCharacterClass;
import net.sf.saxon.z.IntIterator;

public abstract class Operation {
    protected static final int MATCHES_ZLS_AT_START = 1;
    protected static final int MATCHES_ZLS_AT_END = 2;
    protected static final int MATCHES_ZLS_ANYWHERE = 7;
    protected static final int MATCHES_ZLS_NEVER = 1024;

    public abstract IntIterator iterateMatches(REMatcher var1, int var2);

    public int getMatchLength() {
        return -1;
    }

    public int getMinimumMatchLength() {
        int fixed = this.getMatchLength();
        return Math.max(fixed, 0);
    }

    public abstract int matchesEmptyString();

    public boolean containsCapturingExpressions() {
        return false;
    }

    public CharacterClass getInitialCharacterClass(boolean caseBlind) {
        return EmptyCharacterClass.getComplement();
    }

    public Operation optimize(REProgram program, REFlags flags) {
        return this;
    }

    public abstract String display();

    protected static class ForceProgressIterator
    implements IntIterator {
        private final IntIterator base;
        int countZeroLength = 0;
        int currentPos = -1;

        ForceProgressIterator(IntIterator base) {
            this.base = base;
        }

        @Override
        public boolean hasNext() {
            return this.countZeroLength <= 3 && this.base.hasNext();
        }

        @Override
        public int next() {
            int p = this.base.next();
            if (p == this.currentPos) {
                ++this.countZeroLength;
            } else {
                this.countZeroLength = 0;
                this.currentPos = p;
            }
            return p;
        }
    }
}

