# This file is part of Autoconf.                       -*- Autoconf -*-
# Interface with Autotest.
# Copyright (C) 1992, 1993, 1994, 1995, 1996, 1998, 1999, 2000, 2001, 2002,
# 2003, 2004, 2005 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.

# As a special exception, the Free Software Foundation gives unlimited
# permission to copy, distribute and modify the configure scripts that
# are the output of Autoconf.  You need not follow the terms of the GNU
# General Public License when using or distributing such scripts, even
# though portions of the text of Autoconf appear in them.  The GNU
# General Public License (GPL) does govern all other use of the material
# that constitutes the Autoconf program.
#
# Certain portions of the Autoconf source text are designed to be copied
# (in certain cases, depending on the input) into the output of
# Autoconf.  We call these the "data" portions.  The rest of the Autoconf
# source text consists of comments plus executable code that decides which
# of the data portions to output in any given case.  We call these
# comments and executable code the "non-data" portions.  Autoconf never
# copies any of the non-data portions into its output.
#
# This special exception to the GPL applies to versions of Autoconf
# released by the Free Software Foundation.  When you make and
# distribute a modified version of Autoconf, you may extend this special
# exception to the GPL to apply to your modified version as well, *unless*
# your modified version has the potential to copy into its output some
# of the text that was the non-data portion of the version that you started
# with.  (In other words, unless your change moves or copies text from
# the non-data portions to the data portions.)  If your modification has
# such potential, you must delete any notice of this special exception
# to the GPL from your modified version.
#
# Written by David MacKenzie, with help from
# Franc,ois Pinard, Karl Berry, Richard Pixley, Ian Lance Taylor,
# Roland McGrath, Noah Friedman, david d zuhn, and many others.


# AC_CONFIG_TESTDIR(TEST-DIRECTORY, [AUTOTEST-PATH = TEST-DIRECTORY])
# -------------------------------------------------------------------
# Configure an Autotest test suite directory.  Invoke it once per dir,
# even if there are several test suites in there.
#
# AUTOTEST-PATH must help the test suite to find the executables.
# It is relative to the top level of the package, and is expanded
# into all the build dirs of AUTOTEST-PATH, then all the src dirs.
#
# Do not use _ACEOF as we are being dumped into config.status via
# an _ACEOF-heredoc.
AC_DEFUN([AC_CONFIG_TESTDIR],
[AC_CONFIG_COMMANDS([$1/atconfig],
[cat >$1/atconfig <<ATEOF
@%:@ Configurable variable values for building test suites.
@%:@ Generated by $[0].
@%:@ Copyright (C) 2000, 2001, 2003, 2004 Free Software Foundation, Inc.

# The test suite will define top_srcdir=$at_top_srcdir/../.. etc.
at_testdir='$1'
abs_builddir='$ac_abs_builddir'
at_srcdir='$ac_srcdir'
abs_srcdir='$ac_abs_srcdir'
at_top_srcdir='$ac_top_srcdir'
abs_top_srcdir='$ac_abs_top_srcdir'
at_top_build_prefix='$ac_top_build_prefix'
abs_top_builddir='$ac_abs_top_builddir'

# Backward compatibility with Autotest <= 2.59b:
at_top_builddir=\$at_top_build_prefix

AUTOTEST_PATH='m4_default([$2], [$1])'

SHELL=\${CONFIG_SHELL-'$SHELL'}
ATEOF
])
])# AC_CONFIG_TESTDIR
