untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3jWEj6xt6N0rXrk6fcnTPklYoeIqmzXvDEi0PE5Wcs3+H3YYuaLEzcUSMP5kloC144ba4028dkRlpK/VAJHI6As=

OpenBSD 6.7 errata 011, July 9, 2020:

shmget IPC_STAT leaked some kernel data.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 011_shmget.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/sysv_sem.c
===================================================================
RCS file: /cvs/src/sys/kern/sysv_sem.c,v
diff -u -p -u -r1.57 sysv_sem.c
--- sys/kern/sysv_sem.c	8 Jan 2020 15:03:10 -0000	1.57
+++ sys/kern/sysv_sem.c	8 Jul 2020 21:07:01 -0000
@@ -299,7 +299,9 @@ semctl1(struct proc *p, int semid, int s
 	case IPC_STAT:
 		if ((error = ipcperm(cred, &semaptr->sem_perm, IPC_R)))
 			return (error);
-		error = ds_copyout(semaptr, arg->buf, sizeof(struct semid_ds));
+		memcpy(&sbuf, semaptr, sizeof sbuf);
+		sbuf.sem_base = NULL;
+		error = ds_copyout(&sbuf, arg->buf, sizeof(struct semid_ds));
 		break;
 
 	case GETNCNT:
@@ -423,7 +425,7 @@ sys_semget(struct proc *p, void *v, regi
 			    nsems, seminfo.semmns - semtot));
 			return (ENOSPC);
 		}
-		semaptr_new = pool_get(&sema_pool, PR_WAITOK);
+		semaptr_new = pool_get(&sema_pool, PR_WAITOK | PR_ZERO);
 		semaptr_new->sem_base = mallocarray(nsems, sizeof(struct sem),
 		    M_SEM, M_WAITOK|M_ZERO);
 	}
