untrusted comment: signature from openbsd 6.2 base secret key
RWRVWzAMgtyg7qBkeX3d6A+XJH6rwnI9tc6Y6bo6lY/SLk3f5Lhl6lwqyaqOn1FcWrBJnTTdI2eRHt58RjrpjYPrhnbfP2zjOQA=

OpenBSD 6.2 errata 001, October 13th, 2017:

A local user could trigger a kernel panic by using an invalid TCB value.

Apply by doing:
    signify -Vep /etc/signify/openbsd-62-base.pub -x 001_tcb_invalid.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/amd64/include/tcb.h
===================================================================
RCS file: /data/mirror/openbsd/cvs/src/sys/arch/amd64/include/tcb.h,v
retrieving revision 1.5
diff -u -p -r1.5 tcb.h
--- sys/arch/amd64/include/tcb.h	27 Sep 2017 05:43:55 -0000	1.5
+++ sys/arch/amd64/include/tcb.h	10 Oct 2017 18:09:12 -0000
@@ -28,7 +28,7 @@ void	tcb_set(struct proc *_p, void *_new
 #define TCB_SET(p, addr)	tcb_set(p, addr)
 
 /* address must be in canonical form; requiring lower-half is okay */
-#define TCB_INVALID(addr)	((u_long)(addr) > 0x0000ffffffffffff)
+#define TCB_INVALID(addr)	((u_long)(addr) > 0x00007fffffffffff)
 
 #else /* _KERNEL */
 
