untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ0Y5LwhaZH3c8OR9Xuv0EA/fqm0Oq+DX/EqooxCbX6MKedhyLERxSoN25oRiSTN2g/UXlcpZxjfYYkHvSlWxOAQ=

OpenBSD 6.0 errata 029, August 3, 2017:

Use-after-free can occur related to SIGIO in two drivers.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 029_sigio.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/dev/midi.c
===================================================================
RCS file: /cvs/src/sys/dev/midi.c,v
--- sys/dev/midi.c	22 May 2015 12:52:00 -0000	1.40
+++ sys/dev/midi.c	2 Aug 2017 16:24:57 -0000
@@ -98,8 +98,6 @@ midi_iintr(void *addr, int data)
 			wakeup(&sc->rchan);
 		}
 		selwakeup(&sc->rsel);
-		if (sc->async)
-			psignal(sc->async, SIGIO);
 	}
 }
 
@@ -208,8 +206,6 @@ midi_out_stop(struct midi_softc *sc)
 		wakeup(&sc->wchan);
 	}
 	selwakeup(&sc->wsel);
-	if (sc->async)
-		psignal(sc->async, SIGIO);
 }
 
 void
@@ -431,20 +427,9 @@ midiioctl(dev_t dev, u_long cmd, caddr_t
 	case FIONBIO:
 		/* All handled in the upper FS layer */
 		break;
-	case FIOASYNC:
-		if (*(int *)addr) {
-			if (sc->async) {
-				error = EBUSY;
-				goto done;
-			}
-			sc->async = p;
-		} else
-			sc->async = 0;
-		break;
 	default:
 		error = ENOTTY;
 	}
-done:
 	device_unref(&sc->dev);
 	return error;
 }
@@ -467,7 +452,6 @@ midiopen(dev_t dev, int flags, int mode,
 	MIDIBUF_INIT(&sc->outbuf);
 	sc->isbusy = 0;
 	sc->rchan = sc->wchan = 0;
-	sc->async = 0;
 	sc->flags = flags;
 	error = sc->hw_if->open(sc->hw_hdl, flags, midi_iintr, midi_ointr, sc);
 	if (error)
Index: sys/dev/usb/uhid.c
===================================================================
RCS file: /cvs/src/sys/dev/usb/uhid.c,v
--- sys/dev/usb/uhid.c	24 May 2016 05:35:01 -0000	1.66
+++ sys/dev/usb/uhid.c	1 Aug 2017 21:55:02 -0000	1.66.6.1
@@ -75,7 +75,6 @@ struct uhid_softc {
 
 	struct clist sc_q;
 	struct selinfo sc_rsel;
-	struct process *sc_async;	/* process that wants SIGIO */
 	u_char sc_state;		/* driver state */
 #define	UHID_ASLP	0x01		/* waiting for device data */
 
@@ -198,10 +197,6 @@ uhid_intr(struct uhidev *addr, void *dat
 		wakeup(&sc->sc_q);
 	}
 	selwakeup(&sc->sc_rsel);
-	if (sc->sc_async != NULL) {
-		DPRINTFN(3, ("uhid_intr: sending SIGIO %p\n", sc->sc_async));
-		prsignal(sc->sc_async, SIGIO);
-	}
 }
 
 int
@@ -228,7 +223,6 @@ uhidopen(dev_t dev, int flag, int mode, 
 	clalloc(&sc->sc_q, UHID_BSIZE, 0);
 
 	sc->sc_obuf = malloc(sc->sc_hdev.sc_osize, M_USBDEV, M_WAITOK);
-	sc->sc_async = NULL;
 
 	return (0);
 }
@@ -244,7 +238,6 @@ uhidclose(dev_t dev, int flag, int mode,
 
 	clfree(&sc->sc_q);
 	free(sc->sc_obuf, M_USBDEV, 0);
-	sc->sc_async = NULL;
 	uhidev_close(&sc->sc_hdev);
 
 	return (0);
@@ -367,24 +360,6 @@ uhid_do_ioctl(struct uhid_softc *sc, u_l
 	switch (cmd) {
 	case FIONBIO:
 		/* All handled in the upper FS layer. */
-		break;
-
-	case FIOASYNC:
-		if (*(int *)addr) {
-			if (sc->sc_async != NULL)
-				return (EBUSY);
-			sc->sc_async = p->p_p;
-			DPRINTF(("uhid_do_ioctl: FIOASYNC %p\n", p));
-		} else
-			sc->sc_async = NULL;
-		break;
-
-	/* XXX this is not the most general solution. */
-	case TIOCSPGRP:
-		if (sc->sc_async == NULL)
-			return (EINVAL);
-		if (*(int *)addr != sc->sc_async->ps_pgid)
-			return (EPERM);
 		break;
 
 	case USB_GET_DEVICEINFO:
