untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwfw2QuJp+VtPewSuzUgTGNV428b4nTJ1Nx0LjNsEfGjBhH3U5sEBcOFsuuVRJsEwkupLzBKw910Cvdbszlu24wk=

OpenBSD 5.9 errata 9, May 29, 2016:

Fix a bug introduced in 005_crypto.patch.sig that prevents loading ASN.1
elements greater than 16k.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 009_crypto.patch.sig \
            -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto:
	cd /usr/src/lib/libcrypto
	make obj
	make depend
	make
	make install

Index: lib/libssl/src/crypto/asn1/a_d2i_fp.c
===================================================================
RCS file: /cvs/src/lib/libssl/src/crypto/asn1/a_d2i_fp.c,v
retrieving revision 1.11.2.1
diff -u -p -u -p -r1.11.2.1 a_d2i_fp.c
--- lib/libssl/src/crypto/asn1/a_d2i_fp.c	3 May 2016 12:39:48 -0000	1.11.2.1
+++ lib/libssl/src/crypto/asn1/a_d2i_fp.c	28 May 2016 23:38:18 -0000
@@ -236,36 +236,38 @@ asn1_d2i_read_bio(BIO *in, BUF_MEM **pb)
 					    ASN1_R_TOO_LONG);
 					goto err;
 				}
-				/*
-				 * Read content in chunks of increasing size
-				 * so we can return an error for EOF without
-				 * having to allocate the entire content length
-				 * in one go.
-				 */
-				size_t chunk = want > chunk_max ? chunk_max : want;
+				while (want > 0) {
+					/*
+					 * Read content in chunks of increasing size
+					 * so we can return an error for EOF without
+					 * having to allocate the entire content length
+					 * in one go.
+					 */
+					size_t chunk = want > chunk_max ? chunk_max : want;

-				if (!BUF_MEM_grow_clean(b, len + chunk)) {
-					ASN1err(ASN1_F_ASN1_D2I_READ_BIO,
-					    ERR_R_MALLOC_FAILURE);
-					goto err;
-				}
-				want -= chunk;
-				while (chunk > 0) {
-					i = BIO_read(in, &(b->data[len]), chunk);
-					if (i <= 0) {
+					if (!BUF_MEM_grow_clean(b, len + chunk)) {
 						ASN1err(ASN1_F_ASN1_D2I_READ_BIO,
-						    ASN1_R_NOT_ENOUGH_DATA);
+						    ERR_R_MALLOC_FAILURE);
 						goto err;
 					}
-					/*
-					 * This can't overflow because |len+want|
-					 * didn't overflow.
-					 */
-					len += i;
-					chunk -= i;
+					want -= chunk;
+					while (chunk > 0) {
+						i = BIO_read(in, &(b->data[len]), chunk);
+						if (i <= 0) {
+							ASN1err(ASN1_F_ASN1_D2I_READ_BIO,
+							    ASN1_R_NOT_ENOUGH_DATA);
+							goto err;
+						}
+						/*
+						 * This can't overflow because |len+want|
+						 * didn't overflow.
+						 */
+						len += i;
+						chunk -= i;
+					}
+					if (chunk_max < INT_MAX/2)
+						chunk_max *= 2;
 				}
-				if (chunk_max < INT_MAX/2)
-					chunk_max *= 2;
 			}
 			if (off + c.slen < off) {
 				ASN1err(ASN1_F_ASN1_D2I_READ_BIO, ASN1_R_TOO_LONG);
