'\" t
.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetControls __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetControls \- Finds the current state of Xkb server controls
.SH SYNOPSIS
.HP
.B Status XkbGetControls
.BI "(\^Display *" "display" "\^,"
.BI "unsigned long " "which" "\^,"
.BI "XkbDescPtr " "xkb" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
connection to X server
.TP
.I which
mask of controls requested
.TP
.I xkb
keyboard description for controls information
.SH DESCRIPTION
.LP
.I XkbGetControls 
queries the server for the requested control information, waits for a reply, and 
then copies the server's values for the requested information into the 
.I ctrls 
structure of the 
.I xkb 
argument. Only those components specified by the 
.I which 
parameter are copied. Valid values for 
.I which 
are any combination of the masks listed in Table 1 that have "ok" in the
.I which 
column.

Table 1 shows the actual values for the individual mask bits used to select 
controls for 
modification and to enable and disable the control. Note that the same mask bit 
is used to 
specify general modifications to the parameters used to configure the control 
(which), and to 
enable and disable the control (enabled_ctrls). The anomalies in Table 1 (no 
"ok" in column) 
are for controls that have no configurable attributes; and for controls that are 
not boolean 
controls and therefore cannot be enabled or disabled.

.TS
c s s s
l l l l
l l l l
l l l l. 
Table 1 Controls Mask Bits
_
Mask Bit	which or	enabled	Value
	changed_ctrls	_ctrls
_
XkbRepeatKeysMask	ok	ok	(1L<<0)
XkbSlowKeysMask	ok	ok	(1L<<1)
XkbBounceKeysMask	ok	ok	(1L<<2)
XkbStickyKeysMask	ok	ok	(1L<<3)
XkbMouseKeysMask	ok	ok	(1L<<4)
XkbMouseKeysAccelMask	ok	ok	(1L<<5)
XkbAccessXKeysMask	ok	ok	(1L<<6)
XkbAccessXTimeoutMask	ok	ok	(1L<<7)
XkbAccessXFeedbackMask	ok	ok	(1L<<8)
XkbAudibleBellMask		ok	(1L<<9)
XkbOverlay1Mask		ok	(1L<<10)
XkbOverlay2Mask		ok	(1L<<11)
XkbIgnoreGroupLockMask		ok	(1L<<12)
XkbGroupsWrapMask	ok		(1L<<27)
XkbInternalModsMask	ok		(1L<<28)
XkbIgnoreLockModsMask	ok		(1L<<29)
XkbPerKeyRepeatMask	ok		(1L<<30)
XkbControlsEnabledMask	ok		(1L<<31)
XkbAccessXOptionsMask	ok	ok	(XkbStickyKeysMask | 
			XkbAccessXFeedbackMask)
XkbAllBooleanCtrlsMask		ok	(0x00001FFF) 
XkbAllControlsMask	ok		(0xF8001FFF)
.TE


If 
.I xkb->ctrls 
is NULL, 
.I XkbGetControls 
allocates and initializes it before obtaining the values specified by 
.I which. 
If 
.I xkb->ctrls 
is not NULL, 
.I XkbGetControls 
modifies only those portions of 
.I xkb->ctrls 
corresponding to the values specified by 
.I which.

.I XkbGetControls 
returns Success if successful; otherwise, it returns BadAlloc if it cannot 
obtain sufficient storage, BadMatch if 
.I xkb 
is NULL or 
.I which 
is empty, or BadImplementation.

To free the 
.I ctrls 
member of a keyboard description, use 
.I XkbFreeControls.

The 
.I num_groups 
field in the 
.I ctrls 
structure is always filled in by 
.I XkbGetControls, 
regardless of which bits are selected by 
.I which.
.SH "RETURN VALUES"
.TP 15
Success
The 
.I XkbGetControls 
function returns Success if successful.
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadImplementation
Invalid reply from server
.TP 15
.B BadMatch
A compatible version of Xkb was not available in the server or an argument has 
correct type and range, but is otherwise invalid

.SH "SEE ALSO"
.BR XkbFreeControls (__libmansuffix__)
