/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp9;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.codec.vpx.VpxUtils;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Packet;
import org.jitsi.nlj.util.UtilKt;
import org.jitsi.videobridge.cc.vp9.PacketInsertionResult;
import org.jitsi.videobridge.cc.vp9.Vp9Frame;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u0003J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\b\u0010\u0011\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\nH\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u000e\u0010+\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003J\u000e\u0010,\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0003J\u000e\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\u0000R\u0019\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010 \u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001bR\u0011\u0010#\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001b\u00a8\u0006/"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9Picture;", "", "packet", "Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;", "index", "", "<init>", "(Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;I)V", "frames", "Ljava/util/ArrayList;", "Lorg/jitsi/videobridge/cc/vp9/Vp9Frame;", "getFrames", "()Ljava/util/ArrayList;", "frame", "sid", "setFrameAtSid", "", "firstFrame", "lastFrame", "ssrc", "", "getSsrc", "()J", "timestamp", "getTimestamp", "temporalLayer", "getTemporalLayer", "()I", "earliestKnownSequenceNumber", "getEarliestKnownSequenceNumber", "latestKnownSequenceNumber", "getLatestKnownSequenceNumber", "pictureId", "getPictureId", "getIndex", "tl0PICIDX", "getTl0PICIDX", "addPacket", "Lorg/jitsi/videobridge/cc/vp9/PacketInsertionResult;", "matchesSSRC", "", "pkt", "Lorg/jitsi/nlj/rtp/VideoRtpPacket;", "matchesPicture", "validateConsistency", "isImmediatelyAfter", "otherPicture", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nVp9Picture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vp9Picture.kt\norg/jitsi/videobridge/cc/vp9/Vp9Picture\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1#2:220\n*E\n"})
public final class Vp9Picture {
    @NotNull
    private final ArrayList<Vp9Frame> frames;

    public Vp9Picture(@NotNull Vp9Packet packet, int index) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this.frames = new ArrayList();
        int sid = packet.getEffectiveSpatialLayerIndex();
        this.setFrameAtSid(new Vp9Frame(packet, index), sid);
    }

    @NotNull
    public final ArrayList<Vp9Frame> getFrames() {
        return this.frames;
    }

    @Nullable
    public final Vp9Frame frame(int sid) {
        return (Vp9Frame)CollectionsKt.getOrNull((List)this.frames, sid);
    }

    @Nullable
    public final Vp9Frame frame(@NotNull Vp9Packet packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        return this.frame(packet.getEffectiveSpatialLayerIndex());
    }

    private final void setFrameAtSid(Vp9Frame frame, int sid) {
        UtilKt.setAndExtend((List)this.frames, sid, frame, null);
    }

    private final Vp9Frame firstFrame() {
        Object v0;
        block2: {
            Iterable iterable = this.frames;
            for (Object t2 : iterable) {
                Vp9Frame f = (Vp9Frame)t2;
                boolean bl = false;
                if (!(f != null)) continue;
                v0 = t2;
                break block2;
            }
            v0 = null;
        }
        Vp9Frame f = v0;
        if (!(f != null)) {
            boolean bl = false;
            String string = "Picture must have at least one frame";
            throw new IllegalStateException(string.toString());
        }
        return f;
    }

    private final Vp9Frame lastFrame() {
        Object v0;
        block2: {
            List list = this.frames;
            ListIterator listIterator2 = list.listIterator(list.size());
            while (listIterator2.hasPrevious()) {
                Object e = listIterator2.previous();
                Vp9Frame f = (Vp9Frame)e;
                boolean bl = false;
                if (!(f != null)) continue;
                v0 = e;
                break block2;
            }
            v0 = null;
        }
        Vp9Frame f = v0;
        if (!(f != null)) {
            boolean bl = false;
            String string = "Picture must have at least one frame";
            throw new IllegalStateException(string.toString());
        }
        return f;
    }

    public final long getSsrc() {
        return this.firstFrame().getSsrc();
    }

    public final long getTimestamp() {
        return this.firstFrame().getTimestamp();
    }

    public final int getTemporalLayer() {
        return this.firstFrame().getTemporalLayer();
    }

    public final int getEarliestKnownSequenceNumber() {
        return this.firstFrame().getEarliestKnownSequenceNumber();
    }

    public final int getLatestKnownSequenceNumber() {
        return this.lastFrame().getLatestKnownSequenceNumber();
    }

    public final int getPictureId() {
        return this.firstFrame().getPictureId();
    }

    public final int getIndex() {
        return this.firstFrame().getIndex();
    }

    public final int getTl0PICIDX() {
        return this.firstFrame().getTl0PICIDX();
    }

    @NotNull
    public final PacketInsertionResult addPacket(@NotNull Vp9Packet packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        if (!this.matchesPicture(packet)) {
            boolean $i$a$-require-Vp9Picture$addPacket$22 = false;
            String $i$a$-require-Vp9Picture$addPacket$22 = "Non-matching packet added to picture";
            throw new IllegalArgumentException($i$a$-require-Vp9Picture$addPacket$22.toString());
        }
        int sid = packet.getEffectiveSpatialLayerIndex();
        Vp9Frame f = this.frame(packet);
        if (f != null) {
            f.addPacket(packet);
            return new PacketInsertionResult(f, this, false, false, 8, null);
        }
        Vp9Frame newF = new Vp9Frame(packet, this.getIndex());
        this.setFrameAtSid(newF, sid);
        return new PacketInsertionResult(newF, this, true, false, 8, null);
    }

    private final boolean matchesSSRC(VideoRtpPacket pkt) {
        return this.getSsrc() == pkt.getSsrc();
    }

    public final boolean matchesPicture(@NotNull Vp9Packet pkt) {
        Intrinsics.checkNotNullParameter(pkt, "pkt");
        return this.matchesSSRC(pkt) && this.getTimestamp() == pkt.getTimestamp();
    }

    public final void validateConsistency(@NotNull Vp9Packet pkt) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(pkt, "pkt");
        Vp9Frame f = this.frame(pkt);
        if (f != null) {
            f.validateConsistency(pkt);
            return;
        }
        if (this.getTemporalLayer() == pkt.getTemporalLayerIndex() && this.getTl0PICIDX() == pkt.getTL0PICIDX() && this.getPictureId() == pkt.getPictureId()) {
            return;
        }
        StringBuilder $this$validateConsistency_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Vp9Packet $this$validateConsistency_u24lambda_u246_u24lambda_u245 = pkt;
        boolean bl2 = false;
        $this$validateConsistency_u24lambda_u246.append("Packet ssrc " + $this$validateConsistency_u24lambda_u246_u24lambda_u245.getSsrc() + ", seq " + $this$validateConsistency_u24lambda_u246_u24lambda_u245.getSequenceNumber() + ", picture id " + $this$validateConsistency_u24lambda_u246_u24lambda_u245.getPictureId() + ", timestamp " + $this$validateConsistency_u24lambda_u246_u24lambda_u245.getTimestamp() + " ");
        $this$validateConsistency_u24lambda_u246.append("is not consistent with picture " + this.getSsrc() + ", ");
        $this$validateConsistency_u24lambda_u246.append("seq " + this.getEarliestKnownSequenceNumber() + "-" + this.getLatestKnownSequenceNumber() + " ");
        $this$validateConsistency_u24lambda_u246.append("picture id " + this.getPictureId() + ", timestamp " + this.getTimestamp() + ": ");
        boolean complained = false;
        if (this.getTemporalLayer() != pkt.getTemporalLayerIndex()) {
            $this$validateConsistency_u24lambda_u246.append("packet temporal layer " + pkt.getTemporalLayerIndex() + " != frame temporal layer " + this.getTemporalLayer());
            complained = true;
        }
        if (this.getTl0PICIDX() != pkt.getTL0PICIDX()) {
            if (complained) {
                $this$validateConsistency_u24lambda_u246.append("; ");
            }
            $this$validateConsistency_u24lambda_u246.append("packet TL0PICIDX " + pkt.getTL0PICIDX() + " != frame TL0PICIDX " + this.getTl0PICIDX());
            complained = true;
        }
        if (this.getPictureId() != pkt.getPictureId()) {
            if (complained) {
                $this$validateConsistency_u24lambda_u246.append("; ");
            }
            $this$validateConsistency_u24lambda_u246.append("packet PictureID " + pkt.getPictureId() + " != frame PictureID " + this.getPictureId());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        String string2 = string;
        throw new RuntimeException(string2);
    }

    public final boolean isImmediatelyAfter(@NotNull Vp9Picture otherPicture) {
        Intrinsics.checkNotNullParameter(otherPicture, "otherPicture");
        return this.getPictureId() == VpxUtils.Companion.applyExtendedPictureIdDelta(otherPicture.getPictureId(), 1);
    }
}

