/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg;

import java.util.HashSet;
import org.jd.core.v1.model.classfile.Method;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;
import org.jd.core.v1.util.DefaultList;

public class ControlFlowGraph {
    protected Method method;
    protected DefaultList<BasicBlock> list = new DefaultList<BasicBlock>(){

        @Override
        public BasicBlock remove(int index) {
            throw new RuntimeException("Unexpected call");
        }
    };
    protected int[] offsetToLineNumbers = null;

    public ControlFlowGraph(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public DefaultList<BasicBlock> getBasicBlocks() {
        return this.list;
    }

    public BasicBlock getStart() {
        return (BasicBlock)this.list.get(0);
    }

    public BasicBlock newBasicBlock(BasicBlock original) {
        BasicBlock basicBlock = new BasicBlock(this, this.list.size(), original);
        this.list.add(basicBlock);
        return basicBlock;
    }

    public BasicBlock newBasicBlock(int fromOffset, int toOffset) {
        return this.newBasicBlock(0, fromOffset, toOffset);
    }

    public BasicBlock newBasicBlock(int type, int fromOffset, int toOffset) {
        BasicBlock basicBlock = new BasicBlock(this, this.list.size(), type, fromOffset, toOffset, true);
        this.list.add(basicBlock);
        return basicBlock;
    }

    public BasicBlock newBasicBlock(int type, int fromOffset, int toOffset, boolean inverseCondition) {
        BasicBlock basicBlock = new BasicBlock(this, this.list.size(), type, fromOffset, toOffset, inverseCondition);
        this.list.add(basicBlock);
        return basicBlock;
    }

    public BasicBlock newBasicBlock(int type, int fromOffset, int toOffset, HashSet<BasicBlock> predecessors) {
        BasicBlock basicBlock = new BasicBlock(this, this.list.size(), type, fromOffset, toOffset, true, predecessors);
        this.list.add(basicBlock);
        return basicBlock;
    }

    public void setOffsetToLineNumbers(int[] offsetToLineNumbers) {
        this.offsetToLineNumbers = offsetToLineNumbers;
    }

    public int getLineNumber(int offset) {
        return this.offsetToLineNumbers == null ? 0 : this.offsetToLineNumbers[offset];
    }
}

