/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.BeanELResolver;
import jakarta.el.BeanSupport;
import jakarta.el.ELException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

class BeanSupportStandalone
extends BeanSupport {
    private static final Comparator<Method> WRITE_METHOD_COMPARATOR = Comparator.comparing(m -> m.getParameterTypes()[0].getName());

    BeanSupportStandalone() {
    }

    @Override
    BeanELResolver.BeanProperties getBeanProperties(Class<?> type) {
        return new BeanPropertiesStandalone(type);
    }

    private static PropertyDescriptor[] getPropertyDescriptors(Class<?> type) {
        Method[] methods;
        HashMap<String, PropertyDescriptor> pds = new HashMap<String, PropertyDescriptor>();
        for (Method method : methods = type.getMethods()) {
            PropertyDescriptor pd;
            String propertyName;
            if (Modifier.isStatic(method.getModifiers())) continue;
            String methodName = method.getName();
            if (methodName.startsWith("is")) {
                if (method.getParameterCount() != 0 || method.getReturnType() != Boolean.TYPE) continue;
                propertyName = BeanSupportStandalone.getPropertyName(methodName.substring(2));
                pd = pds.computeIfAbsent(propertyName, k -> new PropertyDescriptor());
                pd.setName(propertyName);
                pd.setReadMethodIs(method);
                continue;
            }
            if (methodName.startsWith("get")) {
                if (method.getParameterCount() != 0) continue;
                propertyName = BeanSupportStandalone.getPropertyName(methodName.substring(3));
                pd = pds.computeIfAbsent(propertyName, k -> new PropertyDescriptor());
                pd.setName(propertyName);
                pd.setReadMethod(method);
                continue;
            }
            if (!methodName.startsWith("set") || method.getParameterCount() != 1 || method.getReturnType() != Void.TYPE) continue;
            propertyName = BeanSupportStandalone.getPropertyName(methodName.substring(3));
            pd = pds.computeIfAbsent(propertyName, k -> new PropertyDescriptor());
            pd.setName(propertyName);
            pd.addWriteMethod(method);
        }
        return pds.values().toArray(new PropertyDescriptor[0]);
    }

    private static String getPropertyName(String input) {
        if (input.length() == 0) {
            return null;
        }
        if (!Character.isUpperCase(input.charAt(0))) {
            return null;
        }
        if (input.length() > 1 && Character.isUpperCase(input.charAt(1))) {
            return input;
        }
        char[] chars = input.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static final class BeanPropertiesStandalone
    extends BeanELResolver.BeanProperties {
        BeanPropertiesStandalone(Class<?> type) throws ELException {
            super(type);
            PropertyDescriptor[] pds;
            for (PropertyDescriptor pd : pds = BeanSupportStandalone.getPropertyDescriptors(this.type)) {
                this.properties.put(pd.getName(), new BeanPropertyStandalone(type, pd));
            }
            this.populateFromInterfaces(type);
        }

        private void populateFromInterfaces(Class<?> aClass) {
            Class<?> superclass;
            Class<?>[] interfaces = aClass.getInterfaces();
            if (interfaces.length > 0) {
                for (Class<?> ifs : interfaces) {
                    PropertyDescriptor[] pds;
                    for (PropertyDescriptor pd : pds = BeanSupportStandalone.getPropertyDescriptors(this.type)) {
                        if (this.properties.containsKey(pd.getName())) continue;
                        this.properties.put(pd.getName(), new BeanPropertyStandalone(this.type, pd));
                    }
                    this.populateFromInterfaces(ifs);
                }
            }
            if ((superclass = aClass.getSuperclass()) != null) {
                this.populateFromInterfaces(superclass);
            }
        }
    }

    private static class PropertyDescriptor {
        private String name;
        private boolean usesIs;
        private Method readMethod;
        private Method writeMethod;
        private List<Method> writeMethods = new ArrayList<Method>();

        private PropertyDescriptor() {
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        Class<?> getType() {
            if (this.readMethod == null) {
                return this.getWriteMethod().getParameterTypes()[0];
            }
            return this.readMethod.getReturnType();
        }

        Method getReadMethod() {
            return this.readMethod;
        }

        void setReadMethod(Method readMethod) {
            if (this.usesIs) {
                return;
            }
            this.readMethod = readMethod;
        }

        void setReadMethodIs(Method readMethod) {
            this.readMethod = readMethod;
            this.usesIs = true;
        }

        Method getWriteMethod() {
            if (this.writeMethod == null) {
                Class<?> type;
                if (this.readMethod != null) {
                    type = this.readMethod.getReturnType();
                } else {
                    if (this.writeMethods.size() > 1) {
                        this.writeMethods.sort(WRITE_METHOD_COMPARATOR);
                    }
                    type = this.writeMethods.get(0).getParameterTypes()[0];
                }
                for (Method candidate : this.writeMethods) {
                    if (!type.isAssignableFrom(candidate.getParameterTypes()[0])) continue;
                    type = candidate.getParameterTypes()[0];
                    this.writeMethod = candidate;
                }
            }
            return this.writeMethod;
        }

        void addWriteMethod(Method writeMethod) {
            this.writeMethods.add(writeMethod);
        }
    }

    static final class WriteMethodComparator
    implements Comparator<Method> {
        WriteMethodComparator() {
        }

        @Override
        public int compare(Method m1, Method m2) {
            return 0;
        }
    }

    static final class BeanPropertyStandalone
    extends BeanELResolver.BeanProperty {
        private final String name;
        private final Method readMethod;
        private final Method writeMethod;

        BeanPropertyStandalone(Class<?> owner, PropertyDescriptor pd) {
            super(owner, pd.getType());
            this.name = pd.getName();
            this.readMethod = pd.getReadMethod();
            this.writeMethod = pd.getWriteMethod();
        }

        @Override
        String getName() {
            return this.name;
        }

        @Override
        Method getReadMethod() {
            return this.readMethod;
        }

        @Override
        Method getWriteMethod() {
            return this.writeMethod;
        }
    }
}

