/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.common;

import java.lang.reflect.Method;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.internal.common.AbstractInvocationHandler;

class Invocation
implements Callable<Object> {
    private final Method method;
    private final @Nullable Object @Nullable [] args;
    private final AbstractInvocationHandler<?> invocationHandler;
    private final Deque<Invocation> invocationStack = new LinkedList<Invocation>();
    private @Nullable Thread thread;

    Invocation(AbstractInvocationHandler<?> invocationHandler, Method method, @Nullable Object @Nullable [] args) {
        this.method = method;
        this.args = args;
        this.invocationHandler = invocationHandler;
        this.invocationStack.push(this);
    }

    @Nullable Thread getThread() {
        return this.thread;
    }

    @Override
    public Object call() throws Exception {
        this.thread = Thread.currentThread();
        return this.invocationHandler.invokeDirect(this);
    }

    Method getMethod() {
        return this.method;
    }

    Object[] getArgs() {
        return this.args;
    }

    long getTimeout() {
        return this.invocationHandler.getTimeout();
    }

    Object getIdentifier() {
        return this.invocationHandler.getIdentifier();
    }

    AbstractInvocationHandler<?> getInvocationHandler() {
        return this.invocationHandler;
    }

    public String toString() {
        return "invocation of '" + this.method.getName() + "()' on '" + String.valueOf(this.invocationHandler.getTarget()) + "'";
    }

    Deque<Invocation> getInvocationStack() {
        return this.invocationStack;
    }
}

