/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.event.command;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

@Command(scope="event", name="send", description="Send a simple event to a topic")
@Service
public class EventSendCommand
implements Action {
    @Reference
    Session session;
    @Reference
    EventAdmin eventAdmin;
    @Argument(index=0, required=true)
    String topic;
    @Argument(index=1, multiValued=true, description="Event properties in format key=value key2=value2 ...")
    List<String> properties;

    public Object execute() throws Exception {
        this.eventAdmin.sendEvent(new Event(this.topic, EventSendCommand.parse(this.properties)));
        return null;
    }

    static Map<String, String> parse(List<String> propList) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (propList != null) {
            for (String keyValue : propList) {
                int splitAt = keyValue.indexOf("=");
                if (splitAt <= 0) {
                    throw new IllegalArgumentException("Invalid property " + keyValue);
                }
                String key = keyValue.substring(0, splitAt);
                String value = keyValue.substring(splitAt + 1);
                properties.put(key, value);
            }
        }
        return properties;
    }
}

