/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.keyverifier;

import java.net.SocketAddress;
import java.security.PublicKey;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class StaticServerKeyVerifier
extends AbstractLoggingBean
implements ServerKeyVerifier {
    private final boolean acceptance;

    protected StaticServerKeyVerifier(boolean acceptance) {
        this.acceptance = acceptance;
    }

    public final boolean isAccepted() {
        return this.acceptance;
    }

    @Override
    public final boolean verifyServerKey(ClientSession sshClientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        boolean accepted = this.isAccepted();
        if (accepted) {
            this.handleAcceptance(sshClientSession, remoteAddress, serverKey);
        } else {
            this.handleRejection(sshClientSession, remoteAddress, serverKey);
        }
        return accepted;
    }

    protected void handleAcceptance(ClientSession sshClientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        this.log.warn("Server at {} presented unverified {} key: {}", new Object[]{remoteAddress, serverKey == null ? null : serverKey.getAlgorithm(), KeyUtils.getFingerPrint(serverKey)});
    }

    protected void handleRejection(ClientSession sshClientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Reject server {} unverified {} key: {}", new Object[]{remoteAddress, serverKey == null ? null : serverKey.getAlgorithm(), KeyUtils.getFingerPrint(serverKey)});
        }
    }
}

