/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest;
import com.amazonaws.services.ec2.model.ExportToS3TaskSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateInstanceExportTaskRequestMarshaller
implements Marshaller<Request<CreateInstanceExportTaskRequest>, CreateInstanceExportTaskRequest> {
    public Request<CreateInstanceExportTaskRequest> marshall(CreateInstanceExportTaskRequest createInstanceExportTaskRequest) {
        ExportToS3TaskSpecification exportToS3TaskSpecificationExportToS3Task;
        if (createInstanceExportTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createInstanceExportTaskRequest, "AmazonEC2");
        request.addParameter("Action", "CreateInstanceExportTask");
        request.addParameter("Version", "2015-04-15");
        if (createInstanceExportTaskRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createInstanceExportTaskRequest.getDescription()));
        }
        if (createInstanceExportTaskRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)createInstanceExportTaskRequest.getInstanceId()));
        }
        if (createInstanceExportTaskRequest.getTargetEnvironment() != null) {
            request.addParameter("TargetEnvironment", StringUtils.fromString((String)createInstanceExportTaskRequest.getTargetEnvironment()));
        }
        if ((exportToS3TaskSpecificationExportToS3Task = createInstanceExportTaskRequest.getExportToS3Task()) != null) {
            if (exportToS3TaskSpecificationExportToS3Task.getDiskImageFormat() != null) {
                request.addParameter("ExportToS3.DiskImageFormat", StringUtils.fromString((String)exportToS3TaskSpecificationExportToS3Task.getDiskImageFormat()));
            }
            if (exportToS3TaskSpecificationExportToS3Task.getContainerFormat() != null) {
                request.addParameter("ExportToS3.ContainerFormat", StringUtils.fromString((String)exportToS3TaskSpecificationExportToS3Task.getContainerFormat()));
            }
            if (exportToS3TaskSpecificationExportToS3Task.getS3Bucket() != null) {
                request.addParameter("ExportToS3.S3Bucket", StringUtils.fromString((String)exportToS3TaskSpecificationExportToS3Task.getS3Bucket()));
            }
            if (exportToS3TaskSpecificationExportToS3Task.getS3Prefix() != null) {
                request.addParameter("ExportToS3.S3Prefix", StringUtils.fromString((String)exportToS3TaskSpecificationExportToS3Task.getS3Prefix()));
            }
        }
        return request;
    }
}

