/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.coredump;

import java.io.File;
import java.io.IOException;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.snapshot.SnapshotsSupport;
import org.graalvm.visualvm.coredump.CoreDumpSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public abstract class CoreDump
extends Snapshot {
    private final File jdkHome;

    public CoreDump(File file, File jdkHome) throws IOException {
        this(file, jdkHome, null);
    }

    public CoreDump(File file, File jdkHome, DataSource master) throws IOException {
        super(file, CoreDumpSupport.getCategory(), master);
        if (!file.exists() || !file.isFile()) {
            throw new IOException("File " + file.getAbsolutePath() + " does not exist");
        }
        if (jdkHome != null) {
            if (!jdkHome.exists() || !jdkHome.isDirectory()) {
                throw new IOException("Java Home " + jdkHome.getAbsolutePath() + " does not exist");
            }
            this.jdkHome = jdkHome;
        } else {
            this.jdkHome = new File(System.getProperty("java.home")).getCanonicalFile();
        }
    }

    public final String getExecutable() {
        String home = this.getJDKHome();
        String exec = home + File.separatorChar + "bin" + File.separatorChar + "java";
        if (Utilities.isWindows()) {
            exec = exec + ".exe";
        }
        return exec;
    }

    public final String getJDKHome() {
        return this.jdkHome.getAbsolutePath();
    }

    public boolean supportsSaveAs() {
        return this.getFile() != null;
    }

    public void saveAs() {
        SnapshotsSupport.getInstance().saveAs((Snapshot)this, NbBundle.getMessage(CoreDump.class, (String)"LBL_Save_Core_Dump_As"));
    }
}

