/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.truffle;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.application.type.ApplicationType;
import org.graalvm.visualvm.application.type.ApplicationTypeFactory;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.sampler.truffle.ApplicationSamplerViewProvider;
import org.graalvm.visualvm.sampler.truffle.ProxyTruffleMBean;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;

public final class SamplerSupport {
    private static final Logger LOGGER = Logger.getLogger(SamplerSupport.class.getName());
    private static final String GRAALVM_ID = "GraalVM";
    private static SamplerSupport instance;
    private ApplicationSamplerViewProvider samplerViewProvider = new ApplicationSamplerViewProvider();

    public static synchronized SamplerSupport getInstance() {
        if (instance == null) {
            instance = new SamplerSupport();
        }
        return instance;
    }

    boolean supportsProfiling(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        if (!application.isLocalApplication()) {
            return this.isTruffleBeanLoaded(application);
        }
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        if (!jvm.isBasicInfoSupported() || !jvm.isAttachable()) {
            return false;
        }
        ApplicationType appType = ApplicationTypeFactory.getApplicationTypeFor((Application)application);
        if (appType.getClass().getName().contains("GraalVMApplicationType")) {
            return true;
        }
        return this.isRunningOnGraalVM(jvm);
    }

    void selectSamplerView(Application application) {
        if (application == null) {
            return;
        }
        DataSourceView activeView = this.samplerViewProvider.view(application);
        if (activeView == null) {
            return;
        }
        DataSourceWindowManager.sharedInstance().selectView(activeView);
    }

    private SamplerSupport() {
        this.samplerViewProvider.initialize();
    }

    private boolean isRunningOnGraalVM(Jvm jvm) {
        Properties props;
        if (jvm.getVmName().contains(GRAALVM_ID)) {
            return true;
        }
        if (jvm.isGetSystemPropertiesSupported() && (props = jvm.getSystemProperties()) != null) {
            String vendorVersion = props.getProperty("java.vendor.version", "");
            return vendorVersion.contains(GRAALVM_ID);
        }
        return false;
    }

    private boolean isTruffleBeanLoaded(Application application) {
        JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)application);
        if (jmxModel != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
            try {
                ProxyTruffleMBean tbean = new ProxyTruffleMBean(jmxModel.getMBeanServerConnection());
                if (tbean.isRegistered()) {
                    return true;
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "isTruffleBeanLoaded", ex);
                return false;
            }
        }
        return false;
    }
}

