/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.supplementaldata;

import java.util.HashMap;
import java.util.Map;

public enum SupplementalDataType {
    USER_MAPPING_DATA(new byte[]{0, 0}),
    AUTHZ_DATA(new byte[]{64, 2}),
    UNKNOWN(new byte[0]);

    private byte[] value;
    private static final Map<Integer, SupplementalDataType> MAP;

    private SupplementalDataType(byte[] value) {
        this.value = value;
    }

    private static int valueToInt(byte[] value) {
        if (value.length == 2) {
            return (value[0] & 0xFF) << 8 | value[1] & 0xFF;
        }
        return -1;
    }

    public static SupplementalDataType getSupplementalDataType(byte[] value) {
        SupplementalDataType type = MAP.get(SupplementalDataType.valueToInt(value));
        if (type == null) {
            return UNKNOWN;
        }
        return type;
    }

    public byte[] getValue() {
        return this.value;
    }

    static {
        MAP = new HashMap<Integer, SupplementalDataType>();
        for (SupplementalDataType s : SupplementalDataType.values()) {
            MAP.put(SupplementalDataType.valueToInt(s.value), s);
        }
    }
}

