/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.protocol.ModifiableVariableHolder;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import java.util.LinkedList;
import java.util.List;

public class ServerNameIndicationExtensionMessage
extends ExtensionMessage {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger serverNameListLength;
    @ModifiableVariableProperty
    private ModifiableByteArray serverNameListBytes;
    @HoldsModifiableVariable
    private List<ServerNamePair> serverNameList = new LinkedList<ServerNamePair>();

    public ServerNameIndicationExtensionMessage() {
        super(ExtensionType.SERVER_NAME_INDICATION);
    }

    public ModifiableInteger getServerNameListLength() {
        return this.serverNameListLength;
    }

    public void setServerNameListLength(ModifiableInteger serverNameListLength) {
        this.serverNameListLength = serverNameListLength;
    }

    public void setServerNameListLength(int length) {
        this.serverNameListLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.serverNameListLength, (Integer)length);
    }

    public ModifiableByteArray getServerNameListBytes() {
        return this.serverNameListBytes;
    }

    public void setServerNameListBytes(ModifiableByteArray serverNameListBytes) {
        this.serverNameListBytes = serverNameListBytes;
    }

    public void setServerNameListBytes(byte[] bytes) {
        this.serverNameListBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.serverNameListBytes, (byte[])bytes);
    }

    public List<ServerNamePair> getServerNameList() {
        return this.serverNameList;
    }

    public void setServerNameList(List<ServerNamePair> serverNameList) {
        this.serverNameList = serverNameList;
    }

    @Override
    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List<ModifiableVariableHolder> holders = super.getAllModifiableVariableHolders();
        if (this.serverNameList != null) {
            for (ServerNamePair pair : this.serverNameList) {
                if (pair == null) continue;
                holders.addAll(pair.getAllModifiableVariableHolders());
            }
        }
        return holders;
    }
}

