/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ConfigurationException;
import org.codehaus.groovy.tools.ErrorReporter;

public class FileSystemCompiler {
    private CompilationUnit unit;

    public FileSystemCompiler(CompilerConfiguration configuration) throws ConfigurationException {
        this.unit = new CompilationUnit(configuration);
    }

    public void compile(String[] paths) throws Exception {
        this.unit.addSources(paths);
        this.unit.compile();
    }

    public void compile(File[] files) throws Exception {
        this.unit.addSources(files);
        this.unit.compile();
    }

    public static void displayHelp() {
        System.err.println("Usage: groovyc <options> <source files>");
        System.err.println("where possible options include: ");
        System.err.println("  --classpath <path>        Specify where to find user class files");
        System.err.println("  -d <directory>            Specify where to place generated class files");
        System.err.println("  --encoding <encoding>     Specify the encoding of the user class files");
        System.err.println("  --version                 Print the verion");
        System.err.println("  --help                    Print a synopsis of standard options");
        System.err.println("  --exception               Print stack trace on error");
        System.err.println("");
    }

    public static void displayVersion() {
        System.err.println("groovy compiler version 1.0-rc1");
        System.err.println("Copyright 2003-2004 The Codehaus. http://groovy.codehaus.org/");
        System.err.println("");
    }

    public static int checkFiles(String[] filenames) {
        int errors = 0;
        for (int i = 0; i < filenames.length; ++i) {
            File file = new File(filenames[i]);
            if (!file.exists()) {
                System.err.println("error: file not found: " + file);
                ++errors;
                continue;
            }
            if (!file.canRead()) {
                System.err.println("error: file not readable: " + file);
                ++errors;
                continue;
            }
            String name = file.getName();
            int p = name.lastIndexOf(".");
            if (p++ < 0 || !name.substring(p).equals("java")) continue;
            System.err.println("error: cannot compile file with .java extension: " + file);
            ++errors;
        }
        return errors;
    }

    public static void main(String[] args) {
        boolean displayStackTraceOnError = false;
        try {
            Options options = new Options();
            OptionBuilder.withLongOpt((String)"classpath");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"classpath");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"sourcepath");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"sourcepath");
            options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)"encoding");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"encoding");
            options.addOption(OptionBuilder.create());
            OptionBuilder.hasArg();
            options.addOption(OptionBuilder.create((char)'d'));
            OptionBuilder.withLongOpt((String)"help");
            options.addOption(OptionBuilder.create((char)'h'));
            OptionBuilder.withLongOpt((String)"version");
            options.addOption(OptionBuilder.create((char)'v'));
            OptionBuilder.withLongOpt((String)"exception");
            options.addOption(OptionBuilder.create((char)'e'));
            PosixParser cliParser = new PosixParser();
            CommandLine cli = cliParser.parse(options, args);
            if (cli.hasOption('h')) {
                FileSystemCompiler.displayHelp();
                return;
            }
            if (cli.hasOption('v')) {
                FileSystemCompiler.displayVersion();
            }
            CompilerConfiguration configuration = new CompilerConfiguration();
            if (cli.hasOption("classpath")) {
                configuration.setClasspath(cli.getOptionValue("classpath"));
            }
            if (cli.hasOption('d')) {
                configuration.setTargetDirectory(cli.getOptionValue('d'));
            }
            if (cli.hasOption("encoding")) {
                configuration.setSourceEncoding(cli.getOptionValue("encoding"));
            }
            displayStackTraceOnError = cli.hasOption('e');
            String[] filenames = cli.getArgs();
            if (filenames.length == 0) {
                FileSystemCompiler.displayHelp();
                return;
            }
            int errors = FileSystemCompiler.checkFiles(filenames);
            if (errors == 0) {
                FileSystemCompiler compiler = new FileSystemCompiler(configuration);
                compiler.compile(filenames);
            }
        }
        catch (Throwable e) {
            new ErrorReporter(e, displayStackTraceOnError).write(System.err);
        }
    }
}

