/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBindBufferMemoryInfo;

public class VkBindBufferMemoryInfoKHR
extends VkBindBufferMemoryInfo {
    public VkBindBufferMemoryInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkBindBufferMemoryInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBindBufferMemoryInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryInfoKHR sType$Default() {
        return this.sType(1000157000);
    }

    @Override
    public VkBindBufferMemoryInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkBindBufferMemoryInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryInfoKHR buffer(@NativeType(value="VkBuffer") long value) {
        VkBindBufferMemoryInfoKHR.nbuffer(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryInfoKHR memory(@NativeType(value="VkDeviceMemory") long value) {
        VkBindBufferMemoryInfoKHR.nmemory(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryInfoKHR memoryOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBindBufferMemoryInfoKHR.nmemoryOffset(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryInfoKHR set(int sType, long pNext, long buffer, long memory, long memoryOffset) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        return this;
    }

    public VkBindBufferMemoryInfoKHR set(VkBindBufferMemoryInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBindBufferMemoryInfoKHR malloc() {
        return (VkBindBufferMemoryInfoKHR)VkBindBufferMemoryInfoKHR.wrap(VkBindBufferMemoryInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkBindBufferMemoryInfoKHR calloc() {
        return (VkBindBufferMemoryInfoKHR)VkBindBufferMemoryInfoKHR.wrap(VkBindBufferMemoryInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkBindBufferMemoryInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkBindBufferMemoryInfoKHR)VkBindBufferMemoryInfoKHR.wrap(VkBindBufferMemoryInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkBindBufferMemoryInfoKHR create(long address) {
        return (VkBindBufferMemoryInfoKHR)VkBindBufferMemoryInfoKHR.wrap(VkBindBufferMemoryInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkBindBufferMemoryInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkBindBufferMemoryInfoKHR)VkBindBufferMemoryInfoKHR.wrap(VkBindBufferMemoryInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkBindBufferMemoryInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkBindBufferMemoryInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkBindBufferMemoryInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindBufferMemoryInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkBindBufferMemoryInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkBindBufferMemoryInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkBindBufferMemoryInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkBindBufferMemoryInfoKHR mallocStack() {
        return VkBindBufferMemoryInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindBufferMemoryInfoKHR callocStack() {
        return VkBindBufferMemoryInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindBufferMemoryInfoKHR mallocStack(MemoryStack stack) {
        return VkBindBufferMemoryInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkBindBufferMemoryInfoKHR callocStack(MemoryStack stack) {
        return VkBindBufferMemoryInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBindBufferMemoryInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBindBufferMemoryInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryInfoKHR.calloc(capacity, stack);
    }

    public static VkBindBufferMemoryInfoKHR malloc(MemoryStack stack) {
        return (VkBindBufferMemoryInfoKHR)VkBindBufferMemoryInfoKHR.wrap(VkBindBufferMemoryInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindBufferMemoryInfoKHR calloc(MemoryStack stack) {
        return (VkBindBufferMemoryInfoKHR)VkBindBufferMemoryInfoKHR.wrap(VkBindBufferMemoryInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkBindBufferMemoryInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkBindBufferMemoryInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkBindBufferMemoryInfo.Buffer {
        private static final VkBindBufferMemoryInfoKHR ELEMENT_FACTORY = VkBindBufferMemoryInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBindBufferMemoryInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindBufferMemoryInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000157000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindBufferMemoryInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBindBufferMemoryInfoKHR.nbuffer(this.address(), value);
            return this;
        }

        @Override
        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkBindBufferMemoryInfoKHR.nmemory(this.address(), value);
            return this;
        }

        @Override
        public Buffer memoryOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBindBufferMemoryInfoKHR.nmemoryOffset(this.address(), value);
            return this;
        }
    }
}

