/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Key {
    private static PreparedStatement getReferenceCols;
    private static boolean printedHeader;

    public static void doKeys(Connection conn) throws SQLException {
        printedHeader = false;
        getReferenceCols = conn.prepareStatement("SELECT CG.TABLEID, CG.DESCRIPTOR FROM SYS.SYSCONGLOMERATES CG, SYS.SYSKEYS K WHERE K.CONSTRAINTID = ? AND K.CONGLOMERATEID = CG.CONGLOMERATEID");
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT CS.CONSTRAINTNAME, CS.TYPE, CS.TABLEID, CS.CONSTRAINTID, CS.SCHEMAID, CS.STATE, CG.DESCRIPTOR, CG.ISCONSTRAINT FROM SYS.SYSCONSTRAINTS CS, SYS.SYSCONGLOMERATES CG, SYS.SYSKEYS K WHERE CS.STATE != 'D' AND CS.CONSTRAINTID = K.CONSTRAINTID AND CG.CONGLOMERATEID = K.CONGLOMERATEID ORDER BY CS.TABLEID");
        DB_Key.createKeysFrom(rs);
        rs = stmt.executeQuery("SELECT CS.CONSTRAINTNAME, CS.TYPE, CS.TABLEID, CS.CONSTRAINTID, CS.SCHEMAID, CS.STATE, CG.DESCRIPTOR, CG.ISCONSTRAINT, K.DELETERULE, K.UPDATERULE, K.KEYCONSTRAINTID FROM SYS.SYSCONSTRAINTS CS, SYS.SYSCONGLOMERATES CG, SYS.SYSFOREIGNKEYS K WHERE CS.STATE != 'D' AND CS.CONSTRAINTID = K.CONSTRAINTID AND CG.CONGLOMERATEID = K.CONGLOMERATEID ORDER BY CS.TABLEID");
        DB_Key.createKeysFrom(rs);
        getReferenceCols.close();
        stmt.close();
        rs.close();
    }

    private static void createKeysFrom(ResultSet rs) throws SQLException {
        boolean firstTime = true;
        while (rs.next()) {
            String tableId;
            String tableName;
            if (!rs.getBoolean(8) || dblook.isExcludedTable(tableName = dblook.lookupTableId(tableId = rs.getString(3)))) continue;
            if (firstTime) {
                DB_Key.printHeader();
                if (rs.getString(2).equals("F")) {
                    Logs.reportMessage("DBLOOK_ForeignHeader");
                } else {
                    Logs.reportMessage("DBLOOK_PrimUniqueHeader");
                }
            }
            StringBuffer kString = DB_Key.createKeyString(tableId, tableName, rs);
            if (rs.getString(2).equals("F")) {
                kString.append(DB_Key.makeFKReferenceClause(rs.getString(11), rs.getString(9).charAt(0), rs.getString(10).charAt(0)));
            }
            DB_Key.makeDeferredClauses(kString, rs, 6);
            Logs.writeToNewDDL(kString.toString());
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
    }

    private static StringBuffer createKeyString(String tableId, String tableName, ResultSet aKey) throws SQLException {
        StringBuffer sb = new StringBuffer("ALTER TABLE ");
        sb.append(tableName);
        sb.append(" ADD");
        String constraintName = dblook.addQuotes(dblook.expandDoubleQuotes(aKey.getString(1)));
        sb.append(" CONSTRAINT ");
        sb.append(constraintName);
        sb.append(DB_Key.expandKeyType(aKey.getString(2).charAt(0)));
        sb.append("(");
        sb.append(dblook.getColumnListFromDescription(tableId, aKey.getString(7)));
        sb.append(")");
        return sb;
    }

    private static String expandKeyType(char keyType) {
        switch (keyType) {
            case 'P': {
                return " PRIMARY KEY ";
            }
            case 'U': {
                return " UNIQUE ";
            }
            case 'F': {
                return " FOREIGN KEY ";
            }
        }
        Logs.debug("INTERNAL ERROR: unexpected key type" + keyType, (String)null);
        return "";
    }

    private static String makeFKReferenceClause(String constraintId, char deleteChar, char updateChar) throws SQLException {
        StringBuffer refClause = new StringBuffer();
        getReferenceCols.setString(1, constraintId);
        ResultSet colsRS = getReferenceCols.executeQuery();
        colsRS.next();
        refClause.append(" REFERENCES ");
        refClause.append(dblook.lookupTableId(colsRS.getString(1)));
        refClause.append(" (");
        refClause.append(dblook.getColumnListFromDescription(colsRS.getString(1), colsRS.getString(2)));
        refClause.append(")");
        refClause.append(" ON DELETE ");
        switch (deleteChar) {
            case 'R': {
                refClause.append("NO ACTION");
                break;
            }
            case 'S': {
                refClause.append("RESTRICT");
                break;
            }
            case 'C': {
                refClause.append("CASCADE");
                break;
            }
            case 'U': {
                refClause.append("SET NULL");
                break;
            }
            default: {
                Logs.debug("INTERNAL ERROR: unexpected 'on-delete' action: " + deleteChar, (String)null);
            }
        }
        refClause.append(" ON UPDATE ");
        switch (updateChar) {
            case 'R': {
                refClause.append("NO ACTION");
                break;
            }
            case 'S': {
                refClause.append("RESTRICT");
                break;
            }
            default: {
                Logs.debug("INTERNAL ERROR: unexpected 'on-update' action: " + updateChar, (String)null);
            }
        }
        colsRS.close();
        return refClause.toString();
    }

    static void makeDeferredClauses(StringBuffer buffer, ResultSet constraint, int stateColumn) throws SQLException {
        String state = constraint.getString(stateColumn);
        String constraintName = dblook.addQuotes(dblook.expandDoubleQuotes(constraint.getString(1)));
        boolean deferrable = false;
        boolean initiallyDeferred = false;
        boolean enforced = true;
        switch (state.charAt(0)) {
            case 'E': {
                deferrable = false;
                initiallyDeferred = false;
                enforced = true;
                break;
            }
            case 'D': {
                deferrable = false;
                initiallyDeferred = false;
                enforced = false;
                break;
            }
            case 'e': {
                deferrable = true;
                initiallyDeferred = true;
                enforced = true;
                break;
            }
            case 'd': {
                deferrable = true;
                initiallyDeferred = true;
                enforced = false;
                break;
            }
            case 'i': {
                deferrable = true;
                initiallyDeferred = false;
                enforced = true;
                break;
            }
            case 'j': {
                deferrable = true;
                initiallyDeferred = false;
                enforced = false;
                break;
            }
            default: {
                Logs.debug("INTERNAL ERROR: Invalid state value '" + state + "' for constraint " + constraintName, (String)null);
            }
        }
        if (deferrable) {
            buffer.append(" DEFERRABLE ");
            if (initiallyDeferred) {
                buffer.append(" INITIALLY DEFERRED ");
            }
        }
    }

    private static void printHeader() {
        if (printedHeader) {
            return;
        }
        Logs.reportString("----------------------------------------------");
        Logs.reportMessage("DBLOOK_KeysHeader");
        Logs.reportString("----------------------------------------------\n");
        printedHeader = true;
    }
}

