/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.functions.Current;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternWithPredicate
extends Pattern {
    private Pattern basePattern;
    private Expression predicate;

    public PatternWithPredicate(Pattern basePattern, Expression predicate) {
        this.basePattern = basePattern;
        this.predicate = predicate;
    }

    @Override
    public void setPackageData(PackageData packageData) {
        super.setPackageData(packageData);
        this.basePattern.setPackageData(packageData);
    }

    @Override
    public void bindCurrent(LocalBinding binding) {
        if (this.predicate instanceof Current) {
            this.predicate = new LocalVariableReference(binding);
        } else if (ExpressionTool.callsFunction(this.predicate, Current.FN_CURRENT)) {
            PatternWithPredicate.replaceCurrent(this.predicate, binding);
        }
        this.basePattern.bindCurrent(binding);
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        Binding[] savedBindingList = offer.bindingList;
        this.basePattern.promote(offer, parent);
        this.predicate = this.predicate.promote(offer, parent);
        offer.bindingList = savedBindingList;
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        int n = ExpressionTool.allocateSlots(this.predicate, nextFree, slotManager);
        return this.basePattern.allocateSlots(slotManager, n);
    }

    @Override
    public boolean matches(Item item, XPathContext context) throws XPathException {
        if (!this.basePattern.matches(item, context)) {
            return false;
        }
        return this.matchesPredicate(item, context);
    }

    private boolean matchesPredicate(Item item, XPathContext context) throws XPathException {
        XPathContextMinor c2 = context.newMinorContext();
        ManualIterator si = new ManualIterator(item);
        c2.setCurrentIterator(si);
        try {
            return this.predicate.effectiveBooleanValue(c2);
        }
        catch (XPathException.Circularity e) {
            throw e;
        }
        catch (XPathException ex) {
            if ("XTDE0640".equals(ex.getErrorCodeLocalPart())) {
                throw ex;
            }
            XPathException err = new XPathException("An error occurred matching pattern {" + this.toString() + "}: ", ex);
            err.setXPathContext(c2);
            err.setErrorCodeQName(ex.getErrorCodeQName());
            err.setLocator(this);
            c2.getController().recoverableError(err);
            return false;
        }
    }

    @Override
    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        return this.basePattern.matchesBeneathAnchor(node, anchor, context) && this.matchesPredicate(node, context);
    }

    @Override
    public int getNodeKind() {
        return this.basePattern.getNodeKind();
    }

    @Override
    public int getNodeKindMask() {
        return this.basePattern.getNodeKindMask();
    }

    @Override
    public int getFingerprint() {
        return this.basePattern.getFingerprint();
    }

    @Override
    public ItemType getItemType() {
        return this.basePattern.getItemType();
    }

    @Override
    public int getDependencies() {
        return this.predicate.getDependencies();
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator<Expression>(new PatternSponsor(this.basePattern), this.predicate);
    }

    @Override
    public Pattern analyze(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        ContextItemStaticInfo cit = new ContextItemStaticInfo(this.getItemType(), false, true);
        this.predicate = visitor.typeCheck(this.predicate, cit);
        this.predicate = visitor.optimize(this.predicate, cit);
        this.basePattern = this.basePattern.analyze(visitor, contextItemType);
        return this;
    }

    @Override
    public Pattern convertToTypedPattern(String val) throws XPathException {
        Pattern b2 = this.basePattern.convertToTypedPattern(val);
        if (b2 == this.basePattern) {
            return this;
        }
        return new PatternWithPredicate(b2, this.predicate);
    }
}

