/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.data;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.DataHolder;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.FetchRequest;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDbPool;
import org.rrd4j.core.Util;
import org.rrd4j.data.Aggregates;
import org.rrd4j.data.CDef;
import org.rrd4j.data.Def;
import org.rrd4j.data.IPlottable;
import org.rrd4j.data.NonRrdSource;
import org.rrd4j.data.Normalizer;
import org.rrd4j.data.PDef;
import org.rrd4j.data.Plottable;
import org.rrd4j.data.Source;
import org.rrd4j.data.VDef;
import org.rrd4j.data.Variable;

public class DataProcessor
implements DataHolder {
    @Deprecated
    public static final int DEFAULT_PIXEL_COUNT = 600;
    public static final double DEFAULT_PERCENTILE = 95.0;
    private int pixelCount = 0;
    private boolean poolUsed = false;
    private RrdDbPool pool = null;
    private long tStart;
    private long tEnd;
    private long[] timestamps;
    private long lastRrdArchiveUpdateTime = 0L;
    private long step = 0L;
    private long fetchRequestResolution = 1L;
    private TimeZone tz = TimeZone.getDefault();
    private final Map<String, Source> sources = new LinkedHashMap<String, Source>();
    private Def[] defSources;

    public DataProcessor(long t1, long t2) {
        if (!(t1 < t2 && t1 > 0L && t2 > 0L || t1 > 0L && t2 == 0L)) {
            throw new IllegalArgumentException("Invalid timestamps specified: " + t1 + ", " + t2);
        }
        this.tStart = t1;
        this.tEnd = t2;
    }

    public DataProcessor(Date d1, Date d2) {
        this(Util.getTimestamp(d1), d2 != null ? Util.getTimestamp(d2) : 0L);
    }

    public DataProcessor(Calendar gc1, Calendar gc2) {
        this(Util.getTimestamp(gc1), gc2 != null ? Util.getTimestamp(gc2) : 0L);
        this.tz = gc1.getTimeZone();
    }

    public DataProcessor(TemporalAmount d) {
        Instant now = Instant.now();
        this.tEnd = now.getEpochSecond();
        this.tStart = now.minus(d).getEpochSecond();
    }

    @Override
    public boolean isPoolUsed() {
        return this.poolUsed;
    }

    @Override
    public void setPoolUsed(boolean poolUsed) {
        this.poolUsed = poolUsed;
    }

    @Override
    public RrdDbPool getPool() {
        return this.pool;
    }

    @Override
    public void setPool(RrdDbPool pool) {
        this.pool = pool;
    }

    public void setPixelCount(int pixelCount) {
        this.pixelCount = pixelCount;
    }

    public int getPixelCount() {
        return this.pixelCount;
    }

    @Override
    public void setStep(long step) {
        this.step = step;
    }

    @Override
    public long getStep() {
        return this.step;
    }

    public long getFetchRequestResolution() {
        return this.fetchRequestResolution;
    }

    public void setFetchRequestResolution(long fetchRequestResolution) {
        this.fetchRequestResolution = fetchRequestResolution;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.tz;
    }

    @Override
    public void setTimeZone(TimeZone tz) {
        this.tz = tz;
    }

    @Deprecated
    public long getEndingTimestamp() {
        return this.tEnd;
    }

    public long[] getTimestamps() {
        if (this.timestamps == null) {
            throw new IllegalStateException("Timestamps not calculated yet");
        }
        return this.timestamps;
    }

    public double[] getValues(String sourceName) {
        Source source = this.getSource(sourceName);
        double[] values = source.getValues();
        if (values == null) {
            throw new IllegalArgumentException("Values not available for source [" + sourceName + "]");
        }
        return values;
    }

    @Deprecated
    public double getAggregate(String sourceName, ConsolFun consolFun) {
        Variable v = consolFun.getVariable();
        Source source = this.getSource(sourceName);
        v.calculate(source, this.tStart, this.tEnd);
        return v.getValue().value;
    }

    @Deprecated
    public Aggregates getAggregates(String sourceName) {
        Source source = this.getSource(sourceName);
        return source.getAggregates(this.tStart, this.tEnd);
    }

    public Variable.Value getVariable(String sourceName) {
        Source source = this.getSource(sourceName);
        if (source instanceof VDef) {
            return ((VDef)source).getValue();
        }
        throw new IllegalArgumentException(String.format("%s is not a Variable source", source.getName()));
    }

    public Variable.Value getVariable(String sourceName, Variable var) {
        Source source = this.getSource(sourceName);
        var.calculate(source, this.tStart, this.tEnd);
        return var.getValue();
    }

    @Deprecated
    public double get95Percentile(String sourceName) {
        return this.getPercentile(sourceName);
    }

    @Deprecated
    public double getPercentile(String sourceName) {
        return this.getPercentile(sourceName, 95.0);
    }

    @Deprecated
    public double getPercentile(String sourceName, double percentile) {
        if (percentile <= 0.0 || percentile > 100.0) {
            throw new IllegalArgumentException("Invalid percentile [" + percentile + "], should be between 0 and 100");
        }
        Source source = this.getSource(sourceName);
        return source.getPercentile(this.tStart, this.tEnd, percentile);
    }

    public String[] getSourceNames() {
        return this.sources.keySet().toArray(new String[0]);
    }

    public double[][] getValues() {
        String[] names = this.getSourceNames();
        double[][] values = new double[names.length][];
        for (int i = 0; i < names.length; ++i) {
            values[i] = this.getValues(names[i]);
        }
        return values;
    }

    Source getSource(String sourceName) {
        Source source = this.sources.get(sourceName);
        if (source != null) {
            return source;
        }
        throw new IllegalArgumentException("Unknown source: " + sourceName);
    }

    @Deprecated
    public void addDatasource(String name, Plottable plottable) {
        this.datasource(name, plottable);
    }

    @Override
    public void datasource(String name, IPlottable plottable) {
        PDef pDef = new PDef(name, plottable);
        this.sources.put(name, pDef);
    }

    @Deprecated
    public void addDatasource(String name, String rpnExpression) {
        this.datasource(name, rpnExpression);
    }

    @Override
    public void datasource(String name, String rpnExpression) {
        CDef cDef = new CDef(name, rpnExpression);
        this.sources.put(name, cDef);
    }

    @Deprecated
    public void addDatasource(String name, String defName, ConsolFun consolFun) {
        VDef sDef = new VDef(name, defName, consolFun.getVariable());
        this.sources.put(name, sDef);
    }

    @Deprecated
    public void addDatasource(String name, String sourceName, double percentile) {
        this.sources.put(name, new VDef(name, sourceName, new Variable.PERCENTILE(percentile)));
    }

    @Deprecated
    public void addDatasource(String name, String defName, Variable var) {
        this.datasource(name, defName, var);
    }

    @Override
    public void datasource(String name, String defName, Variable var) {
        VDef sDef = new VDef(name, defName, var);
        this.sources.put(name, sDef);
    }

    @Deprecated
    public void addDatasource(String name, String file, String dsName, ConsolFun consolFunc) {
        this.datasource(name, file, dsName, consolFunc);
    }

    @Override
    public void datasource(String name, String file, String dsName, ConsolFun consolFunc) {
        RrdBackendFactory factory = RrdBackendFactory.getDefaultFactory();
        Def def = new Def(name, factory.getUri(file), dsName, consolFunc, factory);
        this.sources.put(name, def);
    }

    @Override
    public void datasource(String name, URI rrdUri, String dsName, ConsolFun consolFunc) {
        Def def = new Def(name, rrdUri, dsName, consolFunc, RrdBackendFactory.findFactory(rrdUri));
        this.sources.put(name, def);
    }

    @Deprecated
    public void addDatasource(String name, String file, String dsName, ConsolFun consolFunc, String backend) {
        RrdBackendFactory factory = RrdBackendFactory.getFactory(backend);
        Def def = new Def(name, factory.getUri(file), dsName, consolFunc, factory);
        this.sources.put(name, def);
    }

    @Deprecated
    public void addDatasource(String name, String file, String dsName, ConsolFun consolFunc, RrdBackendFactory backend) {
        this.datasource(name, file, dsName, consolFunc, backend);
    }

    @Override
    public void datasource(String name, String file, String dsName, ConsolFun consolFunc, RrdBackendFactory backend) {
        Def def = new Def(name, backend.getUri(file), dsName, consolFunc, backend);
        this.sources.put(name, def);
    }

    @Override
    public void datasource(String name, URI uri, String dsName, ConsolFun consolFunc, RrdBackendFactory backend) {
        Def def = new Def(name, uri, dsName, consolFunc, backend);
        this.sources.put(name, def);
    }

    @Deprecated
    public void addDatasource(String name, FetchData fetchData) {
        this.datasource(name, fetchData);
    }

    @Override
    public void datasource(String name, FetchData fetchData) {
        Def def = new Def(name, fetchData);
        this.sources.put(name, def);
    }

    @Deprecated
    public void addDatasource(String name, String dsName, FetchData fetchData) {
        Def def = new Def(name, dsName, fetchData);
        this.sources.put(name, def);
    }

    @Override
    public void datasource(String name, String dsName, FetchData fetchData) {
        Def def = new Def(name, dsName, fetchData);
        this.sources.put(name, def);
    }

    public void processData() throws IOException {
        this.extractDefs();
        this.fetchRrdData();
        this.fixZeroEndingTimestamp();
        this.chooseOptimalStep();
        this.createTimestamps();
        this.assignTimestampsToSources();
        this.normalizeRrdValues();
        this.calculateNonRrdSources();
    }

    public double[] getValuesPerPixel(String sourceName, int pixelCount) {
        this.setPixelCount(pixelCount);
        return this.getValuesPerPixel(sourceName);
    }

    public double[] getValuesPerPixel(String sourceName) {
        double[] values = this.getValues(sourceName);
        double[] pixelValues = new double[this.pixelCount];
        Arrays.fill(pixelValues, Double.NaN);
        long span = this.tEnd - this.tStart;
        int ref = 0;
        block0: for (int pix = 0; pix < this.pixelCount; ++pix) {
            double t = (double)this.tStart + (double)(span * (long)pix) / (double)(this.pixelCount - 1);
            while (ref < this.timestamps.length && !(t <= (double)(this.timestamps[ref] - this.step))) {
                if (t <= (double)this.timestamps[ref]) {
                    pixelValues[pix] = values[ref];
                    continue block0;
                }
                ++ref;
            }
        }
        return pixelValues;
    }

    public long[] getTimestampsPerPixel(int pixelCount) {
        this.setPixelCount(pixelCount);
        return this.getTimestampsPerPixel();
    }

    public long[] getTimestampsPerPixel() {
        long[] times = new long[this.pixelCount];
        long span = this.tEnd - this.tStart;
        for (int i = 0; i < this.pixelCount; ++i) {
            times[i] = Math.round((double)this.tStart + (double)(span * (long)i) / (double)(this.pixelCount - 1));
        }
        return times;
    }

    public String dump() {
        String[] names = this.getSourceNames();
        double[][] values = this.getValues();
        StringBuilder buffer = new StringBuilder();
        buffer.append(DataProcessor.format("timestamp", 12));
        for (String name : names) {
            buffer.append(DataProcessor.format(name, 20));
        }
        buffer.append("\n");
        for (int i = 0; i < this.timestamps.length; ++i) {
            buffer.append(DataProcessor.format(Long.toString(this.timestamps[i]), 12));
            for (int j = 0; j < names.length; ++j) {
                buffer.append(DataProcessor.format(Util.formatDouble(values[j][i]), 20));
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public long getLastRrdArchiveUpdateTime() {
        return this.lastRrdArchiveUpdateTime;
    }

    private void extractDefs() {
        this.defSources = (Def[])this.sources.values().stream().filter(Def.class::isInstance).toArray(Def[]::new);
    }

    private void fetchRrdData() throws IOException {
        long tEndFixed = this.tEnd == 0L ? Util.getTime() : this.tEnd;
        RrdDb[] batchRrd = new RrdDb[this.defSources.length];
        HashMap<URI, RrdDb> openRrd = new HashMap<URI, RrdDb>(this.defSources.length);
        HashSet newDb = new HashSet(this.defSources.length);
        try {
            int d = 0;
            for (Def def : this.defSources) {
                URI curi = def.getCanonicalUri();
                batchRrd[d++] = openRrd.computeIfAbsent(curi, uri -> {
                    if (!def.isLoaded()) {
                        RrdBackendFactory backend = def.getBackend();
                        try {
                            RrdDb rrdDb = RrdDb.getBuilder().setPath(curi).setBackendFactory(backend).readOnly().setPool(this.pool).setUsePool(this.poolUsed).build();
                            newDb.add(rrdDb);
                            return rrdDb;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    return def.getRrdDb();
                });
            }
            for (int i = 0; i < this.defSources.length; ++i) {
                if (batchRrd[i] == null || this.defSources[i].isLoaded()) continue;
                HashSet<String> dsNames = new HashSet<String>();
                dsNames.add(this.defSources[i].getDsName());
                for (int j = i + 1; j < this.defSources.length; ++j) {
                    if (!this.defSources[i].isCompatibleWith(this.defSources[j])) continue;
                    dsNames.add(this.defSources[j].getDsName());
                }
                this.lastRrdArchiveUpdateTime = Math.max(this.lastRrdArchiveUpdateTime, batchRrd[i].getLastArchiveUpdateTime());
                FetchRequest req = batchRrd[i].createFetchRequest(this.defSources[i].getConsolFun(), this.tStart, tEndFixed, this.fetchRequestResolution);
                req.setFilter(dsNames);
                FetchData data = req.fetchData();
                assert (data != null);
                this.defSources[i].setFetchData(data);
                for (int j = i + 1; j < this.defSources.length; ++j) {
                    if (!this.defSources[i].isCompatibleWith(this.defSources[j])) continue;
                    this.defSources[j].setFetchData(data);
                }
            }
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
        finally {
            newDb.forEach(t -> {
                try {
                    t.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    private void fixZeroEndingTimestamp() {
        if (this.tEnd == 0L) {
            if (this.defSources.length == 0) {
                throw new IllegalStateException("Could not adjust zero ending timestamp, no DEF source provided");
            }
            this.tEnd = this.defSources[0].getArchiveEndTime();
            for (int i = 1; i < this.defSources.length; ++i) {
                this.tEnd = Math.min(this.tEnd, this.defSources[i].getArchiveEndTime());
            }
            if (this.tEnd <= this.tStart) {
                throw new IllegalStateException("Could not resolve zero ending timestamp.");
            }
        }
    }

    private void chooseOptimalStep() {
        long newStep = Long.MAX_VALUE;
        for (Def defSource : this.defSources) {
            long fetchStep;
            long tryStep = fetchStep = defSource.getFetchStep();
            if (this.step > 0L) {
                tryStep = Math.min(newStep, ((this.step - 1L) / fetchStep + 1L) * fetchStep);
            }
            newStep = Math.min(newStep, tryStep);
        }
        if (newStep != Long.MAX_VALUE) {
            this.step = newStep;
        } else if (this.pixelCount != 0) {
            this.step = Math.max((this.tEnd - this.tStart) / (long)this.pixelCount, 1L);
        } else if (this.step <= 0L) {
            this.step = 1L;
        }
    }

    private void createTimestamps() {
        long t1 = Util.normalize(this.tStart, this.step);
        long t2 = Util.normalize(this.tEnd, this.step);
        if (t2 < this.tEnd) {
            t2 += this.step;
        }
        int count = (int)((t2 - t1) / this.step + 1L);
        this.timestamps = new long[count];
        for (int i = 0; i < count; ++i) {
            this.timestamps[i] = t1;
            t1 += this.step;
        }
    }

    private void assignTimestampsToSources() {
        for (Source src : this.sources.values()) {
            src.setTimestamps(this.timestamps);
        }
    }

    private void normalizeRrdValues() {
        Normalizer normalizer = new Normalizer(this.timestamps);
        for (Def def : this.defSources) {
            long[] rrdTimestamps = def.getRrdTimestamps();
            double[] rrdValues = def.getRrdValues();
            def.setValues(normalizer.normalize(rrdTimestamps, rrdValues));
        }
    }

    private void calculateNonRrdSources() {
        for (Source source : this.sources.values()) {
            if (!(source instanceof NonRrdSource)) continue;
            ((NonRrdSource)((Object)source)).calculate(this.tStart, this.tEnd, this);
        }
    }

    private static String format(String s, int length) {
        StringBuilder b = new StringBuilder(s);
        for (int i = 0; i < length - s.length(); ++i) {
            b.append(' ');
        }
        return b.toString();
    }

    @Override
    public void setEndTime(long time) {
        this.tEnd = time;
    }

    @Override
    public long getEndTime() {
        return this.tEnd;
    }

    @Override
    public void setStartTime(long time) {
        this.tStart = time;
    }

    @Override
    public long getStartTime() {
        return this.tStart;
    }

    @Override
    public void setTimeSpan(long startTime, long endTime) {
        this.tStart = startTime;
        this.tEnd = endTime;
    }
}

