/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUnionType
implements PyType {
    private final @NotNull LinkedHashSet<@Nullable PyType> myMembers;

    PyUnionType(@NotNull LinkedHashSet<@Nullable PyType> members) {
        if (members == null) {
            PyUnionType.$$$reportNull$$$0(0);
        }
        this.myMembers = new LinkedHashSet<PyType>(members);
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name2, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name2 == null) {
            PyUnionType.$$$reportNull$$$0(1);
        }
        if (direction == null) {
            PyUnionType.$$$reportNull$$$0(2);
        }
        if (resolveContext == null) {
            PyUnionType.$$$reportNull$$$0(3);
        }
        SmartList ret = new SmartList();
        boolean allNulls = true;
        for (PyType member : this.myMembers) {
            List<? extends RatedResolveResult> result2;
            if (member == null || (result2 = member.resolveMember(name2, location, direction, resolveContext)) == null) continue;
            allNulls = false;
            ret.addAll(result2);
        }
        return allNulls ? null : ret;
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        HashSet variants = new HashSet();
        for (PyType member : this.myMembers) {
            if (member == null) continue;
            Collections.addAll(variants, member.getCompletionVariants(completionPrefix, location, context));
        }
        return ArrayUtil.toObjectArray(variants);
    }

    @Override
    public String getName() {
        return StringUtil.join(this.myMembers, (Function)((NullableFunction)type2 -> type2 != null ? type2.getName() : null), (String)" | ");
    }

    @Override
    public boolean isBuiltin() {
        for (PyType one : this.myMembers) {
            if (one != null && one.isBuiltin()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void assertValid(String message) {
        for (PyType member : this.myMembers) {
            if (member == null) continue;
            member.assertValid(message);
        }
    }

    @Nullable
    public static PyType union(@Nullable PyType type1, @Nullable PyType type2) {
        return PyUnionType.union(Arrays.asList(type1, type2));
    }

    @Nullable
    public static PyType union(@NotNull Collection<@Nullable PyType> members) {
        if (members == null) {
            PyUnionType.$$$reportNull$$$0(4);
        }
        if (members.size() < 2) {
            return (PyType)ContainerUtil.getFirstItem(members);
        }
        LinkedHashSet<PyType> newMembers = new LinkedHashSet<PyType>();
        for (PyType member : members) {
            if (member instanceof PyUnionType) {
                newMembers.addAll(((PyUnionType)member).getMembers());
                continue;
            }
            newMembers.add(member);
        }
        return newMembers.size() < 2 ? (PyType)ContainerUtil.getFirstItem(newMembers) : new PyUnionType(newMembers);
    }

    @Nullable
    public static PyType createWeakType(@Nullable PyType type2) {
        PyUnionType unionType;
        if (type2 == null) {
            return null;
        }
        if (type2 instanceof PyUnionType && (unionType = (PyUnionType)type2).isWeak()) {
            return unionType;
        }
        return PyUnionType.union(type2, null);
    }

    @Nullable
    public static PyType toNonWeakType(@Nullable PyType type2) {
        return type2 instanceof PyUnionType ? ((PyUnionType)type2).excludeNull() : type2;
    }

    public boolean isWeak() {
        return this.myMembers.contains(null);
    }

    @NotNull
    public Collection<PyType> getMembers() {
        Collection<PyType> collection = Collections.unmodifiableCollection(this.myMembers);
        if (collection == null) {
            PyUnionType.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Nullable
    public PyType map(@NotNull java.util.function.Function<@Nullable PyType, @Nullable PyType> mapper) {
        if (mapper == null) {
            PyUnionType.$$$reportNull$$$0(6);
        }
        return PyUnionType.union(ContainerUtil.map(this.getMembers(), t -> (PyType)mapper.apply((PyType)t)));
    }

    @Nullable
    public PyType exclude(@Nullable PyType type2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyUnionType.$$$reportNull$$$0(7);
        }
        if (type2 == null) {
            return this.excludeNull();
        }
        ArrayList<PyType> members = new ArrayList<PyType>();
        for (PyType m : this.getMembers()) {
            if (PyTypeChecker.match(type2, m, context)) continue;
            members.add(m);
        }
        return PyUnionType.union(members);
    }

    @Nullable
    public PyType excludeNull() {
        return !this.isWeak() ? this : PyUnionType.union(ContainerUtil.skipNulls(this.getMembers()));
    }

    public boolean equals(Object other) {
        if (other instanceof PyUnionType) {
            PyUnionType otherType = (PyUnionType)other;
            return this.myMembers.equals(otherType.myMembers);
        }
        return false;
    }

    public int hashCode() {
        return this.myMembers.hashCode();
    }

    public String toString() {
        return "PyUnionType: " + this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyUnionType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyUnionType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

