/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.featuresTrainer.ift;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenProjectTaskBuilder;
import com.intellij.ide.impl.OpenProjectTaskKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.python.featuresTrainer.ift.PythonLessonsBundle;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.newProject.steps.ProjectSpecificSettingsStep;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.PySdkToInstall;
import com.jetbrains.python.sdk.add.PyAddSdkPanelKt;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfiguration;
import com.jetbrains.python.sdk.configuration.PyProjectVirtualEnvConfiguration;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.awt.Dimension;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LessonContext;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.lang.AbstractLangSupport;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.course.KLesson;
import training.learn.course.Lesson;
import training.project.ProjectUtils;
import training.project.ReadMeCreator;
import training.statistic.LearningInternalProblems;
import training.statistic.LessonStartingWay;
import training.ui.LearningUiManager;
import training.util.UtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\t0\u000fH\u0016J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\rH\u0003J2\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140\u001bH\u0002J\u001a\u0010!\u001a\u00020\t2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u001e\u0010&\u001a\u00020\t2\u0014\u0010'\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0004\u0012\u00020\t0\u000fH\u0016J \u0010(\u001a\u0004\u0018\u00010\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u001b2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0015\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\"\u001a\u00020#X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R:\u0010-\u001a(\u0012\u0004\u0012\u00020/\u0012\u0013\u0012\u001100\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(1\u0012\u0004\u0012\u00020\t0.\u00a2\u0006\u0002\b2X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u00065"}, d2={"Lcom/intellij/python/featuresTrainer/ift/PythonBasedLangSupport;", "Ltraining/lang/AbstractLangSupport;", "<init>", "()V", "readMeCreator", "Ltraining/project/ReadMeCreator;", "getReadMeCreator", "()Ltraining/project/ReadMeCreator;", "installAndOpenLearningProject", "", "contentRoot", "Ljava/nio/file/Path;", "projectToClose", "Lcom/intellij/openapi/project/Project;", "postInitCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "learnProject", "getSdkForProject", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "selectedSdk", "createAndSetVenvSdk", "applyBaseSdk", "preferredSdk", "existingSdks", "", "module", "Lcom/intellij/openapi/module/Module;", "applyProjectSdk", "sdk", "getExistingSdks", "checkSdk", "sampleFilePath", "", "getSampleFilePath", "()Ljava/lang/String;", "startFromWelcomeFrame", "startCallback", "showSdkChoosingDialog", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "isSdkConfigured", "", "sdkConfigurationTasks", "Lkotlin/Function2;", "Ltraining/dsl/LessonContext;", "Ltraining/learn/course/KLesson;", "lesson", "Lkotlin/ExtensionFunctionType;", "getSdkConfigurationTasks", "()Lkotlin/jvm/functions/Function2;", "intellij.python.featuresTrainer"})
public abstract class PythonBasedLangSupport
extends AbstractLangSupport {
    @NotNull
    private final ReadMeCreator readMeCreator = new ReadMeCreator();
    @NotNull
    private final String sampleFilePath;
    @NotNull
    private final Function2<LessonContext, KLesson, Unit> sdkConfigurationTasks = (arg_0, arg_1) -> PythonBasedLangSupport.sdkConfigurationTasks$lambda$13(this, arg_0, arg_1);

    public PythonBasedLangSupport() {
        this.sampleFilePath = "src/sandbox.py";
    }

    @NotNull
    public ReadMeCreator getReadMeCreator() {
        return this.readMeCreator;
    }

    public void installAndOpenLearningProject(@NotNull Path contentRoot, @Nullable Project projectToClose, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        OpenProjectTask openProjectTask = OpenProjectTaskKt.OpenProjectTask(arg_0 -> PythonBasedLangSupport.installAndOpenLearningProject$lambda$0(projectToClose, arg_0));
        ProjectUtils.INSTANCE.simpleInstallAndOpenLearningProject(contentRoot, (LangSupport)this, openProjectTask, postInitCallback);
    }

    @Nullable
    public Sdk getSdkForProject(@NotNull Project project, @Nullable Sdk selectedSdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (selectedSdk != null) {
            Module module = (Module)ArraysKt.first((Object[])PyStatisticToolsKt.getModules(project));
            List<Sdk> existingSdks = this.getExistingSdks();
            return this.applyBaseSdk(project, selectedSdk, existingSdks, module);
        }
        if (PySdkExtKt.getPythonSdk(project) != null) {
            return null;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> PythonBasedLangSupport.getSdkForProject$lambda$1(this, project));
        return null;
    }

    @RequiresBackgroundThread
    private final void createAndSetVenvSdk(Project project) {
        Module module = (Module)ArraysKt.first((Object[])PyStatisticToolsKt.getModules(project));
        List<Sdk> existingSdks = this.getExistingSdks();
        List<Sdk> baseSdks = PySdkExtKt.findBaseSdks(existingSdks, module, (UserDataHolder)project);
        Sdk sdk2 = PyProjectVirtualEnvConfiguration.findPreferredVirtualEnvBaseSdk(baseSdks);
        if (sdk2 == null) {
            return;
        }
        Sdk preferredSdk = sdk2;
        ActionsKt.invokeLater$default(null, () -> PythonBasedLangSupport.createAndSetVenvSdk$lambda$2(this, project, preferredSdk, existingSdks, module), (int)1, null);
    }

    private final Sdk applyBaseSdk(Project project, Sdk preferredSdk, List<? extends Sdk> existingSdks, Module module) {
        Sdk venvSdk;
        Sdk sdk2;
        String string = FileUtil.toSystemDependentName((String)PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBasePath(project.getBasePath()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        String venvRoot = string;
        Sdk it = sdk2 = (venvSdk = PyProjectVirtualEnvConfiguration.createVirtualEnvSynchronously$default(preferredSdk, existingSdks, venvRoot, project.getBasePath(), project, module, (UserDataHolder)project, false, false, null, 896, null));
        boolean bl = false;
        SdkConfigurationUtil.addSdk((Sdk)it);
        return sdk2;
    }

    public void applyProjectSdk(@NotNull Sdk sdk2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PyProjectSdkConfiguration.INSTANCE.setReadyToUseSdk(project, (Module)ArraysKt.first((Object[])PyStatisticToolsKt.getModules(project)), sdk2);
    }

    private final List<Sdk> getExistingSdks() {
        List<Sdk> list = PyConfigurableInterpreterList.getInstance(null).getAllPythonSdks();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllPythonSdks(...)");
        Iterable iterable = list;
        PreferredSdkComparator preferredSdkComparator = PreferredSdkComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)preferredSdkComparator, (String)"INSTANCE");
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)preferredSdkComparator);
    }

    public void checkSdk(@Nullable Sdk sdk2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @NotNull
    public String getSampleFilePath() {
        return this.sampleFilePath;
    }

    public void startFromWelcomeFrame(@NotNull Function1<? super Sdk, Unit> startCallback) {
        Intrinsics.checkNotNullParameter(startCallback, (String)"startCallback");
        Sdk[] sdkArray = PyConfigurableInterpreterList.getInstance(null).getModel().getSdks();
        List allExistingSdks = CollectionsKt.listOf((Object[])Arrays.copyOf(sdkArray, sdkArray.length));
        List<Sdk> list = ProjectSpecificSettingsStep.getValidPythonSdks(allExistingSdks);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValidPythonSdks(...)");
        List<Sdk> existingSdks = list;
        ApplicationManager.getApplication().executeOnPooledThread(() -> PythonBasedLangSupport.startFromWelcomeFrame$lambda$5(existingSdks, this, startCallback));
    }

    private final Sdk showSdkChoosingDialog(List<? extends Sdk> existingSdks, UserDataHolder context) {
        PySdkPathChoosingComboBox baseSdkField = new PySdkPathChoosingComboBox(null, null, null, null, 15, null);
        JLabel warningPlaceholder = new JLabel();
        JPanel formPanel = FormBuilder.createFormBuilder().addComponent((JComponent)warningPlaceholder).addLabeledComponent(PySdkBundle.message("python.venv.base.label", new Object[0]), (JComponent)((Object)baseSdkField)).getPanel();
        formPanel.setPreferredSize(new Dimension(Math.max(formPanel.getPreferredSize().width, 500), formPanel.getPreferredSize().height));
        Project project = ProjectManager.getInstance().getDefaultProject();
        DialogWrapper dialog2 = new DialogWrapper(formPanel, project){
            final /* synthetic */ JPanel $formPanel;
            {
                this.$formPanel = $formPanel;
                super($super_call_param$1);
                this.setTitle(PyBundle.message("sdk.select.path", new Object[0]));
                this.init();
            }

            protected JComponent createCenterPanel() {
                JPanel jPanel = this.$formPanel;
                Intrinsics.checkNotNull((Object)jPanel);
                return jPanel;
            }
        };
        PyAddSdkPanelKt.addBaseInterpretersAsync(baseSdkField, existingSdks, null, context, (Function0<Unit>)((Function0)() -> PythonBasedLangSupport.showSdkChoosingDialog$lambda$6(baseSdkField, warningPlaceholder)));
        dialog2.setTitle(PythonLessonsBundle.INSTANCE.message("choose.python.sdk.to.start.learning.header", new Object[0]));
        return dialog2.showAndGet() ? baseSdkField.getSelectedSdk() : null;
    }

    public boolean isSdkConfigured(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PySdkExtKt.getPythonSdk(project) != null;
    }

    @NotNull
    public Function2<LessonContext, KLesson, Unit> getSdkConfigurationTasks() {
        return this.sdkConfigurationTasks;
    }

    private static final Unit installAndOpenLearningProject$lambda$0(Project $projectToClose, OpenProjectTaskBuilder $this$OpenProjectTask) {
        Intrinsics.checkNotNullParameter((Object)$this$OpenProjectTask, (String)"$this$OpenProjectTask");
        $this$OpenProjectTask.setProjectToClose($projectToClose);
        $this$OpenProjectTask.setProjectCreatedWithWizard(true);
        return Unit.INSTANCE;
    }

    private static final void getSdkForProject$lambda$1(PythonBasedLangSupport this$0, Project $project) {
        this$0.createAndSetVenvSdk($project);
    }

    private static final Unit createAndSetVenvSdk$lambda$2(PythonBasedLangSupport this$0, Project $project, Sdk $preferredSdk, List $existingSdks, Module $module) {
        Sdk venvSdk = this$0.applyBaseSdk($project, $preferredSdk, $existingSdks, $module);
        if (venvSdk != null) {
            this$0.applyProjectSdk(venvSdk, $project);
        }
        return Unit.INSTANCE;
    }

    private static final Unit startFromWelcomeFrame$lambda$5$lambda$4(List $baseSdks, PythonBasedLangSupport this$0, List $existingSdks, UserDataHolderBase $context, Function1 $startCallback) {
        if ($baseSdks.isEmpty()) {
            Sdk sdk2 = this$0.showSdkChoosingDialog($existingSdks, (UserDataHolder)$context);
            if (sdk2 != null) {
                $startCallback.invoke((Object)sdk2);
            }
        } else {
            $startCallback.invoke(null);
        }
        return Unit.INSTANCE;
    }

    private static final void startFromWelcomeFrame$lambda$5(List $existingSdks, PythonBasedLangSupport this$0, Function1 $startCallback) {
        UserDataHolderBase context = new UserDataHolderBase();
        List<Sdk> baseSdks = PySdkExtKt.findBaseSdks($existingSdks, null, (UserDataHolder)context);
        ActionsKt.invokeLater$default(null, () -> PythonBasedLangSupport.startFromWelcomeFrame$lambda$5$lambda$4(baseSdks, this$0, $existingSdks, context, $startCallback), (int)1, null);
    }

    private static final Unit showSdkChoosingDialog$lambda$6(PySdkPathChoosingComboBox $baseSdkField, JLabel $warningPlaceholder) {
        Sdk selectedSdk = $baseSdkField.getSelectedSdk();
        if (selectedSdk instanceof PySdkToInstall) {
            PySdkToInstall pySdkToInstall = (PySdkToInstall)selectedSdk;
            String string = Messages.getOkButton();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOkButton(...)");
            String installationWarning = pySdkToInstall.getInstallationWarning(string);
            $warningPlaceholder.setText("<html>" + installationWarning + "</html>");
        } else {
            $warningPlaceholder.setText("");
        }
        return Unit.INSTANCE;
    }

    private static final boolean sdkConfigurationTasks$lambda$13$lambda$12$lambda$7(PythonBasedLangSupport this$0, TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return this$0.isSdkConfigured($this$stateCheck.getProject());
    }

    private static final Unit sdkConfigurationTasks$lambda$13$lambda$12$lambda$8(TaskContext $this_task) {
        Module module = (Module)ArraysKt.singleOrNull((Object[])PyStatisticToolsKt.getModules($this_task.getProject()));
        if (module == null) {
            return Unit.INSTANCE;
        }
        Module module2 = module;
        PyInterpreterInspection.InterpreterSettingsQuickFix.showPythonInterpreterSettings($this_task.getProject(), module2);
        return Unit.INSTANCE;
    }

    private static final boolean sdkConfigurationTasks$lambda$13$lambda$12$lambda$9(PythonBasedLangSupport this$0, TaskRuntimeContext $this$showWarning) {
        Intrinsics.checkNotNullParameter((Object)$this$showWarning, (String)"$this$showWarning");
        return !this$0.isSdkConfigured($this$showWarning.getProject());
    }

    private static final Unit sdkConfigurationTasks$lambda$13$lambda$12$lambda$10(TaskContext $this_task, KLesson $lesson) {
        CourseManager.Companion.getInstance().openLesson($this_task.getProject(), (Lesson)$lesson, LessonStartingWay.NO_SDK_RESTART, true, true);
        return Unit.INSTANCE;
    }

    private static final boolean sdkConfigurationTasks$lambda$13$lambda$12$lambda$11(PythonBasedLangSupport this$0, TaskRuntimeContext $this$showWarning) {
        Intrinsics.checkNotNullParameter((Object)$this$showWarning, (String)"$this$showWarning");
        return !this$0.isSdkConfigured($this$showWarning.getProject());
    }

    private static final Unit sdkConfigurationTasks$lambda$13$lambda$12(PythonBasedLangSupport this$0, KLesson $lesson, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.stateCheck(arg_0 -> PythonBasedLangSupport.sdkConfigurationTasks$lambda$13$lambda$12$lambda$7(this$0, arg_0));
        String configureCallbackId = LearningUiManager.INSTANCE.addCallback(() -> PythonBasedLangSupport.sdkConfigurationTasks$lambda$13$lambda$12$lambda$8($this$task));
        if (this$0.getUseUserProjects() || UtilsKt.isLearningProject((Project)$this$task.getProject(), (String)this$0.getPrimaryLanguage())) {
            Object[] objectArray = new Object[]{configureCallbackId};
            TaskContext.showWarning$default((TaskContext)$this$task, (String)PythonLessonsBundle.INSTANCE.message("no.interpreter.in.learning.project", objectArray), (boolean)false, (LearningInternalProblems)LearningInternalProblems.NO_SDK_CONFIGURED, arg_0 -> PythonBasedLangSupport.sdkConfigurationTasks$lambda$13$lambda$12$lambda$9(this$0, arg_0), (int)2, null);
        } else {
            String openCallbackId = LearningUiManager.INSTANCE.addCallback(() -> PythonBasedLangSupport.sdkConfigurationTasks$lambda$13$lambda$12$lambda$10($this$task, $lesson));
            Object[] objectArray = new Object[]{openCallbackId, configureCallbackId};
            TaskContext.showWarning$default((TaskContext)$this$task, (String)PythonLessonsBundle.INSTANCE.message("no.interpreter.in.user.project", objectArray), (boolean)false, null, arg_0 -> PythonBasedLangSupport.sdkConfigurationTasks$lambda$13$lambda$12$lambda$11(this$0, arg_0), (int)6, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit sdkConfigurationTasks$lambda$13(PythonBasedLangSupport this$0, LessonContext lessonContext, KLesson lesson) {
        Intrinsics.checkNotNullParameter((Object)lessonContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        lessonContext.task(arg_0 -> PythonBasedLangSupport.sdkConfigurationTasks$lambda$13$lambda$12(this$0, lesson, arg_0));
        return Unit.INSTANCE;
    }
}

