/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.customElements.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.intellij.webSymbols.customElements.json.CustomElementsContribution;
import com.intellij.webSymbols.customElements.json.Deprecated;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"default", "deprecated", "description", "name", "summary", "syntax"})
public class CssCustomProperty
implements CustomElementsContribution {
    @JsonProperty(value="default")
    private String _default;
    @JsonProperty(value="deprecated")
    @JsonPropertyDescription(value="Whether the CSS custom property is deprecated.\nIf the value is a string, it's the reason for the deprecation.")
    private Deprecated deprecated;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="A markdown description.")
    private String description;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of the property, including leading `--`.")
    private String name;
    @JsonProperty(value="summary")
    @JsonPropertyDescription(value="A markdown summary suitable for display in a listing.")
    private String summary;
    @JsonProperty(value="syntax")
    @JsonPropertyDescription(value="The expected syntax of the defined property. Defaults to \"*\".\n\nThe syntax must be a valid CSS [syntax string](https://developer.mozilla.org/en-US/docs/Web/CSS/@property/syntax)\nas defined in the CSS Properties and Values API.\n\nExamples:\n\n\"<color>\": accepts a color\n\"<length> | <percentage>\": accepts lengths or percentages but not calc expressions with a combination of the two\n\"small | medium | large\": accepts one of these values set as custom idents.\n\"*\": any valid token")
    private String syntax;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="default")
    public String getDefault() {
        return this._default;
    }

    @JsonProperty(value="default")
    public void setDefault(String _default) {
        this._default = _default;
    }

    @Override
    @JsonProperty(value="deprecated")
    public Deprecated getDeprecated() {
        return this.deprecated;
    }

    @JsonProperty(value="deprecated")
    public void setDeprecated(Deprecated deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonProperty(value="summary")
    public String getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @JsonProperty(value="syntax")
    public String getSyntax() {
        return this.syntax;
    }

    @JsonProperty(value="syntax")
    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
}

