/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import kotlinx.serialization.protobuf.internal.ByteArrayOutput;
import kotlinx.serialization.protobuf.internal.BytesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000fJ\u0016\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nJ\u001e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0014J\u001e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0003J\u0016\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0018J\u0016\u0010\u0017\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0019\u001a\u00020\u0006*\u00020\u00032\u0006\u0010\u001a\u001a\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u001b\u001a\u00020\u0006*\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00142\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u001c\u001a\u00020\u0014*\u00020\rH\u0002J\f\u0010\u001c\u001a\u00020\n*\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkotlinx/serialization/protobuf/internal/ProtobufWriter;", "", "out", "Lkotlinx/serialization/protobuf/internal/ByteArrayOutput;", "(Lkotlinx/serialization/protobuf/internal/ByteArrayOutput;)V", "writeBytes", "", "bytes", "", "tag", "", "writeDouble", "value", "", "writeFloat", "", "writeInt", "format", "Lkotlinx/serialization/protobuf/ProtoIntegerType;", "writeLong", "", "writeOutput", "output", "writeString", "", "encode32", "number", "encode64", "reverseBytes", "kotlinx-serialization-protobuf"})
public final class ProtobufWriter {
    @NotNull
    private final ByteArrayOutput out;

    public ProtobufWriter(@NotNull ByteArrayOutput out) {
        Intrinsics.checkNotNullParameter(out, "out");
        this.out = out;
    }

    public final void writeBytes(@NotNull byte[] bytes, int tag) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        ProtobufWriter.encode32$default(this, this.out, tag << 3 | 2, null, 2, null);
        this.writeBytes(bytes);
    }

    public final void writeBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        ProtobufWriter.encode32$default(this, this.out, bytes.length, null, 2, null);
        this.out.write(bytes);
    }

    public final void writeOutput(@NotNull ByteArrayOutput output, int tag) {
        Intrinsics.checkNotNullParameter(output, "output");
        ProtobufWriter.encode32$default(this, this.out, tag << 3 | 2, null, 2, null);
        this.writeOutput(output);
    }

    public final void writeOutput(@NotNull ByteArrayOutput output) {
        Intrinsics.checkNotNullParameter(output, "output");
        ProtobufWriter.encode32$default(this, this.out, output.size(), null, 2, null);
        this.out.write(output);
    }

    public final void writeInt(int value, int tag, @NotNull ProtoIntegerType format) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        int wireType = format == ProtoIntegerType.FIXED ? 5 : 0;
        ProtobufWriter.encode32$default(this, this.out, tag << 3 | wireType, null, 2, null);
        this.encode32(this.out, value, format);
    }

    public final void writeInt(int value) {
        ProtobufWriter.encode32$default(this, this.out, value, null, 2, null);
    }

    public final void writeLong(long value, int tag, @NotNull ProtoIntegerType format) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        int wireType = format == ProtoIntegerType.FIXED ? 1 : 0;
        ProtobufWriter.encode32$default(this, this.out, tag << 3 | wireType, null, 2, null);
        this.encode64(this.out, value, format);
    }

    public final void writeLong(long value) {
        ProtobufWriter.encode64$default(this, this.out, value, null, 2, null);
    }

    public final void writeString(@NotNull String value, int tag) {
        Intrinsics.checkNotNullParameter(value, "value");
        byte[] bytes = StringsKt.encodeToByteArray(value);
        this.writeBytes(bytes, tag);
    }

    public final void writeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        byte[] bytes = StringsKt.encodeToByteArray(value);
        this.writeBytes(bytes);
    }

    public final void writeDouble(double value, int tag) {
        ProtobufWriter.encode32$default(this, this.out, tag << 3 | 1, null, 2, null);
        this.out.writeLong(this.reverseBytes(value));
    }

    public final void writeDouble(double value) {
        this.out.writeLong(this.reverseBytes(value));
    }

    public final void writeFloat(float value, int tag) {
        ProtobufWriter.encode32$default(this, this.out, tag << 3 | 5, null, 2, null);
        this.out.writeInt(this.reverseBytes(value));
    }

    public final void writeFloat(float value) {
        this.out.writeInt(this.reverseBytes(value));
    }

    private final void encode32(ByteArrayOutput $this$encode32, int number, ProtoIntegerType format) {
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                this.out.writeInt(BytesKt.reverseBytes(number));
                break;
            }
            case 2: {
                $this$encode32.encodeVarint64(number);
                break;
            }
            case 3: {
                $this$encode32.encodeVarint32(number << 1 ^ number >> 31);
            }
        }
    }

    static /* synthetic */ void encode32$default(ProtobufWriter protobufWriter, ByteArrayOutput byteArrayOutput, int n, ProtoIntegerType protoIntegerType, int n2, Object object) {
        if ((n2 & 2) != 0) {
            protoIntegerType = ProtoIntegerType.DEFAULT;
        }
        protobufWriter.encode32(byteArrayOutput, n, protoIntegerType);
    }

    private final void encode64(ByteArrayOutput $this$encode64, long number, ProtoIntegerType format) {
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                this.out.writeLong(BytesKt.reverseBytes(number));
                break;
            }
            case 2: {
                $this$encode64.encodeVarint64(number);
                break;
            }
            case 3: {
                $this$encode64.encodeVarint64(number << 1 ^ number >> 63);
            }
        }
    }

    static /* synthetic */ void encode64$default(ProtobufWriter protobufWriter, ByteArrayOutput byteArrayOutput, long l, ProtoIntegerType protoIntegerType, int n, Object object) {
        if ((n & 2) != 0) {
            protoIntegerType = ProtoIntegerType.DEFAULT;
        }
        protobufWriter.encode64(byteArrayOutput, l, protoIntegerType);
    }

    private final int reverseBytes(float $this$reverseBytes) {
        return BytesKt.reverseBytes(Float.floatToRawIntBits($this$reverseBytes));
    }

    private final long reverseBytes(double $this$reverseBytes) {
        return BytesKt.reverseBytes(Double.doubleToRawLongBits($this$reverseBytes));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoIntegerType.values().length];
            try {
                nArray[ProtoIntegerType.FIXED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoIntegerType.DEFAULT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoIntegerType.SIGNED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

