/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.experiment;

import com.intellij.completion.ml.experiment.ClientExperimentStatus;
import com.intellij.completion.ml.experiment.ExperimentConfig;
import com.intellij.completion.ml.experiment.ExperimentGroupConfig;
import com.intellij.completion.ml.experiment.ExperimentLanguageConfig;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ResourceUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"EXPERIMENT_DISABLED_PROPERTY_KEY", "", "EXPERIMENT_DISABLED_BY_EVALUATION_ENV", "loadExperimentInfo", "Lcom/intellij/completion/ml/experiment/ExperimentConfig;", "checkExperimentGroups", "", "experimentInfo", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nClientExperimentStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientExperimentStatus.kt\ncom/intellij/completion/ml/experiment/ClientExperimentStatusKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n14#2:130\n1#3:131\n1734#4,2:132\n1755#4,3:134\n1736#4:137\n*S KotlinDebug\n*F\n+ 1 ClientExperimentStatus.kt\ncom/intellij/completion/ml/experiment/ClientExperimentStatusKt\n*L\n33#1:130\n46#1:132,2\n47#1:134,3\n46#1:137\n*E\n"})
public final class ClientExperimentStatusKt {
    @NotNull
    private static final String EXPERIMENT_DISABLED_PROPERTY_KEY = "ml.completion.experiment.disabled";
    @NotNull
    private static final String EXPERIMENT_DISABLED_BY_EVALUATION_ENV = "EVALUATION_ML_EXPERIMENT_DISABLED";

    @ApiStatus.Internal
    @NotNull
    public static final ExperimentConfig loadExperimentInfo() {
        try {
            if (!ApplicationManager.getApplication().isEAP()) {
                return ExperimentConfig.Companion.disabledExperiment();
            }
            byte[] byArray = ResourceUtil.getResourceAsBytes((String)"experiment.json", (ClassLoader)ClientExperimentStatus.class.getClassLoader());
            Intrinsics.checkNotNull((Object)byArray);
            byte[] data = byArray;
            ExperimentConfig experimentInfo = (ExperimentConfig)Json.Default.decodeFromString((DeserializationStrategy)ExperimentConfig.Companion.serializer(), new String(data, Charsets.UTF_8));
            ClientExperimentStatusKt.checkExperimentGroups(experimentInfo);
            return experimentInfo;
        }
        catch (Throwable e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ClientExperimentStatus.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Error on loading ML Completion experiment info", e);
            return ExperimentConfig.Companion.disabledExperiment();
        }
    }

    private static final void checkExperimentGroups(ExperimentConfig experimentInfo) {
        boolean bl;
        for (ExperimentGroupConfig group : experimentInfo.getGroups()) {
            if (group.getShowArrows()) {
                bl = group.getUseMLRanking();
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-ClientExperimentStatusKt$checkExperimentGroups$42 = false;
                    String $i$a$-assert-ClientExperimentStatusKt$checkExperimentGroups$42 = "Showing arrows requires ML ranking";
                    throw new AssertionError((Object)$i$a$-assert-ClientExperimentStatusKt$checkExperimentGroups$42);
                }
            }
            if (!group.getUseMLRanking()) continue;
            bl = group.getCalculateFeatures();
            if (!_Assertions.ENABLED || bl) continue;
            boolean $i$a$-assert-ClientExperimentStatusKt$checkExperimentGroups$62 = false;
            String $i$a$-assert-ClientExperimentStatusKt$checkExperimentGroups$62 = "ML ranking requires calculating features";
            throw new AssertionError((Object)$i$a$-assert-ClientExperimentStatusKt$checkExperimentGroups$62);
        }
        for (ExperimentLanguageConfig language : experimentInfo.getLanguages()) {
            block12: {
                boolean bl2 = bl = language.getIncludeGroups().size() <= language.getExperimentBucketsCount();
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-ClientExperimentStatusKt$checkExperimentGroups$72 = false;
                    String $i$a$-assert-ClientExperimentStatusKt$checkExperimentGroups$72 = "Groups count must be less than the total number of buckets (" + language.getId() + ")";
                    throw new AssertionError((Object)$i$a$-assert-ClientExperimentStatusKt$checkExperimentGroups$72);
                }
                Iterable $this$all$iv = language.getIncludeGroups();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v1 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        boolean bl3;
                        int number;
                        block11: {
                            number = ((Number)element$iv).intValue();
                            boolean bl4 = false;
                            Iterable $this$any$iv = experimentInfo.getGroups();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl3 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv) {
                                    ExperimentGroupConfig it = (ExperimentGroupConfig)element$iv2;
                                    boolean bl5 = false;
                                    if (!(it.getNumber() == number)) continue;
                                    bl3 = true;
                                    break block11;
                                }
                                bl3 = false;
                            }
                        }
                        if (bl3 || experimentInfo.getVersion() == number) continue;
                        v1 = false;
                        break block12;
                    }
                    v1 = bl = true;
                }
            }
            if (!_Assertions.ENABLED || bl) continue;
            boolean bl6 = false;
            String string = "Group included for language (" + language.getId() + ") should be among general list of groups or equal to NoExperiment group number";
            throw new AssertionError((Object)string);
        }
    }
}

