/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.ssh.config.SshIdeGlobalProxyGetter;
import com.intellij.ssh.config.SshProxyConfig;
import com.intellij.util.net.HttpConfigurable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ssh/config/HttpConfigurableSshProxyGetter;", "Lcom/intellij/ssh/config/SshIdeGlobalProxyGetter;", "<init>", "()V", "getIdeWideProxy", "Lcom/intellij/ssh/config/SshProxyConfig;", "host", "", "port", "", "intellij.platform.ssh.ui"})
public final class HttpConfigurableSshProxyGetter
implements SshIdeGlobalProxyGetter {
    @Override
    @Nullable
    public SshProxyConfig getIdeWideProxy(@NotNull String host, int port) {
        SshProxyConfig sshProxyConfig;
        Credentials credentials;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        HttpConfigurable config = HttpConfigurable.getInstance();
        if (!config.USE_HTTP_PROXY) {
            return null;
        }
        Credentials credentials2 = credentials = config.PROXY_AUTHENTICATION ? new Credentials(config.getProxyLogin(), config.getPlainProxyPassword()) : null;
        if (config.PROXY_TYPE_IS_SOCKS) {
            String string = config.PROXY_HOST;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PROXY_HOST");
            sshProxyConfig = new SshProxyConfig.SOCKS(string, config.PROXY_PORT, credentials);
        } else {
            String string = config.PROXY_HOST;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PROXY_HOST");
            sshProxyConfig = new SshProxyConfig.HTTP(string, config.PROXY_PORT, credentials);
        }
        return sshProxyConfig;
    }
}

