/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.community.ide.impl.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pycharm.community.ide.impl.PyCharmCommunityCustomizationBundle;
import com.intellij.pycharm.community.ide.impl.configuration.PySdkConfigurationCollector;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.VirtualEnvReader;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfigurationExtension;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import com.jetbrains.python.sdk.pipenv.PyAddNewPipEnvFromFilePanel;
import com.jetbrains.python.sdk.pipenv.PyPipEnvSdkAdditionalData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0017\u0010\u000b\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/pycharm/community/ide/impl/configuration/PyPipfileSdkConfiguration;", "Lcom/jetbrains/python/sdk/configuration/PyProjectSdkConfigurationExtension;", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createAndAddSdkForConfigurator", "Lcom/intellij/openapi/projectRoots/Sdk;", "module", "Lcom/intellij/openapi/module/Module;", "getIntention", "", "Lcom/intellij/codeInspection/util/IntentionName;", "createAndAddSdkForInspection", "createAndAddSDk", "source", "Lcom/intellij/pycharm/community/ide/impl/configuration/PySdkConfigurationCollector$Source;", "askForEnvData", "Lcom/jetbrains/python/sdk/pipenv/PyAddNewPipEnvFromFilePanel$Data;", "createPipEnv", "Dialog", "intellij.pycharm.community.ide.impl"})
@SourceDebugExtension(value={"SMAP\nPyPipfileSdkConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPipfileSdkConfiguration.kt\ncom/intellij/pycharm/community/ide/impl/configuration/PyPipfileSdkConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1#2:162\n*E\n"})
public final class PyPipfileSdkConfiguration
implements PyProjectSdkConfigurationExtension {
    @NotNull
    private final Logger LOGGER;

    public PyPipfileSdkConfiguration() {
        Logger logger = Logger.getInstance(PyPipfileSdkConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOGGER = logger;
    }

    @Nullable
    public Sdk createAndAddSdkForConfigurator(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.createAndAddSDk(module, PySdkConfigurationCollector.Source.CONFIGURATOR);
    }

    @Nullable
    public String getIntention(@NotNull Module module) {
        String string;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        VirtualFile virtualFile = PipenvKt.getPipFile((Module)module);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getName()};
            string = PyCharmCommunityCustomizationBundle.message("sdk.create.pipenv.suggestion", objectArray);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public Sdk createAndAddSdkForInspection(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.createAndAddSDk(module, PySdkConfigurationCollector.Source.INSPECTION);
    }

    private final Sdk createAndAddSDk(Module module, PySdkConfigurationCollector.Source source) {
        PyAddNewPipEnvFromFilePanel.Data data = this.askForEnvData(module, source);
        if (data == null) {
            return null;
        }
        PyAddNewPipEnvFromFilePanel.Data pipEnvExecutable = data;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance(...)");
        PipenvKt.setPipEnvPath((PropertiesComponent)propertiesComponent, (String)pipEnvExecutable.getPipEnvPath());
        return this.createPipEnv(module);
    }

    private final PyAddNewPipEnvFromFilePanel.Data askForEnvData(Module module, PySdkConfigurationCollector.Source source) {
        String pipEnvExecutable;
        File file = PipenvKt.getPipEnvExecutable();
        String string = pipEnvExecutable = file != null ? file.getAbsolutePath() : null;
        if (source == PySdkConfigurationCollector.Source.INSPECTION) {
            boolean bl;
            String string2 = pipEnvExecutable;
            if (string2 != null) {
                String it = string2;
                boolean bl2 = false;
                Path path = Path.of(it, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                bl = Files.isExecutable(path);
            } else {
                bl = false;
            }
            if (bl) {
                return new PyAddNewPipEnvFromFilePanel.Data(pipEnvExecutable);
            }
        }
        Ref.BooleanRef permitted = new Ref.BooleanRef();
        Ref.ObjectRef envData = new Ref.ObjectRef();
        ApplicationManager.getApplication().invokeAndWait(() -> PyPipfileSdkConfiguration.askForEnvData$lambda$2(module, permitted, envData, this));
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CharSequence charSequence = pipEnvExecutable;
        PySdkConfigurationCollector.INSTANCE.logPipEnvDialog$intellij_pycharm_community_ide_impl(project, permitted.element, source, charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? PySdkConfigurationCollector.InputData.NOT_FILLED : PySdkConfigurationCollector.InputData.SPECIFIED);
        return permitted.element ? (PyAddNewPipEnvFromFilePanel.Data)envData.element : null;
    }

    private final Sdk createPipEnv(Module module) {
        VirtualFile virtualFile;
        Path path;
        String string;
        ProgressManager.progress((String)PyBundle.message((String)"python.sdk.setting.up.pipenv.sentence", (Object[])new Object[0]));
        this.LOGGER.debug("Creating pipenv environment");
        String string2 = BasePySdkExtKt.getBasePath((Module)module);
        if (string2 == null) {
            return null;
        }
        String basePath = string2;
        try {
            String string3 = FileUtil.toSystemDependentName((String)basePath);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemDependentName(...)");
            string = PipenvKt.setupPipEnv((String)string3, null, (boolean)true);
        }
        catch (ExecutionException e) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PySdkConfigurationCollector.INSTANCE.logPipEnv$intellij_pycharm_community_ide_impl(project, PySdkConfigurationCollector.PipEnvResult.CREATION_FAILURE);
            this.LOGGER.warn("Exception during creating pipenv environment", (Throwable)e);
            String string4 = PyCharmCommunityCustomizationBundle.message("sdk.create.pipenv.exception.dialog.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            PySdkExtKt.showSdkExecutionException(null, (ExecutionException)e, (String)string4);
            return null;
        }
        String pipEnv = string;
        VirtualEnvReader virtualEnvReader = VirtualEnvReader.Companion.getInstance();
        Path path2 = Path.of(pipEnv, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        Path it = path = virtualEnvReader.findPythonInPythonRoot(path2);
        boolean bl = false;
        if (it == null) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PySdkConfigurationCollector.INSTANCE.logPipEnv$intellij_pycharm_community_ide_impl(project, PySdkConfigurationCollector.PipEnvResult.NO_EXECUTABLE);
            this.LOGGER.warn("Python executable is not found: " + pipEnv);
        }
        Path path3 = path;
        if (path3 == null) {
            return null;
        }
        Path path4 = path3;
        VirtualFile it2 = virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(((Object)path4).toString());
        boolean bl2 = false;
        if (it2 == null) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PySdkConfigurationCollector.INSTANCE.logPipEnv$intellij_pycharm_community_ide_impl(project, PySdkConfigurationCollector.PipEnvResult.NO_EXECUTABLE_FILE);
            this.LOGGER.warn("Python executable file is not found: " + path4);
        }
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file = virtualFile2;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PySdkConfigurationCollector.INSTANCE.logPipEnv$intellij_pycharm_community_ide_impl(project, PySdkConfigurationCollector.PipEnvResult.CREATED);
        this.LOGGER.debug("Setting up associated pipenv environment: " + path4 + ", " + basePath);
        Sdk sdk2 = SdkConfigurationUtil.setupSdk((Sdk[])ProjectJdkTable.getInstance().getAllJdks(), (VirtualFile)file, (SdkType)((SdkType)PythonSdkType.getInstance()), (SdkAdditionalData)((SdkAdditionalData)new PyPipEnvSdkAdditionalData()), (String)PipenvKt.suggestedSdkName((String)basePath));
        Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"setupSdk(...)");
        Sdk sdk3 = sdk2;
        ApplicationManager.getApplication().invokeAndWait(() -> PyPipfileSdkConfiguration.createPipEnv$lambda$5(this, path4, basePath, sdk3, module));
        return sdk3;
    }

    private static final void askForEnvData$lambda$2(Module $module, Ref.BooleanRef $permitted, Ref.ObjectRef $envData, PyPipfileSdkConfiguration this$0) {
        Dialog dialog = new Dialog($module);
        $permitted.element = dialog.showAndGet();
        $envData.element = dialog.getEnvData();
        this$0.LOGGER.debug("Dialog exit code: " + dialog.getExitCode() + ", " + $permitted.element);
    }

    private static final void createPipEnv$lambda$5(PyPipfileSdkConfiguration this$0, Path $path, String $basePath, Sdk $sdk, Module $module) {
        this$0.LOGGER.debug("Adding associated pipenv environment: " + $path + ", " + $basePath);
        PySdkExtKt.setAssociationToModule((Sdk)$sdk, (Module)$module);
        SdkConfigurationUtil.addSdk((Sdk)$sdk);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/pycharm/community/ide/impl/configuration/PyPipfileSdkConfiguration$Dialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "panel", "Lcom/jetbrains/python/sdk/pipenv/PyAddNewPipEnvFromFilePanel;", "envData", "Lcom/jetbrains/python/sdk/pipenv/PyAddNewPipEnvFromFilePanel$Data;", "getEnvData", "()Lcom/jetbrains/python/sdk/pipenv/PyAddNewPipEnvFromFilePanel$Data;", "createCenterPanel", "Ljavax/swing/JComponent;", "postponeValidation", "", "doValidateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.pycharm.community.ide.impl"})
    private static final class Dialog
    extends DialogWrapper {
        @NotNull
        private final PyAddNewPipEnvFromFilePanel panel;

        public Dialog(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            super(module.getProject(), false, DialogWrapper.IdeModalityType.PROJECT);
            this.panel = new PyAddNewPipEnvFromFilePanel(module);
            this.setTitle(PyBundle.message((String)"python.sdk.setting.up.pipenv.title", (Object[])new Object[0]));
            this.init();
        }

        @NotNull
        public final PyAddNewPipEnvFromFilePanel.Data getEnvData() {
            return this.panel.getEnvData();
        }

        @NotNull
        protected JComponent createCenterPanel() {
            JPanel jPanel;
            JPanel $this$createCenterPanel_u24lambda_u240 = jPanel = new JPanel(new BorderLayout());
            boolean bl = false;
            Border border = IdeBorderFactory.createEmptyBorder((Insets)new Insets(4, 0, 6, 0));
            String string = PyCharmCommunityCustomizationBundle.message("sdk.create.pipenv.permission", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            $this$createCenterPanel_u24lambda_u240.add((Component)JBUI.Panels.simplePanel((Component)((Component)new JBLabel(message))).withBorder(border), "North");
            $this$createCenterPanel_u24lambda_u240.add((Component)this.panel, "Center");
            return jPanel;
        }

        protected boolean postponeValidation() {
            return false;
        }

        @NotNull
        protected List<ValidationInfo> doValidateAll() {
            return this.panel.validateAll();
        }
    }
}

