/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateAutoClosingPair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;

public final class PreferencesRegistryImpl
implements PreferencesRegistry {
    @NotNull
    private final Set<Preferences> myPreferences = new HashSet<Preferences>();
    @NotNull
    private final IntSet myLeftHighlightingBraces = new IntOpenHashSet();
    @NotNull
    private final IntSet myRightHighlightingBraces = new IntOpenHashSet();
    @NotNull
    private final IntSet myLeftSmartTypingBraces = new IntOpenHashSet();
    @NotNull
    private final IntSet myRightSmartTypingBraces = new IntOpenHashSet();

    public PreferencesRegistryImpl() {
        this.fillHighlightingBraces(Constants.DEFAULT_HIGHLIGHTING_BRACE_PAIRS);
        this.fillSmartTypingBraces(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
    }

    public synchronized void addPreferences(Preferences preferences) {
        this.fillHighlightingBraces(preferences.getHighlightingPairs());
        this.fillSmartTypingBraces(preferences.getSmartTypingPairs());
        this.myPreferences.add(preferences);
    }

    private synchronized void fillHighlightingBraces(Collection<TextMateBracePair> highlightingPairs) {
        if (highlightingPairs != null) {
            for (TextMateBracePair pair : highlightingPairs) {
                if (!pair.getLeft().isEmpty()) {
                    this.myLeftHighlightingBraces.add((int)pair.getLeft().charAt(0));
                }
                if (pair.getRight().isEmpty()) continue;
                this.myRightHighlightingBraces.add((int)pair.getRight().charAt(pair.getRight().length() - 1));
            }
        }
    }

    private void fillSmartTypingBraces(Collection<TextMateAutoClosingPair> smartTypingPairs) {
        if (smartTypingPairs != null) {
            for (TextMateAutoClosingPair pair : smartTypingPairs) {
                if (!pair.getLeft().isEmpty()) {
                    this.myLeftSmartTypingBraces.add((int)pair.getLeft().charAt(pair.getLeft().length() - 1));
                }
                if (pair.getRight().isEmpty()) continue;
                this.myRightSmartTypingBraces.add((int)pair.getRight().charAt(pair.getRight().length() - 1));
            }
        }
    }

    @Override
    public synchronized boolean isPossibleLeftHighlightingBrace(char firstLeftBraceChar) {
        return this.myLeftHighlightingBraces.contains((int)firstLeftBraceChar) || firstLeftBraceChar != ' ' && this.myLeftSmartTypingBraces.contains((int)firstLeftBraceChar);
    }

    @Override
    public synchronized boolean isPossibleRightHighlightingBrace(char lastRightBraceChar) {
        return this.myRightHighlightingBraces.contains((int)lastRightBraceChar) || lastRightBraceChar != ' ' && this.myRightSmartTypingBraces.contains((int)lastRightBraceChar);
    }

    @Override
    public synchronized boolean isPossibleLeftSmartTypingBrace(char lastLeftBraceChar) {
        return this.myLeftSmartTypingBraces.contains((int)lastLeftBraceChar);
    }

    @Override
    public synchronized boolean isPossibleRightSmartTypingBrace(char lastRightBraceChar) {
        return this.myRightSmartTypingBraces.contains((int)lastRightBraceChar);
    }

    @Override
    @NotNull
    public synchronized List<Preferences> getPreferences(@NotNull TextMateScope scope) {
        if (scope == null) {
            PreferencesRegistryImpl.$$$reportNull$$$0(0);
        }
        List<Preferences> list = new TextMateScopeComparator<Preferences>(scope, Preferences::getScopeSelector).sortAndFilter(this.myPreferences);
        if (list == null) {
            PreferencesRegistryImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    public synchronized void clear() {
        this.myPreferences.clear();
        this.myLeftHighlightingBraces.clear();
        this.myRightHighlightingBraces.clear();
        this.fillHighlightingBraces(Constants.DEFAULT_HIGHLIGHTING_BRACE_PAIRS);
        this.myLeftSmartTypingBraces.clear();
        this.myRightSmartTypingBraces.clear();
        this.fillSmartTypingBraces(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/preferences/PreferencesRegistryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/preferences/PreferencesRegistryImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPreferences";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

