/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_EXTERNAL_MEMORY_BUFFER_DESC
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int SIZE;
    public static final int FLAGS;
    public static final int RESERVED;

    public CUDA_EXTERNAL_MEMORY_BUFFER_DESC(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_EXTERNAL_MEMORY_BUFFER_DESC.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned long long")
    public long offset() {
        return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.noffset(this.address());
    }

    @NativeType(value="unsigned long long")
    public long size() {
        return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nsize(this.address());
    }

    @NativeType(value="unsigned int")
    public int flags() {
        return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nflags(this.address());
    }

    @NativeType(value="unsigned int[16]")
    public IntBuffer reserved() {
        return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nreserved(this.address());
    }

    @NativeType(value="unsigned int")
    public int reserved(int index) {
        return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nreserved(this.address(), index);
    }

    public CUDA_EXTERNAL_MEMORY_BUFFER_DESC offset(@NativeType(value="unsigned long long") long value) {
        CUDA_EXTERNAL_MEMORY_BUFFER_DESC.noffset(this.address(), value);
        return this;
    }

    public CUDA_EXTERNAL_MEMORY_BUFFER_DESC size(@NativeType(value="unsigned long long") long value) {
        CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nsize(this.address(), value);
        return this;
    }

    public CUDA_EXTERNAL_MEMORY_BUFFER_DESC flags(@NativeType(value="unsigned int") int value) {
        CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nflags(this.address(), value);
        return this;
    }

    public CUDA_EXTERNAL_MEMORY_BUFFER_DESC reserved(@NativeType(value="unsigned int[16]") IntBuffer value) {
        CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nreserved(this.address(), value);
        return this;
    }

    public CUDA_EXTERNAL_MEMORY_BUFFER_DESC reserved(int index, @NativeType(value="unsigned int") int value) {
        CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nreserved(this.address(), index, value);
        return this;
    }

    public CUDA_EXTERNAL_MEMORY_BUFFER_DESC set(long offset, long size, int flags, IntBuffer reserved) {
        this.offset(offset);
        this.size(size);
        this.flags(flags);
        this.reserved(reserved);
        return this;
    }

    public CUDA_EXTERNAL_MEMORY_BUFFER_DESC set(CUDA_EXTERNAL_MEMORY_BUFFER_DESC src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_EXTERNAL_MEMORY_BUFFER_DESC malloc() {
        return (CUDA_EXTERNAL_MEMORY_BUFFER_DESC)CUDA_EXTERNAL_MEMORY_BUFFER_DESC.wrap(CUDA_EXTERNAL_MEMORY_BUFFER_DESC.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CUDA_EXTERNAL_MEMORY_BUFFER_DESC calloc() {
        return (CUDA_EXTERNAL_MEMORY_BUFFER_DESC)CUDA_EXTERNAL_MEMORY_BUFFER_DESC.wrap(CUDA_EXTERNAL_MEMORY_BUFFER_DESC.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CUDA_EXTERNAL_MEMORY_BUFFER_DESC create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CUDA_EXTERNAL_MEMORY_BUFFER_DESC)CUDA_EXTERNAL_MEMORY_BUFFER_DESC.wrap(CUDA_EXTERNAL_MEMORY_BUFFER_DESC.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CUDA_EXTERNAL_MEMORY_BUFFER_DESC create(long address) {
        return (CUDA_EXTERNAL_MEMORY_BUFFER_DESC)CUDA_EXTERNAL_MEMORY_BUFFER_DESC.wrap(CUDA_EXTERNAL_MEMORY_BUFFER_DESC.class, (long)address);
    }

    @Nullable
    public static CUDA_EXTERNAL_MEMORY_BUFFER_DESC createSafe(long address) {
        return address == 0L ? null : (CUDA_EXTERNAL_MEMORY_BUFFER_DESC)CUDA_EXTERNAL_MEMORY_BUFFER_DESC.wrap(CUDA_EXTERNAL_MEMORY_BUFFER_DESC.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CUDA_EXTERNAL_MEMORY_BUFFER_DESC.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CUDA_EXTERNAL_MEMORY_BUFFER_DESC.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CUDA_EXTERNAL_MEMORY_BUFFER_DESC.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_EXTERNAL_MEMORY_BUFFER_DESC.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CUDA_EXTERNAL_MEMORY_BUFFER_DESC.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CUDA_EXTERNAL_MEMORY_BUFFER_DESC.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CUDA_EXTERNAL_MEMORY_BUFFER_DESC.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static CUDA_EXTERNAL_MEMORY_BUFFER_DESC mallocStack() {
        return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_EXTERNAL_MEMORY_BUFFER_DESC callocStack() {
        return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_EXTERNAL_MEMORY_BUFFER_DESC mallocStack(MemoryStack stack) {
        return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.malloc(stack);
    }

    @Deprecated
    public static CUDA_EXTERNAL_MEMORY_BUFFER_DESC callocStack(MemoryStack stack) {
        return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.calloc(capacity, stack);
    }

    public static CUDA_EXTERNAL_MEMORY_BUFFER_DESC malloc(MemoryStack stack) {
        return (CUDA_EXTERNAL_MEMORY_BUFFER_DESC)CUDA_EXTERNAL_MEMORY_BUFFER_DESC.wrap(CUDA_EXTERNAL_MEMORY_BUFFER_DESC.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUDA_EXTERNAL_MEMORY_BUFFER_DESC calloc(MemoryStack stack) {
        return (CUDA_EXTERNAL_MEMORY_BUFFER_DESC)CUDA_EXTERNAL_MEMORY_BUFFER_DESC.wrap(CUDA_EXTERNAL_MEMORY_BUFFER_DESC.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CUDA_EXTERNAL_MEMORY_BUFFER_DESC.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CUDA_EXTERNAL_MEMORY_BUFFER_DESC.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long noffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static IntBuffer nreserved(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)RESERVED), (int)16);
    }

    public static int nreserved(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)RESERVED + Checks.check((int)index, (int)16) * 4L);
    }

    public static void noffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nreserved(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)16);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)RESERVED), (long)(value.remaining() * 4));
    }

    public static void nreserved(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)RESERVED + Checks.check((int)index, (int)16) * 4L, value);
    }

    static {
        Struct.Layout layout = CUDA_EXTERNAL_MEMORY_BUFFER_DESC.__struct((Struct.Member[])new Struct.Member[]{CUDA_EXTERNAL_MEMORY_BUFFER_DESC.__member((int)8), CUDA_EXTERNAL_MEMORY_BUFFER_DESC.__member((int)8), CUDA_EXTERNAL_MEMORY_BUFFER_DESC.__member((int)4), CUDA_EXTERNAL_MEMORY_BUFFER_DESC.__array((int)4, (int)16)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        RESERVED = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<CUDA_EXTERNAL_MEMORY_BUFFER_DESC, Buffer>
    implements NativeResource {
        private static final CUDA_EXTERNAL_MEMORY_BUFFER_DESC ELEMENT_FACTORY = CUDA_EXTERNAL_MEMORY_BUFFER_DESC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUDA_EXTERNAL_MEMORY_BUFFER_DESC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned long long")
        public long offset() {
            return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.noffset(this.address());
        }

        @NativeType(value="unsigned long long")
        public long size() {
            return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nsize(this.address());
        }

        @NativeType(value="unsigned int")
        public int flags() {
            return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nflags(this.address());
        }

        @NativeType(value="unsigned int[16]")
        public IntBuffer reserved() {
            return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nreserved(this.address());
        }

        @NativeType(value="unsigned int")
        public int reserved(int index) {
            return CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nreserved(this.address(), index);
        }

        public Buffer offset(@NativeType(value="unsigned long long") long value) {
            CUDA_EXTERNAL_MEMORY_BUFFER_DESC.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="unsigned long long") long value) {
            CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nsize(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="unsigned int") int value) {
            CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nflags(this.address(), value);
            return this;
        }

        public Buffer reserved(@NativeType(value="unsigned int[16]") IntBuffer value) {
            CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned int") int value) {
            CUDA_EXTERNAL_MEMORY_BUFFER_DESC.nreserved(this.address(), index, value);
            return this;
        }
    }
}

