/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.query;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.api.query.Query;
import org.keycloak.marshalling.Marshalling;
import org.keycloak.models.sessions.infinispan.entities.RemoteUserSessionEntity;

public final class UserSessionQueries {
    public static final String USER_SESSION = Marshalling.protoEntity(RemoteUserSessionEntity.class);
    private static final String BASE_QUERY = "FROM %s as e ".formatted(USER_SESSION);
    private static final String BY_BROKER_SESSION_ID = BASE_QUERY + "WHERE e.realmId = :realmId && e.brokerSessionId = :brokerSessionId ORDER BY e.userSessionId";
    private static final String BY_USER_ID = BASE_QUERY + "WHERE e.realmId = :realmId && e.userId = :userId ORDER BY e.userSessionId";
    private static final String BY_BROKER_USER_ID = BASE_QUERY + "WHERE e.realmId = :realmId && e.brokerUserId = :brokerUserId ORDER BY e.userSessionId";

    private UserSessionQueries() {
    }

    public static Query<RemoteUserSessionEntity> searchByBrokerSessionId(RemoteCache<String, RemoteUserSessionEntity> cache, String realmId, String brokerSessionId) {
        return cache.query(BY_BROKER_SESSION_ID).setParameter("realmId", (Object)realmId).setParameter("brokerSessionId", (Object)brokerSessionId);
    }

    public static Query<RemoteUserSessionEntity> searchByUserId(RemoteCache<String, RemoteUserSessionEntity> cache, String realmId, String userId) {
        return cache.query(BY_USER_ID).setParameter("realmId", (Object)realmId).setParameter("userId", (Object)userId);
    }

    public static Query<RemoteUserSessionEntity> searchByBrokerUserId(RemoteCache<String, RemoteUserSessionEntity> cache, String realmId, String brokerUserId) {
        return cache.query(BY_BROKER_USER_ID).setParameter("realmId", (Object)realmId).setParameter("brokerUserId", (Object)brokerUserId);
    }
}

