/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

public class HashCode {
    private static final int MULTIPLIER_VALUE = 37;

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int hashcode = 17;

        private void applyHash() {
            this.applyHash(0);
        }

        private void applyHash(int hash) {
            this.hashcode = 37 * this.hashcode + hash;
        }

        public Builder append(Object object) {
            if (object == null) {
                this.applyHash();
                return this;
            }
            if (object.getClass().isArray()) {
                if (object instanceof int[]) {
                    this.append((Object)((int[])object));
                } else if (object instanceof long[]) {
                    this.append((long[])object);
                } else if (object instanceof boolean[]) {
                    this.append((boolean[])object);
                } else if (object instanceof double[]) {
                    this.append((double[])object);
                } else if (object instanceof float[]) {
                    this.append((float[])object);
                } else if (object instanceof short[]) {
                    this.append((Object)((short[])object));
                } else if (object instanceof char[]) {
                    this.append((char[])object);
                } else if (object instanceof byte[]) {
                    this.append((byte[])object);
                } else {
                    this.append((Object[])object);
                }
            }
            this.applyHash(object.hashCode());
            return this;
        }

        public Builder append(boolean value2) {
            this.applyHash(value2 ? 0 : 1);
            return this;
        }

        public Builder append(boolean[] array) {
            if (array == null) {
                this.applyHash();
                return this;
            }
            for (boolean bool : array) {
                this.append(bool);
            }
            return this;
        }

        public Builder append(byte value2) {
            this.applyHash(value2);
            return this;
        }

        public Builder append(byte[] array) {
            if (array == null) {
                this.applyHash();
                return this;
            }
            for (byte b : array) {
                this.append(b);
            }
            return this;
        }

        public Builder append(char value2) {
            this.applyHash(value2);
            return this;
        }

        public Builder append(char[] array) {
            if (array == null) {
                this.applyHash();
                return this;
            }
            for (char c : array) {
                this.append(c);
            }
            return this;
        }

        public Builder append(double value2) {
            return this.append(Double.doubleToLongBits(value2));
        }

        public Builder append(double[] array) {
            if (array == null) {
                this.applyHash();
                return this;
            }
            for (double d : array) {
                this.append(d);
            }
            return this;
        }

        public Builder append(float value2) {
            return this.append(Float.floatToIntBits(value2));
        }

        public Builder append(float[] array) {
            if (array == null) {
                this.applyHash();
                return this;
            }
            for (float f : array) {
                this.append(f);
            }
            return this;
        }

        public Builder append(long value2) {
            this.applyHash((int)(value2 ^ value2 >>> 32));
            return this;
        }

        public Builder append(long[] array) {
            if (array == null) {
                this.applyHash();
                return this;
            }
            for (long l : array) {
                this.append(l);
            }
            return this;
        }

        public Builder append(Object[] array) {
            if (array == null) {
                this.applyHash();
                return this;
            }
            for (Object element : array) {
                this.append(element);
            }
            return this;
        }

        public int build() {
            return this.hashcode;
        }
    }

    @FunctionalInterface
    public static interface Calculator {
        public void calculateHash(Builder var1);
    }

    public static class Cache {
        private boolean calculated;
        private int hashcode;

        public int getHashCode(Calculator hashCodeCalculator) {
            if (this.calculated) {
                return this.hashcode;
            }
            Builder hashCodeBuilder = new Builder();
            hashCodeCalculator.calculateHash(hashCodeBuilder);
            this.calculated = true;
            this.hashcode = hashCodeBuilder.hashcode;
            return this.hashcode;
        }
    }
}

