'\"
'\" Copyright (c) 1996 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) scrolledhtml.n 1.21 94/12/17 16:04:44
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" @(#) man.macros 1.1 94/08/09 13:07:19
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tk    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'iwid'      .TH "\\$1" 1 "\\*(^3"  Tk    "[incr Widgets]"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.TH iwidgets::scrolledhtml iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
iwidgets::scrolledhtml \- Create and manipulate a scrolled text widget with the capability
of displaying HTML formatted documents.
.SH SYNOPSIS
\fBiwidgets::scrolledhtml\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- iwidgets::Labeledwidget <- iwidgets::Scrolledtext <- iwidgets::Scrolledhtml
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fB
activeBackground  background         borderWidth       cursor
exportSelection   foreground         highlightColor    highlightThickness
insertBackground  insertBorderWidth  insertOffTime     insertOnTime
insertWidth       padX               padY              relief
repeatDelay       repeatInterval     selectBackground  selectBorderWidth
selectForeground  setGrid\fR 
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBactiveRelief\fR	\fBelementBorderWidth\fR	\fBjump\fR	\fBtroughColor\fR
.fi
.LP
See the "scrollbar" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBspacing1\fR	\fBspacing2\fR	\fBspacing3\fR	\fBstate\fR
\fBtabs\fR	\fBwrap\fR
.fi
.LP
See the "text" widget manual entry for details on the above
associated options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBlabelBitmap\fR	\fBlabelFont\fR	\fBlabelImage\fR	\fBlabelMargin\fR
\fBlabelPos\fR	\fBlabelText\fR	\fBlabelVariable\fR 		\fBheight\fR
\fBhscrollMode\fR	\fBsbWidth\fR	\fBscrollMargin\fR	\fBvisibleitems\fR
\fBvscrollMode\fR	\fBwidth\fR
.fi
.LP
See the "scrolledtext" class manual entry for details on the inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBsticky\fR
.fi
.LP
See the "labeledwidget" class manual entry for details on the inherited options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBfeedback\fR
Class:	\fBFeedBack\fR
Command-Line Switch:	\fB-feedback\fR
.fi
.IP
Specifies the callback command to use to give feedback on current
status. The command is executed in the form \fIcommand\fR \fI<number of 
characters remaining>\fR
.LP
.nf
Name:	\fBfixedfont\fR
Class:	\fBFixedFont\fR
Command-Line Switch:	\fB-fixedfont\fR
.fi
.IP
Specifies the name of the font to be used for fixed-width character
text (such as <pre>...</pre> or <tt>...</tt>.) The size, style, and 
other font attributes are determined by the format tags in the 
document. The default is courier.
.LP
.nf
Name:	\fBfontname\fR
Class:	\fBFontName\fR
Command-Line Switch:	\fB-fontname\fR
.fi
.IP
Specifies the name of the font to be used for normal-width character 
spaced text. The size, style, and other font attributes are 
determined by the format tags in the document. The default is times.
.LP
.nf
Name:	\fBfontsize\fR
Class:	\fBFontSize\fR
Command-Line Switch:	\fB-fontsize\fR
.fi
.IP
Specifies the general size of the fonts used. One of small, medium,
large, or huge. The default is medium.
.LP
.nf
Name:	\fBforeground\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB-foreground\fR
.fi
.IP
Specifies the color of text other than hypertext links, in any 
of the forms acceptable to \fBTk_GetColor\fR. This value may
be overridden in a particular document by the \fItext\fR attribute 
of the \fBBody\fR HTML tag.
.LP
.nf
Name:	\fBlink\fR
Class:	\fBLink\fR
Command-Line Switch:	\fB-link\fR
.fi
.IP
Specifies the default color of hypertext links in any of the forms
acceptable to \fBTk_GetColor\fR. This value may be overridden in a
particular document by the \fIlink\fR attribute of the \fBBody\fR 
HTML tag. The default is blue.
.LP
.nf
Name:	\fBlinkcommand\fR
Class:	\fBLinkCommand\fR
Command-Line Switch:	\fB-linkcommand\fR
.fi
.IP
Specifies the command to execute when the user clicks on a hypertext
link. Execution is of the form \fBlinkcommand href\fR, where \fBhref\fR is
the value given in the \fIhref\fR attribute of the \fBA\fR HTML tag.
.LP
.nf
Name:	\fBalink\fR
Class:	\fBalink\fR
Command-Line Switch:	\fB-alink\fR
.fi
.IP
Specifies the color of hypertext links when the cursor is over the link
in any of the forms acceptable to \fBTk_GetColor\fR. The default is red.
.LP
.nf
Name:	\fBtextBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-textbackground\fR
.fi
.IP
Specifies the background color for the text area in any of 
the forms acceptable to \fBTk_GetColor\fR. This value may be 
overridden in a particular document by the \fIbgcolor\fR attribute 
of the \fBBody\fR HTML tag.
.LP
.nf
Name:	\fBunknownimage\fR
Class:	\fBUnknownImage\fR
Command-Line Switch:	\fB-unknownimage\fR
.fi
.IP
Specifies the name of the image file to display when an \fBimg\fR
specified in the html document cannot be loaded.
.LP
.nf
Name:	\fBupdate\fR
Class:	\fBUpdate\fR
Command-Line Switch:	\fB-alink\fR
.fi
.IP
A boolean value indicating whether to call update during html rendering.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBiwidgets::scrolledhtml\fR command creates 
a scrolled text widget with the additional capability to display
html formatted documents.
An import method is provided to read an html document file, and
a render method is provided to display a html formatted text string.

.SH "METHODS"
.PP
The \fBiwidgets::scrolledhtml\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for scrolledhtml widgets:
.SH "ASSOCIATED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBbbox\fR	\fBcompare\fR	\fBdebug\fR	\fBdelete\fR	
\fBdlineinfo\fR	\fBget\fR	\fBindex\fR	\fBinsert\fR
\fBmark\fR	\fBscan\fR	\fBsearch\fR	\fBsee\fR
\fBtag\fR	\fBwindow\fR	\fBxview\fR	\fByview\fR
.fi
.LP
See the "text" manual entry for details on the standard methods.
.SH "INHERITED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBexport\fR	\fBclear\fR
.fi
.LP
See the "scrolledhtml" manual entry for details on the inherited methods.

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::scrolledhtml\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::scrolledhtml\fR
command.
.TP
\fIpathName\fR \fBimport\fR ?\fIoption\fR? \fIhref\fR
Load html formatted text from a file.  \fIHref\fR must exist.
If \fIoption\fR is -link, \fIhref\fR is assumed to be relative
to the application's current working directory. Otherwise, 
\fIhref\fR is assumed to be relative to the path of the last
page loaded. \fIHref\fR is either a filename, or a reference
of the form \fIfilename\fR#\fIanchorname\fR. In the latter form,
fIFilename\fR and/or \fIanchorname\fR may be empty. 
If \fIfilename\fR is empty, the current document is assumed. 
If \fIanchorname\fR is empty, the top of the document is assumed.
.TP
\fIpathName\fR \fBpwd\fR
Print the current working directory of the widget, i.e. the directory of the
last page loaded.
.TP
\fIpathName\fR \fBrender\fR \fIhtmltext\fR ?\fIwd\fR?
Display HTML formatted text \fIhtmltext\fR. \fIWd\fR gives the base
path to use for all links and images in the document. \fIWd\fR defaults
to the application's current working directory.
.TP
\fIpathName\fR \fBtitle\fR
Return the title of the current page, as given in the <title>...</title>
field in the document.

.SH "HTML COMPLIANCE"
.LP
This widget is compliant with HTML 3.2 with the following exceptions:
.LP
No features requiring a connection to an http server are supported.
.LP
Some image alignments aren't supported, because they are not supported by
the text widget.
.LP
The <br> attributes dealing with image alignments aren't supported.
.LP
Automatic table sizing is not supported very well, due to limitations of the
text widget
.RE
.SH EXAMPLE
.DS
 package require Iwidgets 4.0
 option add *textBackground white

 iwidgets::scrolledhtml .sh -fontname helvetica -linkcommand "this import -link"

 pack .sh -padx 10 -pady 10 -fill both -expand yes

 .sh import ~/public_html/index.html
.DE
.SH BUGS
.IP
Cells in a table can be caused to overlap. ex:
    <table border width="100%">
    <tr><td>cell1</td><td align=right rowspan=2>cell2</td></tr>
    <tr><td colspan=2>cell3 w/ overlap</td>
    </table>
It hasn't been fixed because 1) it's a pain to fix, 2) it will slow
tables down by a significant amount, and 3) netscape has the same
bug, as of V3.01.
.SH ACKNOWLEDGEMENTS
Sam Shen
.IP
This code is based largely on his tkhtml.tcl code from tk inspect. Tkhtml
is copyright 1995 Lawrence Berkeley Laboratory.
.LP
.SH AUTHOR
Kris Raney
.SH KEYWORDS
scrolledhtml, html, text, widget
