/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.Closeable;
import java.net.URI;
import javax.annotation.Nullable;
import org.gradle.internal.IoActions;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.AbstractExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpClientResponse;
import org.gradle.internal.resource.transport.http.HttpResponseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResourceAccessor
extends AbstractExternalResourceAccessor
implements ExternalResourceAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResourceAccessor.class);
    private final HttpClientHelper http;

    public HttpResourceAccessor(HttpClientHelper http) {
        this.http = http;
    }

    @Nullable
    public HttpResponseResource openResource(ExternalResourceName location, boolean revalidate) {
        String uri = location.getUri().toString();
        LOGGER.debug("Constructing external resource: {}", (Object)location);
        HttpClientResponse response = this.http.performGet(uri, revalidate);
        return this.wrapResponse(location.getUri(), response);
    }

    public HttpResponseResource getRawResource(URI uri, boolean revalidate) {
        String location = uri.toString();
        LOGGER.debug("Constructing external resource: {}", (Object)location);
        HttpClientResponse response = this.http.performRawGet(location, revalidate);
        return this.wrapResponse(uri, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalResourceMetaData getMetaData(ExternalResourceName location, boolean revalidate) {
        String uri = location.getUri().toString();
        LOGGER.debug("Constructing external resource metadata: {}", (Object)location);
        HttpClientResponse response = this.http.performHead(uri, revalidate);
        if (response == null || response.wasMissing()) {
            return null;
        }
        HttpResponseResource resource = new HttpResponseResource("HEAD", location.getUri(), response);
        try {
            ExternalResourceMetaData externalResourceMetaData = resource.getMetaData();
            return externalResourceMetaData;
        }
        finally {
            IoActions.closeQuietly((Closeable)((Object)resource));
        }
    }

    private HttpResponseResource wrapResponse(URI uri, HttpClientResponse response) {
        return new HttpResponseResource("GET", uri, response);
    }
}

