/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.truncatetables;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.truncatetables.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryTruncateTables
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    public boolean argFromPrevious;
    private DatabaseMeta connection;
    public String[] arguments;
    public String[] schemaname;
    private int NrErrors = 0;
    private int NrSuccess = 0;
    boolean continueProcess = true;

    public JobEntryTruncateTables(String n) {
        super(n, "");
        this.argFromPrevious = false;
        this.arguments = null;
        this.schemaname = null;
        this.connection = null;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.TRUNCATE_TABLES);
    }

    public JobEntryTruncateTables() {
        this("");
    }

    public JobEntryTruncateTables(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryTruncateTables je = (JobEntryTruncateTables)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            String dbname = XMLHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.findDatabase(databases, (String)dbname);
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.arguments = new String[nrFields];
            this.schemaname = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.schemaname[i] = XMLHandler.getTagValue((Node)fnode, (String)"schemaname");
            }
        }
        catch (KettleException e) {
            throw new KettleXMLException(Messages.getString("JobEntryTruncateTables.UnableLoadXML"), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            long id_db = rep.getJobEntryAttributeInteger(id_jobentry, "id_database");
            this.connection = id_db > 0L ? DatabaseMeta.findDatabase(databases, (long)id_db) : DatabaseMeta.findDatabase(databases, (String)rep.getJobEntryAttributeString(id_jobentry, "connection"));
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "name");
            this.arguments = new String[argnr];
            this.schemaname = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "name");
                this.schemaname[a] = rep.getJobEntryAttributeString(id_jobentry, a, "schemaname");
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryTruncateTables.UnableLoadRep", "" + id_jobentry), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            if (this.connection != null) {
                rep.saveJobEntryAttribute(id_job, this.getID(), "connection", this.connection.getName());
            }
            rep.saveJobEntryAttribute(id_job, this.getID(), "arg_from_previous", this.argFromPrevious);
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "name", this.arguments[i]);
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "schemaname", this.schemaname[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryTruncateTables.UnableSaveRep", "" + id_job), (Throwable)dbe);
        }
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    private boolean TruncateTables(LogWriter log, String tablename, String schemaname, Database db) {
        boolean retval = false;
        String realSchemaname = schemaname;
        String realTablename = tablename;
        try {
            if (!Const.isEmpty((String)realSchemaname)) {
                realTablename = db.getDatabaseMeta().getQuotedSchemaTableCombination(realSchemaname, realTablename);
            }
            if (db.checkTableExists(realTablename)) {
                if (!Const.isEmpty((String)realSchemaname)) {
                    db.truncateTable(realSchemaname, tablename);
                } else {
                    db.truncateTable(tablename);
                }
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobEntryTruncateTables.Log.TableTruncated", realTablename), new Object[0]);
                }
                retval = true;
            } else {
                log.logError(this.toString(), Messages.getString("JobEntryTruncateTables.Error.CanNotFindTable", realTablename), new Object[0]);
            }
        }
        catch (Exception e) {
            log.logError(this.toString(), Messages.getString("JobEntryTruncateTables.Error.CanNotTruncateTables", realTablename, e.toString()), new Object[0]);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        block20: {
            block19: {
                block18: {
                    log = LogWriter.getInstance();
                    result = previousResult;
                    rows = result.getRows();
                    resultRow = null;
                    result.setResult(true);
                    this.NrErrors = 0;
                    this.continueProcess = true;
                    this.NrSuccess = 0;
                    if (this.argFromPrevious) {
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobEntryTruncateTables.FoundPreviousRows", String.valueOf(rows != null ? rows.size() : 0)), new Object[0]);
                        }
                        if (rows.size() == 0) {
                            return result;
                        }
                    }
                    if (this.connection != null) {
                        db = new Database(this.connection);
                        db.shareVariablesWith((VariableSpace)this);
                        try {
                            try {
                                db.connect();
                                if (this.argFromPrevious && rows != null) {
                                    break block18;
                                }
                                if (this.arguments == null) break block19;
                                for (i = 0; i < this.arguments.length && !parentJob.isStopped() && this.continueProcess; ++i) {
                                    realTablename = this.environmentSubstitute(this.arguments[i]);
                                    realSchemaname = this.environmentSubstitute(this.schemaname[i]);
                                    if (!Const.isEmpty((String)realTablename)) {
                                        if (log.isDetailed()) {
                                            log.logDetailed(this.toString(), Messages.getString("JobEntryTruncateTables.ProcessingArg", this.arguments[i], this.schemaname[i]), new Object[0]);
                                        }
                                        if (this.TruncateTables(log, realTablename, realSchemaname, db)) {
                                            this.updateSuccess();
                                            continue;
                                        }
                                        this.updateErrors();
                                        continue;
                                    }
                                    log.logError(this.toString(), Messages.getString("JobEntryTruncateTables.ArgEmpty", this.arguments[i], this.schemaname[i]), new Object[0]);
                                }
                                break block19;
                            }
                            catch (Exception dbe) {
                                result.setNrErrors(1L);
                                log.logError(this.toString(), Messages.getString("JobEntryTruncateTables.Error.RunningEntry", dbe.getMessage()), new Object[0]);
                                var14_18 = null;
                                if (db == null) ** GOTO lbl69
                                db.disconnect();
                            }
                        }
                        catch (Throwable var13_20) {
                            var14_19 = null;
                            if (db != null) {
                                db.disconnect();
                            }
                            throw var13_20;
                        }
                    } else {
                        result.setNrErrors(1L);
                        log.logError(this.toString(), Messages.getString("JobEntryTruncateTables.NoDbConnection"), new Object[0]);
                    }
                    break block20;
                }
                for (iteration = 0; iteration < rows.size() && !parentJob.isStopped() && this.continueProcess; ++iteration) {
                    resultRow = (RowMetaAndData)rows.get(iteration);
                    tablename_previous = resultRow.getString(0, null);
                    schemaname_previous = resultRow.getString(1, null);
                    if (!Const.isEmpty((String)tablename_previous)) {
                        if (!log.isDetailed()) continue;
                        log.logDetailed(this.toString(), Messages.getString("JobEntryTruncateTables.ProcessingRow", tablename_previous, schemaname_previous), new Object[0]);
                        continue;
                    }
                    log.logError(this.toString(), Messages.getString("JobEntryTruncateTables.RowEmpty"), new Object[0]);
                }
            }
            var14_17 = null;
            if (db != null) {
                db.disconnect();
            }
        }
        result.setNrErrors((long)this.NrErrors);
        result.setResult(this.NrErrors == 0);
        return result;
    }

    private void updateErrors() {
        ++this.NrErrors;
        this.continueProcess = false;
    }

    private void updateSuccess() {
        ++this.NrSuccess;
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.arguments.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.arguments != null) {
            ResourceReference reference = null;
            for (int i = 0; i < this.arguments.length; ++i) {
                String filename = jobMeta.environmentSubstitute(this.arguments[i]);
                if (reference == null) {
                    reference = new ResourceReference(this);
                    references.add(reference);
                }
                reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }
}

