/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.olap;

import ca.sqlpower.architect.olap.CompoundEditListener;
import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class OLAPUtil {
    private static final Logger logger = Logger.getLogger(OLAPUtil.class);

    private OLAPUtil() {
        throw new AssertionError((Object)"Don't instantiate this class");
    }

    public static OLAPSession getSession(OLAPObject oo) {
        OLAPObject o;
        for (o = oo; o != null && !(o instanceof OLAPSession); o = o.getParent()) {
        }
        return (OLAPSession)o;
    }

    public static String getQualifier(SQLTable t) {
        SQLSchema schema = t.getSchema();
        SQLCatalog catalog = t.getCatalog();
        if (catalog == null && schema == null) {
            return null;
        }
        if (schema == null) {
            return catalog.getName();
        }
        if (catalog == null) {
            return schema.getName();
        }
        return catalog.getName() + "." + schema.getName();
    }

    public static void listenToHierarchy(OLAPObject root, SPListener spl, CompoundEditListener cel) {
        if (spl != null) {
            root.addSPListener(spl);
        }
        if (cel != null) {
            root.addCompoundEditListener(cel);
        }
        for (OLAPObject child : root.getChildren(OLAPObject.class)) {
            OLAPUtil.listenToHierarchy(child, spl, cel);
        }
    }

    public static void unlistenToHierarchy(OLAPObject root, SPListener spl, CompoundEditListener cel) {
        root.removeSPListener(spl);
        if (cel != null) {
            root.removeCompoundEditListener(cel);
        }
        for (OLAPObject child : root.getChildren(OLAPObject.class)) {
            OLAPUtil.unlistenToHierarchy(child, spl, cel);
        }
    }

    public static String nameFor(OLAPObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof MondrianModel.CubeUsage) {
            return ((MondrianModel.CubeUsage)obj).getCubeName();
        }
        if (obj instanceof MondrianModel.Hierarchy) {
            if (obj.getName() == null && obj.getParent() != null) {
                return obj.getParent().getName();
            }
            return obj.getName();
        }
        if (obj.getName() != null && obj.getName().trim().length() > 0) {
            return obj.getName();
        }
        return ((Object)((Object)obj)).getClass().getSimpleName();
    }

    public static SQLTable tableForHierarchy(MondrianModel.Hierarchy hier) throws SQLObjectException {
        OLAPSession session = OLAPUtil.getSession(hier);
        SQLDatabase database = session.getDatabase();
        MondrianModel.RelationOrJoin relation = hier.getRelation();
        if (relation == null && hier.getParent().getParent() instanceof MondrianModel.Cube) {
            MondrianModel.Cube owningCube = (MondrianModel.Cube)hier.getParent().getParent();
            relation = owningCube.getFact();
        }
        return OLAPUtil.tableForRelationOrJoin(database, relation);
    }

    public static SQLTable tableForCube(MondrianModel.Cube cube) throws SQLObjectException {
        OLAPSession session = OLAPUtil.getSession(cube);
        SQLDatabase database = session.getDatabase();
        MondrianModel.Relation relation = cube.getFact();
        return OLAPUtil.tableForRelationOrJoin(database, relation);
    }

    private static SQLTable tableForRelationOrJoin(SQLDatabase database, MondrianModel.RelationOrJoin relationOrJoin) throws SQLObjectException {
        if (relationOrJoin == null) {
            return null;
        }
        if (relationOrJoin instanceof MondrianModel.Table) {
            return OLAPUtil.getSQLTableFromOLAPTable(database, (MondrianModel.Table)relationOrJoin);
        }
        if (relationOrJoin instanceof MondrianModel.View) {
            if (((MondrianModel.View)relationOrJoin).getSelects().isEmpty()) {
                return null;
            }
            String sql = ((MondrianModel.View)relationOrJoin).getSelects().get(0).getText();
            return OLAPUtil.getSQLTableFromSQLString(database, sql);
        }
        if (relationOrJoin instanceof MondrianModel.InlineTable) {
            throw new UnsupportedOperationException("Inline tables not implemented yet");
        }
        if (relationOrJoin instanceof MondrianModel.Join) {
            MondrianModel.Join join = (MondrianModel.Join)relationOrJoin;
            return OLAPUtil.getSQLTableFromSQLString(database, OLAPUtil.generateSQLFromJoin(join));
        }
        throw new IllegalStateException("Can't produce SQLTable for unknown Relation type " + ((Object)((Object)relationOrJoin)).getClass().getName());
    }

    private static SQLTable getSQLTableFromSQLString(SQLDatabase database, String sql) throws SQLObjectException {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = database.getConnection();
            stmt = con.createStatement();
            stmt.setMaxRows(0);
            rs = stmt.executeQuery(sql);
            SQLTable table = new SQLTable(database, true);
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                SQLColumn column = new SQLColumn(table, rsmd.getColumnLabel(i), rsmd.getColumnType(i), rsmd.getPrecision(i), rsmd.getScale(i));
                table.addColumn(column);
            }
            SQLTable sQLTable = table;
            return sQLTable;
        }
        catch (SQLException e) {
            logger.error((Object)("Running the statement " + sql + " on the database " + database.getName() + " caused an exception."), (Throwable)e);
            throw new RuntimeException("Creating a view on the database " + database.getName() + " caused an exception.", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"Exception while trying to close a result set used to create a view's table.", (Throwable)e);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"Exception while trying to close a statement used to create a view's table.", (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"Exception while trying to close a connection used to create a view's table.", (Throwable)e);
                }
            }
        }
    }

    public static SQLTable getSQLTableFromOLAPTable(SQLDatabase database, MondrianModel.Table table) throws SQLObjectException {
        String qualifier = table.getSchema();
        String name = table.getName();
        if (qualifier == null || qualifier.length() == 0) {
            return (SQLTable)database.getChildByName(name, SQLTable.class);
        }
        if (qualifier.contains(".")) {
            String cat = qualifier.substring(0, qualifier.indexOf(46));
            String schema = qualifier.substring(qualifier.indexOf(46) + 1);
            return database.getTableByName(cat, schema, name);
        }
        if (SQLObjectUtils.isCompatibleWithHierarchy((SQLDatabase)database, (String)qualifier, null, (String)name)) {
            return database.getTableByName(qualifier, null, name);
        }
        if (SQLObjectUtils.isCompatibleWithHierarchy((SQLDatabase)database, null, (String)qualifier, (String)name)) {
            return database.getTableByName(null, qualifier, name);
        }
        return null;
    }

    public static List<SQLTable> getAvailableTables(OLAPObject obj) throws SQLObjectException {
        OLAPSession osession = OLAPUtil.getSession(obj);
        SQLDatabase db = osession.getDatabase();
        List tables = db != null ? SQLObjectUtils.findDescendentsByClass((SQLObject)db, SQLTable.class, new ArrayList()) : Collections.emptyList();
        return tables;
    }

    public static MondrianModel.Cube findReferencedCube(MondrianModel.VirtualCube vCube, MondrianModel.CubeUsage cu) {
        OLAPSession olapSession = OLAPUtil.getSession(vCube);
        if (olapSession == null) {
            throw new IllegalArgumentException("Can't find OLAPSession ancestor: " + (Object)((Object)cu));
        }
        for (MondrianModel.Cube c : olapSession.getSchema().getCubes()) {
            if (!c.getName().equalsIgnoreCase(cu.getCubeName())) continue;
            return c;
        }
        return null;
    }

    public static MondrianModel.Dimension findReferencedDimension(MondrianModel.CubeDimension cubeDim) {
        OLAPSession olapSession = OLAPUtil.getSession(cubeDim);
        if (olapSession == null) {
            throw new IllegalArgumentException("Can't find OLAPSession ancestor: " + (Object)((Object)cubeDim));
        }
        if (cubeDim instanceof MondrianModel.Dimension) {
            return (MondrianModel.Dimension)cubeDim;
        }
        if (cubeDim instanceof MondrianModel.DimensionUsage) {
            String dimName = ((MondrianModel.DimensionUsage)cubeDim).getSource();
            for (MondrianModel.Dimension d : olapSession.getSchema().getDimensions()) {
                if (!d.getName().equalsIgnoreCase(dimName)) continue;
                return d;
            }
        } else if (cubeDim instanceof MondrianModel.VirtualCubeDimension) {
            MondrianModel.VirtualCubeDimension vCubeDim = (MondrianModel.VirtualCubeDimension)cubeDim;
            if (vCubeDim.getCubeName() == null) {
                String dimName = vCubeDim.getName();
                for (MondrianModel.Dimension d : olapSession.getSchema().getDimensions()) {
                    if (!d.getName().equalsIgnoreCase(dimName)) continue;
                    return d;
                }
            } else {
                for (MondrianModel.Cube c : olapSession.getSchema().getCubes()) {
                    if (!c.getName().equalsIgnoreCase(vCubeDim.getCubeName())) continue;
                    for (MondrianModel.CubeDimension cd : c.getDimensions()) {
                        if (!cd.getName().equalsIgnoreCase(vCubeDim.getName())) continue;
                        if (cd instanceof MondrianModel.Dimension) {
                            return (MondrianModel.Dimension)cd;
                        }
                        if (cd instanceof MondrianModel.DimensionUsage) {
                            MondrianModel.DimensionUsage du = (MondrianModel.DimensionUsage)cd;
                            return OLAPUtil.findReferencedDimension(du);
                        }
                        throw new IllegalStateException("Invalid reference by VirtualCubeDimension: " + (Object)((Object)vCubeDim));
                    }
                }
            }
        } else {
            throw new UnsupportedOperationException("CubeDimension of type " + ((Object)((Object)cubeDim)).getClass() + " not recognized.");
        }
        return null;
    }

    public static boolean isNameUnique(OLAPObject parent, Class<? extends OLAPObject> type, String name) {
        block11: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                OLAPSession olapSession;
                                block13: {
                                    block12: {
                                        block10: {
                                            olapSession = OLAPUtil.getSession(parent);
                                            if (olapSession == null) {
                                                throw new IllegalArgumentException("Can't find OLAPSession ancestor: " + (Object)((Object)parent));
                                            }
                                            if (type != MondrianModel.Cube.class) break block10;
                                            for (MondrianModel.Cube c : olapSession.getSchema().getCubes()) {
                                                if (!c.getName().equalsIgnoreCase(name)) continue;
                                                return false;
                                            }
                                            break block11;
                                        }
                                        if (type != MondrianModel.Dimension.class || !(parent instanceof MondrianModel.Schema)) break block12;
                                        for (MondrianModel.Dimension d : ((MondrianModel.Schema)parent).getDimensions()) {
                                            if (!d.getName().equalsIgnoreCase(name)) continue;
                                            return false;
                                        }
                                        break block11;
                                    }
                                    if (type != MondrianModel.Dimension.class || !(parent instanceof MondrianModel.Cube)) break block13;
                                    for (MondrianModel.CubeDimension cd : ((MondrianModel.Cube)parent).getDimensions()) {
                                        if (!cd.getName().equalsIgnoreCase(name)) continue;
                                        return false;
                                    }
                                    break block11;
                                }
                                if (type != MondrianModel.VirtualCube.class) break block14;
                                for (MondrianModel.VirtualCube vCube : olapSession.getSchema().getVirtualCubes()) {
                                    if (!vCube.getName().equalsIgnoreCase(name)) continue;
                                    return false;
                                }
                                break block11;
                            }
                            if (type != MondrianModel.Measure.class) break block15;
                            MondrianModel.Cube c = (MondrianModel.Cube)parent;
                            for (MondrianModel.Measure m : c.getMeasures()) {
                                if (!m.getName().equalsIgnoreCase(name)) continue;
                                return false;
                            }
                            break block11;
                        }
                        if (type != MondrianModel.Level.class) break block16;
                        MondrianModel.Hierarchy h = (MondrianModel.Hierarchy)parent;
                        for (MondrianModel.Level l : h.getLevels()) {
                            if (!l.getName().equalsIgnoreCase(name)) continue;
                            return false;
                        }
                        break block11;
                    }
                    if (type != MondrianModel.Hierarchy.class) break block17;
                    MondrianModel.Dimension d = (MondrianModel.Dimension)parent;
                    for (MondrianModel.Hierarchy h : d.getHierarchies()) {
                        if (!(name == null || name.equalsIgnoreCase(parent.getName()) ? h.getName() == null || h.getName().equalsIgnoreCase(parent.getName()) : name.equalsIgnoreCase(h.getName()))) continue;
                        return false;
                    }
                    break block11;
                }
                if (type != MondrianModel.CubeUsage.class) break block18;
                MondrianModel.VirtualCube vCube = (MondrianModel.VirtualCube)parent;
                for (MondrianModel.CubeUsage usage : vCube.getCubeUsage().getCubeUsages()) {
                    if (!usage.getCubeName().equalsIgnoreCase(name)) continue;
                    return false;
                }
                break block11;
            }
            if (type != MondrianModel.DimensionUsage.class) break block11;
            MondrianModel.Cube c = (MondrianModel.Cube)parent;
            for (MondrianModel.CubeDimension cd : c.getDimensions()) {
                if (!cd.getName().equalsIgnoreCase(name)) continue;
                return false;
            }
        }
        return true;
    }

    public static String generateSQLFromJoin(MondrianModel.Join join) {
        StringBuilder sql = new StringBuilder("SELECT * FROM ");
        if (join.getLeft() instanceof MondrianModel.Table) {
            MondrianModel.Table leftTable = (MondrianModel.Table)join.getLeft();
            if (leftTable.getSchema() != null) {
                sql.append(leftTable.getSchema()).append(".");
            }
            sql.append(leftTable.getName());
            sql.append(" ");
            if (leftTable.getAlias() != null) {
                sql.append(leftTable.getAlias());
            }
        } else if (join.getLeft() instanceof MondrianModel.Join) {
            sql.append("(");
            sql.append(OLAPUtil.generateSQLFromJoin((MondrianModel.Join)join.getLeft()));
            sql.append(") AS ").append(join.getLeftAlias());
        } else {
            throw new UnsupportedOperationException("Join on a " + ((Object)((Object)join.getLeft())).getClass() + " is not supported");
        }
        sql.append(" JOIN ");
        if (join.getRight() instanceof MondrianModel.Table) {
            MondrianModel.Table rightTable = (MondrianModel.Table)join.getRight();
            if (rightTable.getSchema() != null) {
                sql.append(rightTable.getSchema()).append(".");
            }
            sql.append(rightTable.getName());
            sql.append(" ");
            if (rightTable.getAlias() != null) {
                sql.append(rightTable.getAlias());
            }
        } else if (join.getRight() instanceof MondrianModel.Join) {
            sql.append("(");
            sql.append(OLAPUtil.generateSQLFromJoin((MondrianModel.Join)join.getRight()));
            sql.append(") AS ").append(join.getRightAlias());
        } else {
            throw new UnsupportedOperationException("Join on a " + ((Object)((Object)join.getRight())).getClass() + " is not supported");
        }
        sql.append(" ON ");
        if (join.getLeftAlias() != null) {
            sql.append(join.getLeftAlias()).append(".");
        } else if (join.getLeft() instanceof MondrianModel.Table && ((MondrianModel.Table)join.getLeft()).getName() != null) {
            sql.append(((MondrianModel.Table)join.getLeft()).getName()).append(".");
        }
        sql.append(join.getLeftKey());
        sql.append("=");
        if (join.getRightAlias() != null) {
            sql.append(join.getRightAlias()).append(".");
        } else if (join.getRight() instanceof MondrianModel.Table && ((MondrianModel.Table)join.getRight()).getName() != null) {
            sql.append(((MondrianModel.Table)join.getRight()).getName()).append(".");
        }
        sql.append(join.getRightKey());
        return sql.toString();
    }
}

