/*
 * Decompiled with CFR 0.152.
 */
package tr.runtime;

import java.io.File;
import java.net.URL;
import tr.runtime.Runtime;

public class Open {
    public static final void openFile(File file) {
        if (file == null) {
            return;
        }
        String filename = Open.getFilePath(file);
        if (Runtime.macosx) {
            Runtime.exec(new String[]{"open", filename});
        } else if (Runtime.linux || Runtime.unix) {
            Runtime.exec(new String[]{"xdg-open", filename});
        } else if (Runtime.win95 || Runtime.win98) {
            Runtime.exec(new String[]{"command.com", "/C", "start", filename});
        } else if (Runtime.windows) {
            Runtime.exec(new String[]{"cmd.exe", "/C", "start", filename});
        } else {
            Runtime.exec(new String[]{"open", filename});
        }
    }

    private static String getFilePath(File file) {
        if (file == null) {
            return null;
        }
        String path = file.getPath();
        if (Runtime.windows || Runtime.linux) {
            path = "file:///" + path.replace(" ", "%20");
        }
        return path;
    }

    public static final void openTextFile(File file) {
        if (file == null) {
            return;
        }
        String filename = Open.getFilePath(file);
        if (Runtime.macosx) {
            Runtime.exec(new String[]{"open", "-t", filename});
        } else if (Runtime.linux || Runtime.unix) {
            Runtime.exec(new String[]{"xdg-open", filename});
        } else if (Runtime.win95 || Runtime.win98) {
            Runtime.exec(new String[]{"command.com", "/C", "start", filename});
        } else if (Runtime.windows) {
            Runtime.exec(new String[]{"cmd.exe", "/C", "start", filename});
        } else {
            Runtime.exec(new String[]{"open", filename});
        }
    }

    public static final void open(URL url) {
        if (url == null) {
            return;
        }
        String urlString = url.toExternalForm().replace(" ", "%20");
        if (Runtime.windows) {
            urlString = urlString.replace("&", "^&");
        }
        if (Runtime.macosx) {
            Runtime.exec(new String[]{"open", urlString});
        } else if (Runtime.linux || Runtime.unix) {
            Runtime.exec(new String[]{"xdg-open", urlString});
        } else if (Runtime.win95 || Runtime.win98) {
            Runtime.exec(new String[]{"command.com", "/c", "start", urlString});
        } else if (Runtime.windows) {
            Runtime.exec(new String[]{"cmd.exe", "/c", "start", urlString});
        } else {
            Runtime.exec(new String[]{"open", urlString});
        }
    }
}

