/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.TreePath;
import org.openide.ErrorManager;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.DropGlassPane;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.PasteType;

final class OutlineViewDropSupport
implements DropTargetListener,
Runnable {
    protected static final int FUSSY_POINTING = 3;
    private static final int DELAY_TIME_FOR_EXPAND = 1000;
    private static final int SHIFT_DOWN = -1;
    private static final int SHIFT_RIGHT = 0;
    private static final int SHIFT_LEFT = 0;
    boolean active = false;
    boolean dropTargetPopupAllowed;
    DropTarget dropTarget;
    Rectangle lastNodeArea;
    private int upperNodeIdx = -1;
    private int lowerNodeIdx = -1;
    Timer timer;
    DropGlassPane dropPane;
    private int pointAt = 0;
    protected OutlineView view;
    protected JTable table;
    private static ErrorManager err = ErrorManager.getDefault().getInstance(OutlineViewDropSupport.class.getName());
    private static boolean LOGABLE = err.isLoggable(1);

    public OutlineViewDropSupport(OutlineView outlineView, JTable jTable, boolean bl) {
        this.view = outlineView;
        this.table = jTable;
        this.dropTargetPopupAllowed = bl;
    }

    public void setDropTargetPopupAllowed(boolean bl) {
        this.dropTargetPopupAllowed = bl;
    }

    public boolean isDropTargetPopupAllowed() {
        return this.dropTargetPopupAllowed;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        OutlineViewDropSupport.log("dragEnter " + dropTargetDragEvent);
        this.checkStoredGlassPane();
        this.doDragOver(dropTargetDragEvent);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        OutlineViewDropSupport.log("dragOver " + dropTargetDragEvent);
        this.checkStoredGlassPane();
        this.doDragOver(dropTargetDragEvent);
    }

    private void checkStoredGlassPane() {
        if (!DropGlassPane.isOriginalPaneStored()) {
            Component component = this.table.getRootPane().getGlassPane();
            DropGlassPane.setOriginalPane(this.table, component, component.isVisible());
            this.dropPane = DropGlassPane.getDefault(this.table);
            this.table.getRootPane().setGlassPane(this.dropPane);
            this.dropPane.revalidate();
            this.dropPane.setVisible(true);
            OutlineViewDropSupport.log("dropPane was set");
        }
    }

    private void doDragOver(DropTargetDragEvent dropTargetDragEvent) {
        Object object;
        TreePath treePath;
        Object object2;
        int n = dropTargetDragEvent.getDropAction();
        int n2 = this.view.getAllowedDropActions();
        n = ExplorerDnDManager.getDefault().getAdjustedDropAction(n, n2);
        Point point = dropTargetDragEvent.getLocation();
        int n3 = this.view.getOutline().rowAtPoint(point);
        int n4 = this.view.getOutline().columnAtPoint(point);
        OutlineViewDropSupport.log("doDragOver row == " + n3 + " column == " + n4);
        Node node = null;
        if (n3 == -1) {
            node = this.view.manager.getRootContext();
            if (this.canDrop(node, n)) {
                dropTargetDragEvent.acceptDrag(n);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
            return;
        }
        node = this.getNodeForDrop(point);
        OutlineViewDropSupport.log("doDragOver dropNode == " + node);
        if (node == null) {
            dropTargetDragEvent.rejectDrag();
            this.removeDropLine();
            return;
        }
        Rectangle rectangle = this.table.getCellRect(n3, n4, false);
        OutlineViewDropSupport.log("nodeArea == " + rectangle);
        int n5 = rectangle.x + rectangle.width;
        if (rectangle != null) {
            this.pointAt = 0;
            if (point.y <= rectangle.y + 3) {
                if (n3 != 0) {
                    this.pointAt = -1;
                    if (node.getParentNode() != null) {
                        OutlineViewDropSupport.log("dropNode is parent 1");
                        node = node.getParentNode();
                    }
                }
            } else if (point.y >= rectangle.y + rectangle.height - 3) {
                object2 = this.view.getOutline().getLayoutCache().getPathForRow(this.view.getOutline().convertRowIndexToModel(n3));
                OutlineViewDropSupport.log("tp == " + object2);
                if (!this.view.getOutline().getLayoutCache().isExpanded((TreePath)object2)) {
                    OutlineViewDropSupport.log("tree path is not expanded");
                    this.pointAt = 1;
                    treePath = this.view.getOutline().getLayoutCache().getPathForRow(this.view.getOutline().convertRowIndexToModel(n3 + 1));
                    if (node.getParentNode() != null) {
                        OutlineViewDropSupport.log("dropNode is parent 2");
                        node = node.getParentNode();
                    }
                }
            }
        }
        n5 += 0;
        object2 = (Index)node.getCookie(Index.class);
        OutlineViewDropSupport.log("indexCookie == " + object2);
        if (object2 != null) {
            if (this.pointAt == -1) {
                this.lowerNodeIdx = object2.indexOf(this.getNodeForDrop(point));
                this.upperNodeIdx = this.lowerNodeIdx - 1;
            } else if (this.pointAt == 1) {
                this.upperNodeIdx = object2.indexOf(this.getNodeForDrop(point));
                this.lowerNodeIdx = this.upperNodeIdx + 1;
            }
        }
        treePath = this.view.getOutline().getLayoutCache().getPathForRow(this.view.getOutline().convertRowIndexToModel(n3));
        boolean bl = this.view.getOutline().getLayoutCache().isExpanded(treePath);
        if (!(this.timer != null && this.timer.isRunning() || node == null || node.isLeaf() || bl)) {
            object = node;
            this.removeTimer();
            this.timer = new Timer(1000, new ActionListener(){

                public final void actionPerformed(ActionEvent actionEvent) {
                    OutlineViewDropSupport.log("should expand " + treePath);
                    OutlineViewDropSupport.this.view.getOutline().expandPath(treePath);
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
        }
        if (this.pointAt == 0) {
            this.dropPane.setDropLine(null);
        } else if (this.pointAt == -1) {
            object = new Line2D.Double(rectangle.x - 0, rectangle.y + -1, n5, rectangle.y + -1);
            this.convertBoundsAndSetDropLine((Line2D)object);
            Rectangle rectangle2 = new Rectangle(rectangle.x - 0, rectangle.y + -1 - 3, n5 - rectangle.x + 0, 5);
            rectangle = (Rectangle)rectangle.createUnion(rectangle2);
        } else {
            object = new Line2D.Double(rectangle.x - 0, rectangle.y + rectangle.height + -1, n5, rectangle.y + rectangle.height + -1);
            this.convertBoundsAndSetDropLine((Line2D)object);
            Rectangle rectangle3 = new Rectangle(rectangle.x - 0, rectangle.y + rectangle.height, n5 - rectangle.x + 0, 2);
            rectangle = (Rectangle)rectangle.createUnion(rectangle3);
        }
        if (this.lastNodeArea != null && !this.lastNodeArea.equals(rectangle)) {
            this.repaint(this.lastNodeArea);
        }
        if (!rectangle.equals(this.lastNodeArea)) {
            this.repaint(rectangle);
            this.lastNodeArea = rectangle;
            this.removeTimer();
        }
        if (this.canDrop(node, n)) {
            dropTargetDragEvent.acceptDrag(n);
        } else if (this.canReorder(node, ExplorerDnDManager.getDefault().getDraggedNodes())) {
            dropTargetDragEvent.acceptDrag(n);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    private void repaint(Rectangle rectangle) {
        this.table.repaint(rectangle.x - 5, rectangle.y - 5, rectangle.width + 10, rectangle.height + 10);
    }

    private void convertBoundsAndSetDropLine(Line2D line2D) {
        int n = (int)line2D.getX1();
        int n2 = (int)line2D.getX2();
        int n3 = (int)line2D.getY1();
        int n4 = (int)line2D.getY2();
        Point point = SwingUtilities.convertPoint(this.table, n, n3, this.table.getRootPane());
        Point point2 = SwingUtilities.convertPoint(this.table, n2, n4, this.table.getRootPane());
        line2D.setLine(point, point2);
        this.dropPane.setDropLine(line2D);
    }

    private void removeTimer() {
        if (this.timer != null) {
            ActionListener[] actionListenerArray = (ActionListener[])this.timer.getListeners(ActionListener.class);
            for (int i = 0; i < actionListenerArray.length; ++i) {
                this.timer.removeActionListener(actionListenerArray[i]);
            }
            this.timer.stop();
            this.timer = null;
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        Node[] nodeArray = ExplorerDnDManager.getDefault().getDraggedNodes();
        int n = ExplorerDnDManager.getDefault().getAdjustedDropAction(dropTargetDragEvent.getDropAction(), this.view.getAllowedDropActions());
        for (int i = 0; i < nodeArray.length; ++i) {
            if ((this.view.getAllowedDropActions() & n) != 0 && DragDropUtilities.checkNodeForAction(nodeArray[i], n)) continue;
            dropTargetDragEvent.rejectDrag();
            return;
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.stopDragging();
    }

    private void removeDropLine() {
        this.dropPane.setDropLine(null);
        if (this.lastNodeArea != null) {
            this.repaint(this.lastNodeArea);
            this.lastNodeArea = null;
        }
    }

    private void stopDragging() {
        this.removeDropLine();
        this.removeTimer();
        if (DropGlassPane.isOriginalPaneStored()) {
            DropGlassPane.putBackOriginal();
        }
    }

    private Node getNodeForDrop(Point point) {
        int n = this.view.getOutline().rowAtPoint(point);
        return this.view.getNodeFromRow(n);
    }

    private boolean canReorder(Node node, Node[] nodeArray) {
        if ((ExplorerDnDManager.getDefault().getNodeAllowedActions() & 2) == 0) {
            OutlineViewDropSupport.log("canReorder returning false 1");
            return false;
        }
        if (node == null || nodeArray == null || nodeArray.length == 0) {
            OutlineViewDropSupport.log("canReorder returning false 2");
            return false;
        }
        Index index = (Index)node.getCookie(Index.class);
        if (index == null) {
            OutlineViewDropSupport.log("canReorder returning false 3");
            return false;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i] == null) {
                OutlineViewDropSupport.log("canReorder returning false 4");
                return false;
            }
            if (nodeArray[i].getParentNode() == null) {
                OutlineViewDropSupport.log("canReorder returning false 5");
                return false;
            }
            if (nodeArray[i].getParentNode().equals((Object)node)) continue;
            OutlineViewDropSupport.log("canReorder returning false 6");
            return false;
        }
        OutlineViewDropSupport.log("canReorder returning true");
        return true;
    }

    private void performReorder(Node node, Node[] nodeArray, int n, int n2) {
        block11: {
            try {
                int n3;
                int n4;
                Index index = (Index)node.getCookie(Index.class);
                OutlineViewDropSupport.log("performReorder indexCookie == " + index);
                if (index == null) break block11;
                int[] nArray = new int[index.getNodesCount()];
                int[] nArray2 = new int[nodeArray.length];
                int n5 = 0;
                for (n4 = 0; n4 < nodeArray.length; ++n4) {
                    n3 = index.indexOf(nodeArray[n4]);
                    if (n3 < 0 || n3 >= nArray.length) continue;
                    nArray2[n5++] = n3;
                }
                Arrays.sort(nArray2);
                if (n < 0 || n2 >= nArray.length || n5 == 0) {
                    return;
                }
                n4 = 0;
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    int n6;
                    if (n3 <= n2) {
                        if (!this.containsNumber(nArray2, n5, n3)) {
                            nArray[n3] = n4++;
                        }
                        if (n3 != n2) continue;
                        for (n6 = 0; n6 < n5; ++n6) {
                            if (nArray2[n6] > n2) continue;
                            nArray[nArray2[n6]] = n4++;
                        }
                        continue;
                    }
                    if (n3 == n) {
                        for (n6 = 0; n6 < n5; ++n6) {
                            if (nArray2[n6] < n) continue;
                            nArray[nArray2[n6]] = n4++;
                        }
                    }
                    if (this.containsNumber(nArray2, n5, n3)) continue;
                    nArray[n3] = n4++;
                }
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    if (nArray[n3] == n3) continue;
                    index.reorder(nArray);
                    break;
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }

    private boolean containsNumber(int[] nArray, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] != n2) continue;
            return true;
        }
        return false;
    }

    private Node[] findDropedNodes(Node node, Node[] nodeArray) {
        if (node == null || nodeArray.length == 0) {
            return null;
        }
        Node[] nodeArray2 = new Node[nodeArray.length];
        Children children = node.getChildren();
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray2[i] = children.findChild(nodeArray[i].getName());
        }
        return nodeArray2;
    }

    private boolean canDrop(Node node, int n) {
        Object object;
        OutlineViewDropSupport.log("canDrop " + node);
        if (node == null) {
            return false;
        }
        if ((this.view.getAllowedDropActions() & n) == 0) {
            return false;
        }
        if ((2 & n) != 0) {
            object = ExplorerDnDManager.getDefault().getDraggedNodes();
            if (object == null) {
                return false;
            }
            for (int i = 0; i < ((Node[])object).length; ++i) {
                if (!node.equals((Object)object[i].getParentNode())) continue;
                return false;
            }
        }
        object = ExplorerDnDManager.getDefault().getDraggedTransferable((2 & n) != 0);
        OutlineViewDropSupport.log("transferable == " + object);
        if (object == null) {
            return false;
        }
        Object var4_5 = null;
        return var4_5 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = true;
        try {
            OutlineViewDropSupport.log("drop");
            this.stopDragging();
            Node node = this.getNodeForDrop(dropTargetDropEvent.getLocation());
            OutlineViewDropSupport.log("drop dropNode == " + node);
            if (node == null) {
                node = this.view.manager.getRootContext();
            } else if (this.pointAt != 0) {
                node = node.getParentNode();
            }
            Node[] nodeArray = ExplorerDnDManager.getDefault().getDraggedNodes();
            int n = ExplorerDnDManager.getDefault().getAdjustedDropAction(dropTargetDropEvent.getDropAction(), this.view.getAllowedDropActions());
            if (!this.canDrop(node, n)) {
                if (this.canReorder(node, nodeArray)) {
                    this.performReorder(node, nodeArray, this.lowerNodeIdx, this.upperNodeIdx);
                    dropTargetDropEvent.acceptDrop(n);
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
                return;
            }
            dropTargetDropEvent.acceptDrop(n);
            if (0x40000000 == n) {
                int n2;
                PasteType[] pasteTypeArray = new PasteType[]{};
                PasteType[] pasteTypeArray2 = new PasteType[]{};
                if ((ExplorerDnDManager.getDefault().getNodeAllowedActions() & 2) != 0) {
                    pasteTypeArray = DragDropUtilities.getPasteTypes(node, ExplorerDnDManager.getDefault().getDraggedTransferable(true));
                }
                if ((ExplorerDnDManager.getDefault().getNodeAllowedActions() & 1) != 0) {
                    pasteTypeArray2 = DragDropUtilities.getPasteTypes(node, ExplorerDnDManager.getDefault().getDraggedTransferable(false));
                }
                TreeSet<PasteType> treeSet = new TreeSet<PasteType>(new Comparator(){

                    public int compare(Object object, Object object2) {
                        int n = ((PasteType)object).getName().compareTo(((PasteType)object2).getName());
                        OutlineViewDropSupport.log("res1: " + n);
                        if (n == 0) {
                            n = System.identityHashCode(object) - System.identityHashCode(object2);
                        }
                        OutlineViewDropSupport.log("res2: " + n);
                        return n;
                    }
                });
                for (n2 = 0; n2 < pasteTypeArray.length; ++n2) {
                    OutlineViewDropSupport.log(pasteTypeArray[n2].getName() + ", " + System.identityHashCode(pasteTypeArray[n2]));
                    treeSet.add(pasteTypeArray[n2]);
                }
                for (n2 = 0; n2 < pasteTypeArray2.length; ++n2) {
                    OutlineViewDropSupport.log(pasteTypeArray2[n2].getName() + ", " + System.identityHashCode(pasteTypeArray2[n2]));
                    treeSet.add(pasteTypeArray2[n2]);
                }
                DragDropUtilities.createDropFinishPopup(treeSet).show(this.table, Math.max(dropTargetDropEvent.getLocation().x - 5, 0), Math.max(dropTargetDropEvent.getLocation().y - 5, 0));
                if (this.canReorder(node, nodeArray)) {
                    final Node node2 = node;
                    final int n3 = this.upperNodeIdx;
                    final int n4 = this.lowerNodeIdx;
                    final Node[] nodeArray2 = nodeArray;
                    DragDropUtilities.setPostDropRun(new Runnable(){

                        public void run() {
                            OutlineViewDropSupport.this.performReorder(node2, OutlineViewDropSupport.this.findDropedNodes(node2, nodeArray2), n4, n3);
                        }
                    });
                }
            } else {
                PasteType pasteType = DragDropUtilities.getDropType(node, ExplorerDnDManager.getDefault().getDraggedTransferable((2 & n) != 0), n, -1);
                Node[] nodeArray3 = DragDropUtilities.performPaste(pasteType, node);
                ExplorerDnDManager.getDefault().setDraggedNodes(nodeArray3);
                if (this.canReorder(node, nodeArray3)) {
                    this.performReorder(node, nodeArray3, this.lowerNodeIdx, this.upperNodeIdx);
                }
            }
        }
        finally {
            dropTargetDropEvent.dropComplete(bl);
        }
    }

    public void activate(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        this.getDropTarget().setActive(bl);
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        DragDropUtilities.dropNotSuccesfull();
    }

    DropTarget getDropTarget() {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(this.table, this.view.getAllowedDropActions(), this, false);
        }
        return this.dropTarget;
    }

    private static void log(String string) {
        if (LOGABLE) {
            err.log(string);
        }
    }
}

