/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.ctp;

import ca.odell.glazedlists.impl.ctp.CTPConnectionManager;
import ca.odell.glazedlists.impl.ctp.CTPHandler;
import ca.odell.glazedlists.impl.ctp.CloseConnection;
import ca.odell.glazedlists.impl.ctp.SendChunk;
import ca.odell.glazedlists.impl.io.Bufferlo;
import ca.odell.glazedlists.impl.nio.NIOAttachment;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public final class CTPConnection
implements NIOAttachment {
    private static Logger logger = Logger.getLogger(CTPConnection.class.toString());
    static final int STATE_SERVER_AWAITING_CONNECT = 0;
    static final int STATE_CLIENT_AWAITING_CONNECT = 1;
    static final int STATE_CLIENT_CONSTRUCTING_REQUEST = 2;
    static final int STATE_SERVER_AWAITING_REQUEST = 3;
    static final int STATE_SERVER_CONSTRUCTING_RESPONSE = 4;
    static final int STATE_CLIENT_AWAITING_RESPONSE = 5;
    static final int STATE_READY = 6;
    static final int STATE_RECEIVED_CLOSE = 7;
    static final int STATE_CLOSED_PERMANENTLY = 8;
    static final int RESPONSE_OK = 200;
    static final int RESPONSE_ERROR = 500;
    int state = -1;
    SelectionKey selectionKey = null;
    SocketChannel socketChannel = null;
    private Bufferlo parser;
    Bufferlo writer;
    CTPHandler handler;
    CTPConnectionManager manager;
    String remoteHost = "remotehost";
    String localHost = "localhost";
    static final String CTP_URI = "/glazedlists";
    boolean sourceChunked = false;

    private CTPConnection(SelectionKey selectionKey, CTPHandler handler, CTPConnectionManager manager) {
        if (selectionKey == null) {
            throw new IllegalArgumentException();
        }
        this.selectionKey = selectionKey;
        this.handler = handler;
        this.manager = manager;
        this.socketChannel = (SocketChannel)selectionKey.channel();
        this.parser = new Bufferlo();
        this.writer = new Bufferlo();
    }

    static CTPConnection client(String host, SelectionKey selectionKey, CTPHandler handler, CTPConnectionManager manager) {
        CTPConnection client = new CTPConnection(selectionKey, handler, manager);
        client.state = 1;
        client.remoteHost = host;
        return client;
    }

    static CTPConnection server(SelectionKey selectionKey, CTPHandler handler, CTPConnectionManager manager) {
        CTPConnection server = new CTPConnection(selectionKey, handler, manager);
        server.state = 0;
        server.remoteHost = ((InetSocketAddress)server.socketChannel.socket().getRemoteSocketAddress()).getAddress().getHostAddress();
        return server;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public int getLocalPort() {
        return this.socketChannel.socket().getLocalPort();
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.socketChannel.socket().getPort();
    }

    public void handleRead() {
        try {
            int bytesIn = this.parser.readFromChannel(this.socketChannel);
            if (bytesIn < 0) {
                throw new EOFException("End of stream");
            }
        }
        catch (IOException e) {
            this.close(e);
        }
        boolean satisfied = true;
        while (satisfied) {
            if (this.state == 3) {
                satisfied = this.handleRequest();
                continue;
            }
            if (this.state == 5) {
                satisfied = this.handleResponse();
                continue;
            }
            if (this.state == 6) {
                satisfied = this.handleChunk();
                continue;
            }
            throw new IllegalStateException("Cannot handle read from state " + this.state);
        }
    }

    public void handleWrite() {
        try {
            this.writer.writeToChannel(this.socketChannel, this.selectionKey);
        }
        catch (IOException e) {
            this.close(e);
        }
    }

    public void handleConnect() {
        try {
            this.socketChannel.finishConnect();
        }
        catch (IOException e) {
            this.close(e);
            return;
        }
        if (this.state == 1) {
            logger.fine("Opened connection to " + this);
            this.selectionKey.interestOps(1);
            this.state = 2;
            this.sendRequest(CTP_URI, Collections.EMPTY_MAP);
        } else if (this.state == 0) {
            logger.fine("Accepted connection from " + this);
            this.selectionKey.interestOps(1);
            this.state = 3;
        } else {
            throw new IllegalStateException();
        }
    }

    void sendRequest(String uri, Map headers) {
        if (this.state != 2) {
            throw new IllegalStateException();
        }
        try {
            this.writer.write("POST ");
            this.writer.write(uri);
            this.writer.write(" HTTP/1.1\r\n");
            TreeMap<String, String> responseHeaders = new TreeMap<String, String>();
            responseHeaders.putAll(headers);
            responseHeaders.put("Transfer-Encoding", "chunked");
            responseHeaders.put("Host", this.remoteHost);
            this.writeHeaders(responseHeaders);
            this.writer.write("\r\n");
            this.writer.writeToChannel(this.socketChannel, this.selectionKey);
            this.state = 5;
        }
        catch (IOException e) {
            this.close(e);
        }
    }

    private boolean handleRequest() {
        if (this.state != 3) {
            throw new IllegalStateException();
        }
        try {
            if (this.parser.indexOf("\\r\\n\\r\\n") == -1) {
                return false;
            }
            this.parser.consume("POST( )+");
            String uri = this.parser.readUntil("( )+");
            this.parser.consume("HTTP\\/1\\.1 *");
            this.parser.consume("\\r\\n");
            Map headers = this.readHeaders();
            this.handleHeaders(headers);
            this.parser.consume("\\r\\n");
            if (CTP_URI.equals(uri)) {
                this.state = 4;
                this.sendResponse(200, Collections.EMPTY_MAP);
                return true;
            }
            this.close(new Exception("Could not find URI \"" + uri + "\""));
            return false;
        }
        catch (ParseException e) {
            this.close(new IOException("Failed to decode HTTP request, " + e.getMessage()));
            return false;
        }
        catch (IOException e) {
            this.close(e);
            return false;
        }
    }

    void sendResponse(int code, Map headers) {
        if (this.state != 4) {
            throw new IllegalStateException();
        }
        try {
            if (code == 200) {
                this.writer.write("HTTP/1.1 200 OK\r\n");
            } else if (code == 500) {
                this.writer.write("HTTP/1.1 500 Error\r\n");
            } else {
                throw new IllegalArgumentException("Unsupported code: " + code);
            }
            TreeMap<String, String> responseHeaders = new TreeMap<String, String>();
            responseHeaders.putAll(headers);
            responseHeaders.put("Transfer-Encoding", "chunked");
            this.writeHeaders(responseHeaders);
            this.writer.write("\r\n");
            this.writer.writeToChannel(this.socketChannel, this.selectionKey);
            logger.info("Accepted connection from " + this);
            this.state = 6;
            this.handler.connectionReady(this);
        }
        catch (IOException e) {
            this.close(e);
        }
    }

    private boolean handleResponse() {
        if (this.state != 5) {
            throw new IllegalStateException();
        }
        try {
            if (this.parser.indexOf("\\r\\n\\r\\n") == -1) {
                return false;
            }
            this.parser.consume("HTTP\\/1\\.1( )+");
            String codeString = this.parser.readUntil("( )+");
            int code = Integer.parseInt(codeString);
            String description = this.parser.readUntil("\\r\\n");
            Map headers = this.readHeaders();
            this.handleHeaders(headers);
            this.parser.consume("\\r\\n");
            if (code == 200) {
                logger.info("Established connection to " + this);
                this.state = 6;
                this.handler.connectionReady(this);
                return true;
            }
            this.close(null);
            return false;
        }
        catch (ParseException e) {
            this.close(new IOException("Failed to decode HTTP request, " + e.getMessage()));
            return false;
        }
        catch (NumberFormatException e) {
            this.close(new IOException("Failed to decode HTTP request, " + e.getMessage()));
            return false;
        }
        catch (IOException e) {
            this.close(e);
            return false;
        }
    }

    public void sendChunk(Bufferlo data) {
        this.manager.getNIODaemon().invokeAndWait(new SendChunk(this, data));
    }

    private boolean handleChunk() {
        try {
            if (this.sourceChunked) {
                int chunkEndIndex = this.parser.indexOf("\\r\\n");
                if (chunkEndIndex == -1) {
                    return false;
                }
                String chunkSizeInHex = this.parser.readUntil("(\\;[^\\r\\n]*)?\\r\\n", false);
                int chunkSize = Integer.parseInt(chunkSizeInHex, 16);
                int bytesRequired = chunkEndIndex + 2 + chunkSize + 2;
                if (this.parser.length() < bytesRequired) {
                    return false;
                }
                this.parser.consume("[^\\r\\n]*\\r\\n");
                Bufferlo chunkData = this.parser.consume(chunkSize);
                this.parser.consume("\\r\\n");
                if (chunkData.length() > 0) {
                    this.handler.receiveChunk(this, chunkData);
                    return true;
                }
                this.close();
                return false;
            }
            Bufferlo chunkData = this.parser.consume(this.parser.length());
            if (chunkData.length() > 0) {
                this.handler.receiveChunk(this, chunkData);
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            this.close(new IOException("Failed to decode HTTP request, " + e.getMessage()));
            return false;
        }
        catch (ParseException e) {
            this.close(new IOException("Failed to decode HTTP request, " + e.getMessage()));
            return false;
        }
    }

    public String toString() {
        return this.localHost + ":" + this.getLocalPort() + "<->" + this.remoteHost + ":" + this.getRemotePort();
    }

    public synchronized void close() {
        this.close(null);
    }

    public void close(Exception reason) {
        this.manager.getNIODaemon().invokeLater(new CloseConnection(this, reason));
    }

    private void writeHeaders(Map headers) throws IOException {
        for (Map.Entry mapEntry : headers.entrySet()) {
            this.writer.write(mapEntry.getKey().toString());
            this.writer.write(": ");
            this.writer.write(mapEntry.getValue().toString());
            this.writer.write("\r\n");
        }
    }

    private Map readHeaders() throws IOException, ParseException {
        TreeMap<String, String> headers = new TreeMap<String, String>();
        while (this.parser.indexOf("\\r\\n") != 0) {
            String key = this.parser.readUntil("\\:( )*");
            String value = this.parser.readUntil("\\r\\n");
            headers.put(key, value);
        }
        return headers;
    }

    private void handleHeaders(Map headers) {
        this.sourceChunked = "chunked".equals(headers.get("Transfer-Encoding"));
        String headerLocalHost = (String)headers.get("Host");
        if (headerLocalHost != null) {
            this.localHost = headerLocalHost;
        }
    }
}

