/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.event;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.BarcodeListDeltas;
import ca.odell.glazedlists.event.BarcodeListDeltasListEvent;
import ca.odell.glazedlists.event.Block;
import ca.odell.glazedlists.event.BlockDeltasListEvent;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.event.SequenceDependenciesEventPublisher;
import ca.odell.glazedlists.event.Tree4DeltasListEvent;
import ca.odell.glazedlists.impl.WeakReferenceProxy;
import ca.odell.glazedlists.impl.event.BlockSequence;
import ca.odell.glazedlists.impl.event.Tree4Deltas;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListEventAssembler<E> {
    private final AssemblerHelper<E> delegate;
    private static final String assemblerName;

    private static <E> AssemblerHelper<E> createAssemblerDelegate(EventList<E> sourceList, ListEventPublisher publisher) {
        if (assemblerName.equals("treedeltas")) {
            return new Tree4DeltasAssembler<E>(sourceList, publisher);
        }
        if (assemblerName.equals("blockdeltas")) {
            return new BlockDeltasAssembler<E>(sourceList, publisher);
        }
        if (assemblerName.equals("barcodedeltas")) {
            return new BarcodeDeltasAssembler<E>(sourceList, publisher);
        }
        throw new IllegalStateException();
    }

    public static ListEventPublisher createListEventPublisher() {
        return new SequenceDependenciesEventPublisher();
    }

    public ListEventAssembler(EventList<E> sourceList, ListEventPublisher publisher) {
        this.delegate = ListEventAssembler.createAssemblerDelegate(sourceList, publisher);
    }

    public synchronized void beginEvent() {
        this.delegate.beginEvent(false);
    }

    public synchronized void beginEvent(boolean allowNestedEvents) {
        this.delegate.beginEvent(allowNestedEvents);
    }

    public void elementInserted(int index, E newValue) {
        this.delegate.addChange(2, index, index, ListEvent.UNKNOWN_VALUE, newValue);
    }

    public void elementUpdated(int index, E oldValue, E newValue) {
        this.delegate.addChange(1, index, index, oldValue, newValue);
    }

    public void elementDeleted(int index, E oldValue) {
        this.delegate.addChange(0, index, index, oldValue, ListEvent.UNKNOWN_VALUE);
    }

    public void elementUpdated(int index, E oldValue) {
        this.elementUpdated(index, oldValue, ListEvent.UNKNOWN_VALUE);
    }

    public void addChange(int type, int startIndex, int endIndex) {
        this.delegate.addChange(type, startIndex, endIndex, ListEvent.UNKNOWN_VALUE, ListEvent.UNKNOWN_VALUE);
    }

    public void addChange(int type, int index) {
        this.addChange(type, index, index);
    }

    public void addInsert(int index) {
        this.addChange(2, index);
    }

    public void addDelete(int index) {
        this.addChange(0, index);
    }

    public void addUpdate(int index) {
        this.addChange(1, index);
    }

    public void addInsert(int startIndex, int endIndex) {
        this.addChange(2, startIndex, endIndex);
    }

    public void addDelete(int startIndex, int endIndex) {
        this.addChange(0, startIndex, endIndex);
    }

    public void addUpdate(int startIndex, int endIndex) {
        this.addChange(1, startIndex, endIndex);
    }

    public void reorder(int[] reorderMap) {
        this.delegate.reorder(reorderMap);
    }

    public void forwardEvent(ListEvent<?> listChanges) {
        this.delegate.forwardEvent(listChanges);
    }

    public synchronized void commitEvent() {
        this.delegate.commitEvent();
    }

    public synchronized void discardEvent() {
        this.delegate.discardEvent();
    }

    public boolean isEventEmpty() {
        return this.delegate.isEventEmpty();
    }

    public synchronized void addListEventListener(ListEventListener<? super E> listChangeListener) {
        this.delegate.publisherAdapter.addListEventListener(listChangeListener, this.delegate.createListEvent());
    }

    public synchronized void removeListEventListener(ListEventListener<? super E> listChangeListener) {
        this.delegate.publisherAdapter.removeListEventListener(listChangeListener);
    }

    public List<ListEventListener<E>> getListEventListeners() {
        return this.delegate.getListEventListeners();
    }

    static {
        String assemblerProperty = null;
        try {
            assemblerProperty = System.getProperty("GlazedLists.ListEventAssemblerDelegate");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        assemblerName = assemblerProperty != null ? assemblerProperty : "treedeltas";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListSequencePublisherAdapter<E>
    implements PublisherAdapter<E> {
        private final EventList<E> sourceList;
        private final SequenceDependenciesEventPublisher publisherSequenceDependencies;
        private ListEvent<E> listEvent = null;
        private final ListEventFormat<E> eventFormat;
        private boolean eventEnqueued = false;

        public ListSequencePublisherAdapter(AssemblerHelper<E> assemblerDelegate, ListEventPublisher publisherSequenceDependencies) {
            this.sourceList = assemblerDelegate.sourceList;
            this.eventFormat = new ListEventFormat<E>(assemblerDelegate);
            this.publisherSequenceDependencies = (SequenceDependenciesEventPublisher)publisherSequenceDependencies;
        }

        @Override
        public void addListEventListener(ListEventListener<? super E> listChangeListener, ListEvent<E> listEvent) {
            this.publisherSequenceDependencies.addListener(this.sourceList, listChangeListener, this.eventFormat);
            if (this.listEvent == null) {
                this.listEvent = listEvent;
            }
        }

        @Override
        public void removeListEventListener(ListEventListener<? super E> listener) {
            this.publisherSequenceDependencies.removeListener(this.sourceList, listener);
        }

        @Override
        public List<ListEventListener<E>> getListEventListeners() {
            return this.publisherSequenceDependencies.getListeners(this.sourceList);
        }

        @Override
        public void fireEvent() {
            if (this.eventEnqueued) {
                return;
            }
            this.eventEnqueued = true;
            this.publisherSequenceDependencies.fireEvent(this.sourceList, this.listEvent, this.eventFormat);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ListEventFormat<E>
        implements SequenceDependenciesEventPublisher.EventFormat<EventList<E>, ListEventListener<? super E>, ListEvent<E>> {
            private AssemblerHelper<E> assemblerDelegate;

            public ListEventFormat(AssemblerHelper<E> assemblerDelegate) {
                this.assemblerDelegate = assemblerDelegate;
            }

            @Override
            public void fire(EventList<E> subject, ListEvent<E> event, ListEventListener<? super E> listener) {
                event.reset();
                listener.listChanged(event);
            }

            @Override
            public void postEvent(EventList<E> subject) {
                this.assemblerDelegate.eventPending = false;
                this.assemblerDelegate.cleanup();
                ((ListSequencePublisherAdapter)this.assemblerDelegate.publisherAdapter).eventEnqueued = false;
            }

            @Override
            public boolean isStale(EventList<E> subject, ListEventListener<? super E> listener) {
                if (listener instanceof WeakReferenceProxy && ((WeakReferenceProxy)listener).getReferent() == null) {
                    ((WeakReferenceProxy)listener).dispose();
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface PublisherAdapter<E> {
        public void addListEventListener(ListEventListener<? super E> var1, ListEvent<E> var2);

        public void removeListEventListener(ListEventListener<? super E> var1);

        public List<ListEventListener<E>> getListEventListeners();

        public void fireEvent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BlockDeltasAssembler<E>
    extends AssemblerHelper<E> {
        private List<Block> atomicChangeBlocks = null;
        private Block atomicLatestBlock = null;

        public BlockDeltasAssembler(EventList<E> sourceList, ListEventPublisher publisher) {
            super(sourceList, publisher);
        }

        @Override
        protected ListEvent<E> createListEvent() {
            return new BlockDeltasListEvent(this, this.sourceList);
        }

        @Override
        protected void prepareEvent() {
            this.atomicChangeBlocks = new ArrayList<Block>();
            this.atomicLatestBlock = null;
            this.reorderMap = null;
        }

        @Override
        public void addChange(int type, int startIndex, int endIndex, E oldValue, E newValue) {
            boolean appendSuccess;
            if (this.atomicLatestBlock != null && (appendSuccess = this.atomicLatestBlock.append(startIndex, endIndex, type))) {
                return;
            }
            this.atomicLatestBlock = new Block(startIndex, endIndex, type);
            this.atomicChangeBlocks.add(this.atomicLatestBlock);
        }

        @Override
        public boolean isEventEmpty() {
            return this.atomicChangeBlocks == null || this.atomicChangeBlocks.isEmpty();
        }

        @Override
        protected void beforeFireEvent() {
            Block.sortListEventBlocks(this.atomicChangeBlocks, this.getAllowContradictingEvents());
        }

        @Override
        public void cleanup() {
            this.atomicChangeBlocks = null;
            this.atomicLatestBlock = null;
            this.reorderMap = null;
            this.setAllowContradictingEvents(false);
        }

        List<Block> getBlocks() {
            return this.atomicChangeBlocks;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Tree4DeltasAssembler<E>
    extends AssemblerHelper<E> {
        private BlockSequence<E> blockSequence = new BlockSequence();
        private boolean useListBlocksLinear = false;
        private Tree4Deltas<E> listDeltas = new Tree4Deltas();

        public Tree4DeltasAssembler(EventList<E> sourceList, ListEventPublisher publisher) {
            super(sourceList, publisher);
        }

        @Override
        protected void prepareEvent() {
            this.useListBlocksLinear = true;
        }

        @Override
        protected void setAllowContradictingEvents(boolean allowContradictingEvents) {
            super.setAllowContradictingEvents(allowContradictingEvents);
            this.listDeltas.setAllowContradictingEvents(allowContradictingEvents);
        }

        @Override
        public void addChange(int type, int startIndex, int endIndex, E oldValue, E newValue) {
            if (this.useListBlocksLinear) {
                boolean success = this.blockSequence.addChange(type, startIndex, endIndex + 1, oldValue, newValue);
                if (success) {
                    return;
                }
                this.listDeltas.addAll(this.blockSequence);
                this.useListBlocksLinear = false;
            }
            switch (type) {
                case 2: {
                    this.listDeltas.targetInsert(startIndex, endIndex + 1, newValue);
                    break;
                }
                case 1: {
                    this.listDeltas.targetUpdate(startIndex, endIndex + 1, oldValue, newValue);
                    break;
                }
                case 0: {
                    this.listDeltas.targetDelete(startIndex, endIndex + 1, oldValue);
                }
            }
        }

        public boolean getUseListBlocksLinear() {
            return this.useListBlocksLinear;
        }

        public Tree4Deltas getListDeltas() {
            return this.listDeltas;
        }

        public BlockSequence getListBlocksLinear() {
            return this.blockSequence;
        }

        @Override
        public boolean isEventEmpty() {
            if (this.useListBlocksLinear) {
                return this.blockSequence.isEmpty();
            }
            return this.listDeltas.isEmpty();
        }

        @Override
        public void cleanup() {
            this.blockSequence.reset();
            this.listDeltas.reset(this.sourceList.size());
            this.reorderMap = null;
            this.setAllowContradictingEvents(false);
        }

        @Override
        protected ListEvent<E> createListEvent() {
            return new Tree4DeltasListEvent(this, this.sourceList);
        }

        public String toString() {
            return this.listDeltas.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BarcodeDeltasAssembler<E>
    extends AssemblerHelper<E> {
        private BarcodeListDeltas listDeltas = new BarcodeListDeltas();

        public BarcodeDeltasAssembler(EventList<E> sourceList, ListEventPublisher publisher) {
            super(sourceList, publisher);
        }

        @Override
        protected void prepareEvent() {
            this.listDeltas.reset(this.sourceList.size());
        }

        @Override
        public void addChange(int type, int startIndex, int endIndex, E oldValue, E newValue) {
            for (int i = startIndex; i <= endIndex; ++i) {
                if (type == 2) {
                    this.listDeltas.add(i);
                    continue;
                }
                if (type == 1) {
                    this.listDeltas.update(i);
                    continue;
                }
                if (type != 0) continue;
                this.listDeltas.remove(startIndex);
            }
        }

        public BarcodeListDeltas getListDeltas() {
            return this.listDeltas;
        }

        @Override
        public boolean isEventEmpty() {
            return this.listDeltas.isEmpty();
        }

        @Override
        public void cleanup() {
            this.listDeltas.reset(0);
            this.reorderMap = null;
            this.setAllowContradictingEvents(false);
        }

        @Override
        protected ListEvent<E> createListEvent() {
            return new BarcodeListDeltasListEvent(this, this.sourceList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AssemblerHelper<E> {
        private Thread eventThread;
        protected EventList<E> sourceList;
        protected int[] reorderMap = null;
        protected PublisherAdapter<E> publisherAdapter;
        protected int eventLevel = 0;
        protected boolean eventPending = false;
        protected boolean allowNestedEvents = true;
        private boolean allowContradictingEvents = false;

        protected AssemblerHelper(EventList<E> sourceList, ListEventPublisher publisher) {
            this.sourceList = sourceList;
            this.publisherAdapter = new ListSequencePublisherAdapter(this, publisher);
        }

        public final void beginEvent(boolean allowNestedEvents) {
            if (!this.allowNestedEvents) {
                throw new ConcurrentModificationException("Cannot begin a new event while another event is in progress by thread, " + this.eventThread.getName());
            }
            this.allowNestedEvents = allowNestedEvents;
            if (allowNestedEvents || this.eventLevel == 0 && this.eventPending) {
                this.setAllowContradictingEvents(true);
            }
            if (!this.eventPending) {
                this.eventPending = true;
                this.eventThread = Thread.currentThread();
                this.prepareEvent();
            }
            ++this.eventLevel;
        }

        protected abstract void prepareEvent();

        protected void setAllowContradictingEvents(boolean allowContradictingEvents) {
            this.allowContradictingEvents = allowContradictingEvents;
        }

        protected boolean getAllowContradictingEvents() {
            return this.allowContradictingEvents;
        }

        public void reorder(int[] reorderMap) {
            if (!this.isEventEmpty()) {
                throw new IllegalStateException("Cannot combine reorder with other change events");
            }
            if (reorderMap.length == 0) {
                return;
            }
            this.addChange(0, 0, reorderMap.length - 1, ListEvent.UNKNOWN_VALUE, ListEvent.UNKNOWN_VALUE);
            this.addChange(2, 0, reorderMap.length - 1, ListEvent.UNKNOWN_VALUE, ListEvent.UNKNOWN_VALUE);
            this.reorderMap = reorderMap;
        }

        public abstract void addChange(int var1, int var2, int var3, E var4, E var5);

        public abstract boolean isEventEmpty();

        public final synchronized void commitEvent() {
            if (this.eventLevel == 0) {
                throw new IllegalStateException("Cannot commit without an event in progress");
            }
            --this.eventLevel;
            this.allowNestedEvents = true;
            if (this.eventLevel == 0) {
                this.beforeFireEvent();
                if (!this.isEventEmpty()) {
                    this.publisherAdapter.fireEvent();
                } else {
                    this.eventPending = false;
                    this.cleanup();
                }
            }
        }

        public final synchronized void discardEvent() {
            if (this.eventLevel == 0) {
                throw new IllegalStateException("Cannot discard without an event in progress");
            }
            --this.eventLevel;
            this.allowNestedEvents = true;
            if (this.eventLevel == 0) {
                this.eventPending = false;
                this.cleanup();
            }
        }

        protected void beforeFireEvent() {
        }

        public final synchronized void forwardEvent(ListEvent<?> listChanges) {
            this.beginEvent(false);
            this.reorderMap = null;
            if (this.isEventEmpty() && listChanges.isReordering()) {
                this.reorder(listChanges.getReorderMap());
            } else {
                while (listChanges.next()) {
                    int type = listChanges.getType();
                    int index = listChanges.getIndex();
                    Object oldValue = listChanges.getOldValue();
                    Object newValue = listChanges.getNewValue();
                    this.addChange(type, index, index, oldValue, newValue);
                }
                listChanges.reset();
            }
            this.commitEvent();
        }

        public abstract void cleanup();

        int[] getReorderMap() {
            return this.reorderMap;
        }

        protected abstract ListEvent<E> createListEvent();

        public List<ListEventListener<E>> getListEventListeners() {
            return this.publisherAdapter.getListEventListeners();
        }
    }
}

